/*
 * Decompiled with CFR 0.152.
 */
package pedersen.movement.vectorsum;

import java.util.HashSet;
import java.util.Set;
import pedersen.movement.MovementMethod;
import pedersen.movement.MovementMethodBase;
import pedersen.movement.vector.MovementMethodVector;
import pedersen.physics.DistanceVector;
import pedersen.physics.HasDirection;
import pedersen.physics.HasPosition;
import pedersen.physics.Position;
import pedersen.physics.Vehicle;
import pedersen.physics.constant.DistanceVectorImpl;
import pedersen.physics.constant.PhysicsConstants;
import pedersen.physics.constant.VehicleImpl;

public abstract class MovementMethodVectorSumBase
extends MovementMethodBase
implements MovementMethod {
    protected final Set<MovementMethodVector> vectors = new HashSet<MovementMethodVector>();
    protected static final double fullSpeedVelocity = 50.0;

    protected MovementMethodVectorSumBase() {
    }

    @Override
    public Vehicle getDestination() {
        Position vectorSum = PhysicsConstants.anchorPosition;
        for (MovementMethodVector movementMethod : this.vectors) {
            DistanceVector vector = movementMethod.getVector();
            if (vector == null) continue;
            vectorSum = vectorSum.addVector(vector);
        }
        DistanceVectorImpl movementVector = new DistanceVectorImpl((HasDirection)PhysicsConstants.anchorPosition.getBearing(vectorSum), PhysicsConstants.anchorPosition.getDistance(vectorSum));
        Position projectedPosition = super.getCombatantSnapshot().getPosition().addVector(movementVector);
        VehicleImpl destination = new VehicleImpl((HasPosition)projectedPosition, (HasDirection)movementVector.getDirection(), movementVector.getMagnitude().magnitude());
        return destination;
    }
}

