/*
 * Decompiled with CFR 0.152.
 */
package pedersen.physics.constant;

import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Set;
import pedersen.debug.DebuggableBase;
import pedersen.physics.BearingOffsetRange;
import pedersen.physics.Circle;
import pedersen.physics.HasCircle;
import pedersen.physics.HasPosition;
import pedersen.physics.HasRadius;
import pedersen.physics.Position;
import pedersen.physics.Radius;
import pedersen.physics.SlopeFormula;
import pedersen.physics.constant.PositionImpl;
import pedersen.physics.constant.RadiusImpl;
import pedersen.util.Constraints;

public class CircleImpl
extends DebuggableBase
implements Circle {
    private final Position position;
    private final Radius radius;
    private final double h;
    private final double k;
    private final double r;
    private final double rSquared;

    public CircleImpl(HasPosition position, HasRadius radius) {
        this.position = position.getPosition();
        this.radius = radius.getRadius();
        this.h = this.position.getX();
        this.k = this.position.getY();
        this.r = this.radius.radius();
        this.rSquared = CircleImpl.square(this.r);
    }

    public CircleImpl(double x, double y, double radius) {
        this((HasPosition)new PositionImpl(x, y), new RadiusImpl(radius));
    }

    public CircleImpl(HasPosition position, double radius) {
        this(position, new RadiusImpl(radius));
    }

    @Override
    public Circle getCircle() {
        return this;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public Radius getRadius() {
        return this.radius;
    }

    @Override
    public boolean equalsCircle(HasCircle other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return this.position.equals(other) && this.radius.equalsRadius(other.getCircle());
    }

    @Override
    public Ellipse2D.Double getEllipse2D() {
        return new Ellipse2D.Double(this.h - this.r, this.k - this.r, this.r + this.r, this.r + this.r);
    }

    @Override
    public Set<Double> getFunctionOfX(double x) {
        HashSet<Double> set = new HashSet<Double>();
        double sqrt = Math.sqrt(this.rSquared - (x - this.h) * (x - this.h));
        if (sqrt != Double.NaN) {
            set.add(this.k + sqrt);
            set.add(this.k - sqrt);
        }
        return set;
    }

    @Override
    public Set<Double> getFunctionOfY(double y) {
        HashSet<Double> set = new HashSet<Double>();
        double sqrt = Math.sqrt(this.rSquared - (y - this.k) * (y - this.k));
        if (sqrt != Double.NaN) {
            set.add(this.h + sqrt);
            set.add(this.h - sqrt);
        }
        return set;
    }

    @Override
    public Set<Point2D.Double> getPointsOfIntersection(Line2D.Double representativeSegment) {
        HashSet<Point2D.Double> points = new HashSet<Point2D.Double>();
        double x1 = representativeSegment.x1 - this.h;
        double x2 = representativeSegment.x2 - this.h;
        double y1 = representativeSegment.y1 - this.k;
        double y2 = representativeSegment.y2 - this.k;
        double dx = x2 - x1;
        double dy = y2 - y1;
        double drsq = dx * dx + dy * dy;
        double D = x1 * y2 - x2 * y1;
        double sp = dy < 0.0 ? -1.0 : 1.0;
        double descriminant = this.rSquared * drsq - D * D;
        if (!(descriminant < 0.0)) {
            if (descriminant == 0.0) {
                double x = D * dy / drsq;
                double y = -D * dx / drsq;
                points.add(new Point2D.Double(x + this.h, y + this.k));
            } else if (descriminant > 0.0) {
                double calc1 = Math.sqrt(descriminant);
                double calc2 = sp * dx * calc1;
                double calc3 = Math.abs(dy) * calc1;
                double x_1 = (D * dy + calc2) / drsq;
                double x_2 = (D * dy - calc2) / drsq;
                double y_1 = (-D * dx + calc3) / drsq;
                double y_2 = (-D * dx - calc3) / drsq;
                SlopeFormula line = new SlopeFormula((HasPosition)new PositionImpl(x1, y1), new PositionImpl(x2, y2));
                if (Constraints.areEqual(y_1, line.getFunctionOfX(x_1))) {
                    points.add(new Point2D.Double(x_1 + this.h, y_1 + this.k));
                }
                if (Constraints.areEqual(y_2, line.getFunctionOfX(x_1))) {
                    points.add(new Point2D.Double(x_1 + this.h, y_2 + this.k));
                }
                if (Constraints.areEqual(y_1, line.getFunctionOfX(x_2))) {
                    points.add(new Point2D.Double(x_2 + this.h, y_1 + this.k));
                }
                if (Constraints.areEqual(y_2, line.getFunctionOfX(x_2))) {
                    points.add(new Point2D.Double(x_2 + this.h, y_2 + this.k));
                }
            }
        }
        return points;
    }

    @Override
    public BearingOffsetRange getRangeOfIntersection(HasCircle other) {
        double d = this.position.getDistance(other.getCircle()).distance();
        double r2 = other.getCircle().getRadius().radius();
        if (d != 0.0 && Constraints.isInRange(Math.abs(r2 - this.r), d, this.r + r2)) {
            double x = (this.rSquared - r2 * r2 + d * d) / (d + d);
            double y = Math.sqrt(this.rSquared - x * x);
            double theta = Math.atan(y / x);
            return new BearingOffsetRange(-theta, theta);
        }
        return null;
    }

    private static double square(double value) {
        return value * value;
    }

    @Override
    public String description() {
        return "( " + super.trim(this.position.getX()) + ", " + super.trim(this.position.getY()) + ", " + super.trim(this.radius.radius()) + " )";
    }
}

