/*
 * Decompiled with CFR 0.152.
 */
package pedersen.util;

import pedersen.debug.Console;
import pedersen.debug.Metrics;

public class ExceptionHandler {
    protected static void commit(String method, String symptom) {
        Console.getInstance().log(symptom);
    }

    public static void handleException(Exception ex) {
        if (ex != null) {
            Metrics.getInstance().incrementExceptionCount();
            ExceptionHandler.commit(ExceptionHandler.getCallingMethod(), ExceptionHandler.translateExceptionStackTraceIntoString(ex));
        }
    }

    public static String translateExceptionStackTraceIntoString(Exception ex) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(ex.toString());
        StackTraceElement[] stackTraceElement = ex.getStackTrace();
        int i = 0;
        while (i < stackTraceElement.length) {
            buffer.append("\n").append(stackTraceElement[i].toString());
            ++i;
        }
        return buffer.toString();
    }

    public static String getCallingMethod() {
        StringBuffer method = new StringBuffer();
        StackTraceElement source = new Throwable().getStackTrace()[2];
        method.append(source.getClassName());
        method.append(".");
        method.append(source.getMethodName());
        method.append("(");
        method.append(source.getFileName());
        method.append(":");
        method.append(source.getLineNumber());
        method.append(")");
        return method.toString();
    }

    public static String getCallingMethod(int index) {
        StringBuffer method = new StringBuffer();
        StackTraceElement source = new Throwable().getStackTrace()[index];
        method.append(source.getClassName());
        method.append(".");
        method.append(source.getMethodName());
        method.append("(");
        method.append(source.getFileName());
        method.append(":");
        method.append(source.getLineNumber());
        method.append(")");
        return method.toString();
    }
}

