/*
 * Decompiled with CFR 0.152.
 */
package microtestbotpack;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

public class MicroTestBot
extends AdvancedRobot {
    private final boolean ANY_DEBUG = true;
    private final boolean TO_LOG_FILE = true;
    private final boolean TO_CONSOLE = false;
    private final boolean SWITCH_DEBUG = true;
    private final boolean INPUTS_LOGGING = true;
    private final boolean OUTPUTS_LOGGING = true;
    private final boolean OBJECTS_LOGGING = true;
    private final boolean A0_LOGGING = true;
    private final boolean A0_BEGIN_LOGGING = true;
    private final boolean A0_END_LOGGING = true;
    private final boolean A0_ERROR_LOGGING = true;
    private final boolean A0_TRANS_LOGGING = true;
    private final double precision = 1.0E-6;
    private final double PI = Math.PI;
    private final double dPI = Math.PI * 2;
    private final double PI2 = 1.5707963267948966;
    private final double gun_rotation_speed = Math.toRadians(20.0);
    private final double speed_max = 8.0;
    private final double turning_speed_max = Math.toRadians(10.0);
    private final double max_firepower = 3.0;
    private final double base_firepower = 1.5;
    private final double fire_delay_critical = 400.0;
    private final double life_ok = 50.0;
    private final double life_warning = 30.0;
    private final double life_critical = 15.0;
    private double battlefield_width;
    private double battlefield_height;
    private double robot_size;
    private double robot_size2;
    private double collision_delta;
    private int cur_robots_count;
    private int total_robots_count;
    private long cur_time;
    private Random random = new Random();
    private double cur_life;
    private long last_fire_time;
    private long hits;
    private long misses;
    private long hitted_by_bullet;
    private long walls_collisions;
    private radar_t radar;
    private driver_t driver;
    private gunner_t gunner;
    private targets_t targets;
    private Vector events;
    private int y0 = 0;

    public void run() {
        this.A0(9);
        while (true) {
            this.cur_time = this.getTime();
            this.log("--------- " + this.cur_time + " ---------");
            this.check_events();
            this.A0(10);
            this.gunner.begin_turn();
            this.radar.begin_turn();
            this.driver.begin_turn();
            this.end_turn();
        }
    }

    public void onBulletHit(BulletHitEvent first_e) {
        this.events.add(first_e);
    }

    public void onBulletMissed(BulletMissedEvent first_e) {
        this.events.add(first_e);
    }

    public void onBulletHitBullet(BulletHitBulletEvent first_e) {
        this.events.add(first_e);
    }

    public void onScannedRobot(ScannedRobotEvent first_e) {
        this.events.add(first_e);
    }

    public void onRobotDeath(RobotDeathEvent first_e) {
        this.events.add(first_e);
    }

    public void onHitRobot(HitRobotEvent first_e) {
        this.events.add(first_e);
    }

    public void onHitWall(HitWallEvent first_e) {
        this.events.add(first_e);
    }

    public void onHitByBullet(HitByBulletEvent first_e) {
        this.events.add(first_e);
    }

    public void onWin(WinEvent first_e) {
        this.A0(21);
    }

    public void onDeath(DeathEvent first_e) {
        this.A0(20);
    }

    private void A0(int e) {
        int y_old = this.y0;
        this.log("\u0414\u043b\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 '\u0421\u0443\u043f\u0435\u0440\u0432\u0438\u0437\u043e\u0440':");
        this.log_begin("A0", this.y0, e);
        switch (this.y0) {
            case 0: {
                if (e != 9) break;
                this.z10_0();
                this.y0 = 1;
                break;
            }
            case 1: {
                if (e == 20 || e == 21) {
                    this.y0 = 2;
                    break;
                }
                if (e != 10) break;
                this.z10_2();
                break;
            }
            case 2: {
                if (e != 9) break;
                this.y0 = 1;
                break;
            }
            default: {
                this.log_error("A0", this.y0);
            }
        }
        if (this.y0 != y_old) {
            this.log_trans("A0", this.y0, y_old);
            switch (this.y0) {
                case 1: {
                    this.z10_1();
                    this.z10_2();
                    break;
                }
                case 2: {
                    this.z20();
                    break;
                }
                default: {
                    this.log_error("A0", this.y0);
                }
            }
        }
        this.log_end("A0", this.y0);
    }

    private void z10_0() {
        this.log_output("z10_0", "\u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u043f\u0440\u0438 \u0437\u0430\u043f\u0443\u0441\u043a\u0435");
        this.setEventPriority("RobotDeathEvent", 17);
        this.setEventPriority("ScannedRobotEvent", 16);
        this.setEventPriority("HitRobotEvent", 15);
        this.setEventPriority("HitWallEvent", 14);
        this.setEventPriority("BulletHitEvent", 13);
        this.setEventPriority("HitByBulletEvent", 12);
        this.setEventPriority("BulletMissedEvent", 11);
        this.battlefield_width = this.getBattleFieldWidth();
        this.battlefield_height = this.getBattleFieldHeight();
        this.robot_size = (this.getWidth() + this.getHeight()) / 2.0;
        this.robot_size2 = this.robot_size / 2.0;
        this.collision_delta = this.robot_size2 - 5.0;
        this.hits = 0L;
        this.misses = 0L;
        this.hitted_by_bullet = 0L;
        this.walls_collisions = 0L;
        this.total_robots_count = this.getOthers();
        this.targets = new targets_t();
        this.radar = new radar_t();
        this.driver = new driver_t();
        this.gunner = new gunner_t();
        this.events = new Vector();
    }

    private void z10_1() {
        this.log_output("z10_1", "\u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0432 \u043d\u0430\u0447\u0430\u043b\u0435 \u0440\u0430\u0443\u043d\u0434\u0430");
        this.log("");
        this.log("====================================");
        this.log("***");
        this.log("*** \u0420\u0430\u0443\u043d\u0434 " + (this.getRoundNum() + 1));
        this.log("***");
        this.log("====================================");
        this.log("");
        this.clearAllEvents();
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.cur_time = 0L;
        this.targets.begin_round();
        this.driver.begin_round();
        this.radar.begin_round();
        this.gunner.begin_round();
        if (this.events != null) {
            this.events.clear();
        }
    }

    private void z10_2() {
        this.log_output("z10_2", "\u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0432 \u043d\u0430\u0447\u0430\u043b\u0435 \u0448\u0430\u0433\u0430");
        this.cur_robots_count = this.getOthers();
        this.cur_life = this.getLife();
        this.targets.begin_turn();
    }

    private void z20() {
        this.log_output("z20", "\u0412\u044b\u0432\u0435\u0441\u0442\u0438 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0443 \u0440\u0430\u0443\u043d\u0434\u0430");
        this.show_statistics();
    }

    private void check_events() {
        for (Event e : this.events) {
            if (e instanceof ScannedRobotEvent) {
                this.targets.update((ScannedRobotEvent)e);
                continue;
            }
            if (e instanceof BulletHitEvent) {
                this.targets.hit((BulletHitEvent)e);
                ++this.hits;
                continue;
            }
            if (e instanceof RobotDeathEvent) {
                this.targets.one_less((RobotDeathEvent)e);
                continue;
            }
            if (e instanceof HitRobotEvent) {
                this.driver.robot_collision();
                this.targets.collide((HitRobotEvent)e);
                continue;
            }
            if (e instanceof HitWallEvent) {
                this.driver.wall_collision();
                ++this.walls_collisions;
                continue;
            }
            if (e instanceof BulletMissedEvent) {
                ++this.misses;
                continue;
            }
            if (!(e instanceof HitByBulletEvent)) continue;
            this.driver.hit_by_bullet();
            this.targets.hit_by_bullet((HitByBulletEvent)e);
            ++this.hitted_by_bullet;
        }
        this.events.clear();
    }

    private void end_turn() {
        this.driver.end_turn();
        this.radar.end_turn();
        this.gunner.end_turn();
    }

    private void show_statistics() {
        long shots = this.hits + this.misses;
        this.targets.show_statistics();
        this.log("\u0412\u044b\u0441\u0442\u0440\u0435\u043b\u043e\u0432: " + shots + ", \u043f\u043e\u043f\u0430\u0434\u0430\u043d\u0438\u0439: " + this.hits + ", \u043f\u0440\u043e\u043c\u0430\u0445\u043e\u0432: " + this.misses);
        this.log("\u041c\u0435\u0442\u043a\u043e\u0441\u0442\u044c: " + (double)this.hits / (double)shots);
        this.log("\u041f\u043e\u043f\u0430\u043b\u0438 \u0432 \u043d\u0430\u0441: " + this.hitted_by_bullet);
        this.log("\u0421\u0442\u043e\u043b\u043a\u043d\u043e\u0432\u0435\u043d\u0438\u0439 \u0441\u043e \u0441\u0442\u0435\u043d\u0430\u043c\u0438: " + this.walls_collisions);
    }

    private vect_t get_path(double v, double w, double heading, double T) {
        vect_t path;
        if (Math.abs(w) > 1.0E-6) {
            double R = Math.abs(v / w);
            double to_circle_center = this.normalize_angle(w * v >= 0.0 ? heading + 1.5707963267948966 : heading - 1.5707963267948966);
            double from_circle_center = this.normalize_angle(to_circle_center + Math.PI + w * T);
            path = new vect_t(to_circle_center, R);
            path.addrad(from_circle_center, R);
        } else {
            path = new vect_t(heading, v * T);
        }
        return path;
    }

    private double get_bullet_speed(double firepower) {
        return 20.0 - 3.0 * firepower;
    }

    private double get_turning_speed(double speed) {
        return Math.min(this.turning_speed_max, this.turning_speed_max * (0.4 + 0.6 * (1.0 - speed / 8.0)));
    }

    private double normalize_angle(double a) {
        a = Math.PI * 2 + a % (Math.PI * 2);
        return a %= Math.PI * 2;
    }

    private double get_angle_diff(double from, double to) {
        double diff = to - from;
        if (Math.abs(diff) <= Math.PI) {
            return diff;
        }
        if (diff < 0.0) {
            diff += Math.PI * 2;
        } else if (diff > 0.0) {
            diff -= Math.PI * 2;
        }
        return diff % (Math.PI * 2);
    }

    private double shortest_turn(double da) {
        if (da > Math.PI) {
            da -= Math.PI * 2;
        } else if (da < -Math.PI) {
            da += Math.PI * 2;
        }
        return da;
    }

    private double get_angle(double x, double y) {
        if (y == 0.0) {
            return x > 0.0 ? 1.5707963267948966 : 4.71238898038469;
        }
        double a = Math.atan(x / y);
        if (y < 0.0) {
            a += Math.PI;
        }
        return a;
    }

    private void log(String str) {
        System.out.println(str);
    }

    private void log(String str, String symbol) {
        String out_str = String.valueOf(symbol) + " " + str;
        System.out.println(out_str);
    }

    private void log_begin(String a_name, int state, int event) {
        this.log(String.valueOf(a_name) + ": \u0410\u0432\u0442\u043e\u043c\u0430\u0442 " + a_name + " \u0437\u0430\u043f\u0443\u0449\u0435\u043d \u0432 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0438 " + state + " \u0441 \u0441\u043e\u0431\u044b\u0442\u0438\u0435\u043c e" + event, "{");
    }

    private void log_end(String a_name, int state) {
        this.log(String.valueOf(a_name) + ": \u0410\u0432\u0442\u043e\u043c\u0430\u0442 " + a_name + " \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b \u0441\u0432\u043e\u044e \u0440\u0430\u0431\u043e\u0442\u0443 \u0432 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0438 " + state, "}");
    }

    private void log_error(String a_name, int state) {
        this.log(String.valueOf(a_name) + ": \u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 " + state + "!", "!");
    }

    private void log_trans(String a_name, int state_to, int state_from) {
        this.log(String.valueOf(a_name) + ": \u0410\u0432\u0442\u043e\u043c\u0430\u0442 " + a_name + " \u043f\u0435\u0440\u0435\u0448\u0435\u043b \u0438\u0437 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f " + state_from + " \u0432 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 " + state_to, " T");
    }

    private void log_input(String x_name, String comment, boolean result) {
        String res_str = result ? "\u0414\u0410" : "\u041d\u0415\u0422";
        this.log(String.valueOf(x_name) + ": " + comment + "? - " + res_str + ".", " i");
    }

    private void log_output(String z_name, String comment) {
        this.log(String.valueOf(z_name) + ": " + comment + ".", " *");
    }

    public class driver_t {
        private final boolean SWITCH_DEBUG = true;
        private final boolean INPUTS_LOGGING = true;
        private final boolean OUTPUTS_LOGGING = true;
        private final boolean A3_LOGGING = true;
        private final boolean A3_BEGIN_LOGGING = true;
        private final boolean A3_END_LOGGING = true;
        private final boolean A3_ERROR_LOGGING = true;
        private final boolean A3_TRANS_LOGGING = true;
        private final double walls_k = 100.0;
        private final double heading_delta = Math.toRadians(30.0);
        private long T110;
        private double old_heading;
        private double cur_heading;
        private double old_x;
        private double old_y;
        private double cur_x;
        private double cur_y;
        private double turning_speed;
        private double old_speed;
        private double cur_speed;
        private double da;
        private double speed;
        private vect_t direction;
        private int y3;

        public driver_t() {
            this.direction = new vect_t();
            this.y3 = 0;
        }

        public void begin_round() {
            this.old_heading = this.cur_heading = MicroTestBot.this.getHeadingRadians();
            this.cur_speed = 0.0;
            this.old_speed = 0.0;
            this.old_x = this.cur_x = MicroTestBot.this.getX();
            this.old_y = this.cur_y = MicroTestBot.this.getY();
            this.turning_speed = 0.0;
            this.T110 = 0L;
            this.direction.reset();
            this.da = 0.0;
            this.speed = 8.0;
        }

        public void begin_turn() {
            this.old_heading = this.cur_heading;
            this.cur_heading = MicroTestBot.this.getHeadingRadians();
            this.old_x = this.cur_x;
            this.cur_x = MicroTestBot.this.getX();
            this.old_y = this.cur_y;
            this.cur_y = MicroTestBot.this.getY();
            this.old_speed = this.cur_speed;
            this.cur_speed = Math.sqrt(Math.pow(this.cur_x - this.old_x, 2.0) + Math.pow(this.cur_y - this.old_y, 2.0));
            this.cur_speed *= (double)(this.speed >= 0.0 ? 1 : -1);
            this.turning_speed = MicroTestBot.this.get_angle_diff(this.old_heading, this.cur_heading);
            this.da = 0.0;
            this.A3(10);
        }

        public void robot_collision() {
            this.A3(40);
        }

        public void wall_collision() {
            this.A3(41);
        }

        public void hit_by_bullet() {
            this.A3(45);
        }

        public void end_turn() {
            MicroTestBot.this.setTurnRightRadians(this.da);
            MicroTestBot.this.setAhead(this.speed * 100.0);
        }

        public double turning_speed() {
            return this.turning_speed;
        }

        private void A3(int e) {
            int y_old = this.y3;
            MicroTestBot.this.log("\u0414\u043b\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 '\u0412\u043e\u0434\u0438\u0442\u0435\u043b\u044c':");
            MicroTestBot.this.log_begin("A3", this.y3, e);
            switch (this.y3) {
                case 0: {
                    if (!this.x100() && !this.x105()) {
                        this.y3 = 1;
                        break;
                    }
                    if (this.x110()) {
                        this.z200_0();
                        this.z200_1();
                        this.z200_2();
                        break;
                    }
                    this.z200_1();
                    this.z200_2();
                    break;
                }
                case 1: {
                    if (e == 45) {
                        this.y3 = 2;
                        break;
                    }
                    if (this.x100() || this.x105() || e == 40 || e == 41) {
                        this.y3 = 0;
                        break;
                    }
                    if (this.x110()) {
                        this.y3 = 3;
                        break;
                    }
                    this.z210_1();
                    this.z210_2();
                    break;
                }
                case 2: {
                    if (this.x105() || this.x110() || e == 40 || e == 41) {
                        this.y3 = 0;
                        break;
                    }
                    this.z220_1();
                    this.z220_2();
                    break;
                }
                case 3: {
                    if (e == 45) {
                        this.y3 = 2;
                        break;
                    }
                    if (this.x110()) {
                        this.y3 = 0;
                        break;
                    }
                    this.z200_2();
                    break;
                }
                default: {
                    MicroTestBot.this.log_error("A3", this.y3);
                }
            }
            if (this.y3 != y_old) {
                MicroTestBot.this.log_trans("A3", this.y3, y_old);
                switch (this.y3) {
                    case 0: {
                        this.z200_0();
                        this.z200_1();
                        this.z200_2();
                        break;
                    }
                    case 1: {
                        this.z210_0();
                        this.z210_1();
                        this.z210_2();
                        break;
                    }
                    case 2: {
                        this.z220_0();
                        this.z220_1();
                        this.z220_2();
                        break;
                    }
                    case 3: {
                        this.z230_0();
                        this.z200_2();
                    }
                }
            }
            MicroTestBot.this.log_end("A3", this.y3);
        }

        private boolean x100() {
            boolean result = true;
            if (((MicroTestBot)MicroTestBot.this).targets.closest_target != null) {
                result = ((MicroTestBot)MicroTestBot.this).targets.closest_target.R < 300.0;
            }
            MicroTestBot.this.log_input("x100", "\u0412\u0440\u0430\u0433 \u0431\u043b\u0438\u0437\u043a\u043e", result);
            return result;
        }

        private boolean x105() {
            double collision_delta = MicroTestBot.this.robot_size2 + 40.0;
            boolean result = this.cur_x < 0.0 + collision_delta || this.cur_x > MicroTestBot.this.battlefield_width - collision_delta || this.cur_y < 0.0 + collision_delta || this.cur_y > MicroTestBot.this.battlefield_height - collision_delta;
            MicroTestBot.this.log_input("x105", "\u0421\u0442\u0435\u043d\u0430 \u0431\u043b\u0438\u0437\u043a\u043e", result);
            return result;
        }

        private boolean x110() {
            boolean result = MicroTestBot.this.cur_time >= this.T110;
            MicroTestBot.this.log_input("x110", "\u0421\u0440\u0430\u0431\u043e\u0442\u0430\u043b \u0442\u0430\u0439\u043c\u0435\u0440 T110", result);
            return result;
        }

        private void z200_0() {
            MicroTestBot.this.log_output("z200_0", "\u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0434\u0432\u0438\u0436\u0435\u043d\u0438\u044f \u043f\u043e \u0442\u0440\u0430\u0435\u043a\u0442\u043e\u0440\u0438\u0438 '\u041c\u0430\u044f\u0442\u043d\u0438\u043a'");
            MicroTestBot.this.setMaxVelocity(10.0);
            this.get_direction();
        }

        private void z200_1() {
            MicroTestBot.this.log_output("z200_1", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0441\u043b\u0443\u0447\u0430\u0439\u043d\u0443\u044e \u0441\u043e\u0441\u0442\u0430\u0432\u043b\u044f\u044e\u0449\u0443\u044e \u043a \u0442\u0440\u0430\u0435\u043a\u0442\u043e\u0440\u0438\u0438 '\u041c\u0430\u044f\u0442\u043d\u0438\u043a'");
            this.direction.reset(this.direction.a, 1.0);
            double angle_diff = MicroTestBot.this.normalize_angle(this.direction.a + (MicroTestBot.this.random.nextBoolean() ? 1.5707963267948966 : -1.5707963267948966));
            this.direction.addrad(angle_diff, 0.4);
        }

        private void z200_2() {
            MicroTestBot.this.log_output("z200_2", "\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0438 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u0434\u0432\u0438\u0436\u0435\u043d\u0438\u044f '\u041c\u0430\u044f\u0442\u043d\u0438\u043a'");
            this.calculate_movement_order(true);
        }

        private void z210_0() {
            MicroTestBot.this.log_output("z210_0", "\u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0434\u0432\u0438\u0436\u0435\u043d\u0438\u044f \u043f\u043e \u0442\u0440\u0430\u0435\u043a\u0442\u043e\u0440\u0438\u0438 '\u0414\u0443\u0433\u0430'");
            double TTT = ((MicroTestBot)MicroTestBot.this).targets.closest_target != null ? ((MicroTestBot)MicroTestBot.this).targets.closest_target.R / 20.0 : 10.0;
            this.T110 = MicroTestBot.this.cur_time + Math.round(TTT *= MicroTestBot.this.random.nextDouble() * 0.5 + 0.8);
            this.get_direction();
            MicroTestBot.this.setMaxVelocity(10.0);
            if (((MicroTestBot)MicroTestBot.this).targets.closest_target != null) {
                double delta1 = Math.abs(MicroTestBot.this.get_angle_diff(this.direction.a, ((MicroTestBot)MicroTestBot.this).targets.closest_target.a));
                double delta2 = Math.abs(MicroTestBot.this.get_angle_diff(this.direction.a, MicroTestBot.this.normalize_angle(((MicroTestBot)MicroTestBot.this).targets.closest_target.a + Math.PI)));
                if (delta1 > this.heading_delta || delta2 > this.heading_delta) {
                    this.direction.a = MicroTestBot.this.normalize_angle(((MicroTestBot)MicroTestBot.this).targets.closest_target.a + Math.PI + (MicroTestBot.this.random.nextBoolean() ? 0.7853981633974483 : -0.7853981633974483));
                }
            }
        }

        private void z210_1() {
            MicroTestBot.this.log_output("z210_1", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0441\u043b\u0443\u0447\u0430\u0439\u043d\u0443\u044e \u0441\u043e\u0441\u0442\u0430\u0432\u043b\u044f\u044e\u0449\u0443\u044e \u043a \u0442\u0440\u0430\u0435\u043a\u0442\u043e\u0440\u0438\u0438 '\u0414\u0443\u0433\u0430'");
        }

        private void z210_2() {
            MicroTestBot.this.log_output("z210_2", "\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0438 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u0434\u0432\u0438\u0436\u0435\u043d\u0438\u044f '\u0414\u0443\u0433\u0430'");
            this.calculate_movement_order(false);
            this.da = 0.0;
        }

        private void z220_0() {
            MicroTestBot.this.log_output("z220_0", "\u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0434\u0432\u0438\u0436\u0435\u043d\u0438\u044f \u043f\u043e \u0442\u0440\u0430\u0435\u043a\u0442\u043e\u0440\u0438\u0438 '\u0423\u043a\u043b\u043e\u043d\u0435\u043d\u0438\u0435'");
            this.T110 = MicroTestBot.this.cur_time + 17L;
            this.get_direction();
            this.direction.a = -1.5707963267948966 * (this.direction.a / Math.abs(this.direction.a));
            MicroTestBot.this.setMaxVelocity(5.0);
        }

        private void z220_1() {
            MicroTestBot.this.log_output("z220_1", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0441\u043b\u0443\u0447\u0430\u0439\u043d\u0443\u044e \u0441\u043e\u0441\u0442\u0430\u0432\u043b\u044f\u044e\u0449\u0443\u044e \u043a \u0442\u0440\u0430\u0435\u043a\u0442\u043e\u0440\u0438\u0438 '\u0423\u043a\u043b\u043e\u043d\u0435\u043d\u0438\u0435'");
        }

        private void z220_2() {
            MicroTestBot.this.log_output("z220_2", "\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0434\u0432\u0438\u0436\u0435\u043d\u0438\u044f '\u0423\u043a\u043b\u043e\u043d\u0435\u043d\u0438\u0435'");
            this.calculate_movement_order(false);
        }

        private void z230_0() {
            MicroTestBot.this.log_output("z230_0", "\u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0434\u0432\u0438\u0436\u0435\u043d\u0438\u044f \u043f\u043e \u0442\u0440\u0430\u0435\u043a\u0442\u043e\u0440\u0438\u0438 '\u041e\u0441\u0442\u0430\u043d\u043e\u0432'");
            double TTT = ((MicroTestBot)MicroTestBot.this).targets.closest_target != null ? ((MicroTestBot)MicroTestBot.this).targets.closest_target.R / 20.0 : 10.0;
            this.T110 = MicroTestBot.this.cur_time + Math.round(TTT *= MicroTestBot.this.random.nextDouble() * 0.3 + 0.3);
            MicroTestBot.this.setMaxVelocity(0.0);
        }

        private void get_direction() {
            this.direction.reset();
            this.direction.adddec(100.0 / this.cur_x, 0.0);
            this.direction.adddec(-100.0 / (MicroTestBot.this.battlefield_width - this.cur_x), 0.0);
            this.direction.adddec(0.0, 100.0 / this.cur_y);
            this.direction.adddec(0.0, -100.0 / (MicroTestBot.this.battlefield_height - this.cur_y));
            this.direction.add(MicroTestBot.this.targets.get_reaction_vector());
        }

        private void calculate_movement_order(boolean reverse_alloud) {
            double da1 = MicroTestBot.this.get_angle_diff(this.cur_heading, this.direction.a);
            double da2 = MicroTestBot.this.get_angle_diff(this.cur_heading, MicroTestBot.this.normalize_angle(this.direction.a - Math.PI));
            if (reverse_alloud) {
                if (Math.abs(da1) < Math.abs(da2)) {
                    this.da = da1;
                    this.speed = 8.0;
                } else {
                    this.da = da2;
                    this.speed = -8.0;
                }
            } else {
                this.da = this.speed > 0.0 ? da1 : da2;
            }
        }
    }

    public class gunner_t {
        private final boolean SWITCH_DEBUG = true;
        private final boolean INPUTS_LOGGING = true;
        private final boolean OUTPUTS_LOGGING = true;
        private final boolean A1_LOGGING = true;
        private final boolean A1_BEGIN_LOGGING = true;
        private final boolean A1_END_LOGGING = true;
        private final boolean A1_ERROR_LOGGING = true;
        private final boolean A1_TRANS_LOGGING = true;
        private final boolean A2_LOGGING = true;
        private final boolean A2_BEGIN_LOGGING = true;
        private final boolean A2_END_LOGGING = true;
        private final boolean A2_ERROR_LOGGING = true;
        private final boolean A2_TRANS_LOGGING = true;
        private double old_heading;
        private double cur_heading;
        private double old_gun_heat;
        private double cur_gun_heat;
        private double gun_heat_decrement = 0.0;
        private target_t cur_target;
        private vect_t cur_aim;
        private double cur_firepower;
        private double da;
        private double firepower;
        private int y1 = 0;
        private int y2 = 0;

        gunner_t() {
            this.cur_aim = new vect_t();
        }

        public void begin_round() {
            this.old_heading = this.cur_heading = MicroTestBot.this.getGunHeadingRadians();
            this.old_gun_heat = this.cur_gun_heat = MicroTestBot.this.getGunHeat();
            this.cur_target = null;
            this.cur_aim.reset();
            MicroTestBot.this.last_fire_time = 0L;
        }

        public void begin_turn() {
            this.old_heading = this.cur_heading;
            this.cur_heading = MicroTestBot.this.getGunHeadingRadians();
            this.old_gun_heat = this.cur_gun_heat;
            this.cur_gun_heat = MicroTestBot.this.getGunHeat();
            this.da = 0.0;
            this.firepower = 0.0;
            this.A1(10);
            this.A2(10);
        }

        public void end_turn() {
            MicroTestBot.this.setTurnGunRightRadians(this.da);
            if (this.firepower >= 0.1) {
                Bullet bullet = MicroTestBot.this.fireBullet(this.firepower);
                if (bullet != null) {
                    MicroTestBot.this.last_fire_time = MicroTestBot.this.cur_time;
                    if (this.cur_target != null) {
                        this.cur_target.shoot(this.firepower);
                    }
                }
            } else {
                MicroTestBot.this.scan();
            }
        }

        public double cur_heading() {
            return this.cur_heading;
        }

        private void A1(int e) {
            int y_old = this.y1;
            MicroTestBot.this.log("\u0414\u043b\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 '\u0421\u0442\u0440\u0435\u043b\u043e\u043a':");
            MicroTestBot.this.log_begin("A1", this.y1, e);
            switch (this.y1) {
                case 0: {
                    if (this.y2 == 1 && this.x25()) {
                        this.y1 = 3;
                        break;
                    }
                    this.z30();
                    this.z70();
                    this.z50_1();
                    break;
                }
                case 1: {
                    if (this.x26()) {
                        this.z80();
                        this.y1 = 0;
                        break;
                    }
                    if (this.x30() && this.x22()) {
                        this.y1 = 2;
                        break;
                    }
                    this.z40();
                    this.z50_0();
                    break;
                }
                case 2: {
                    if (this.x26()) {
                        this.z80();
                        this.y1 = 0;
                        break;
                    }
                    if (this.x21() && this.x50()) {
                        this.z60();
                        this.y1 = 0;
                        break;
                    }
                    if (!this.x30()) {
                        this.y1 = 1;
                        break;
                    }
                    this.z40();
                    this.z50_0();
                    break;
                }
                case 3: {
                    if (this.x26()) {
                        this.z80();
                        this.y1 = 0;
                        break;
                    }
                    if (this.x20()) {
                        this.y1 = 1;
                        break;
                    }
                    this.z50_1();
                    break;
                }
                default: {
                    MicroTestBot.this.log_error("A1", this.y1);
                }
            }
            if (this.y1 != y_old) {
                MicroTestBot.this.log_trans("A1", this.y1, y_old);
                switch (this.y1) {
                    case 0: {
                        this.z30();
                        this.z70();
                        break;
                    }
                    case 1: {
                        this.z40();
                        this.z50_0();
                        break;
                    }
                    case 2: {
                        this.z40();
                        this.z50_0();
                        break;
                    }
                    case 3: {
                        this.z50_1();
                    }
                }
            }
            MicroTestBot.this.log_end("A1", this.y1);
        }

        private void A2(int e) {
            int y_old = this.y2;
            MicroTestBot.this.log_begin("A2", this.y2, e);
            switch (this.y2) {
                case 0: {
                    if (this.x10()) {
                        this.z36();
                        this.y2 = 1;
                        break;
                    }
                    this.z35();
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    MicroTestBot.this.log_error("A2", this.y2);
                }
            }
            if (this.y2 != y_old) {
                MicroTestBot.this.log_trans("A2", this.y2, y_old);
            }
            MicroTestBot.this.log_end("A2", this.y2);
        }

        private boolean x10() {
            boolean result = MicroTestBot.this.cur_time > 3L && this.gun_heat_decrement > 0.0;
            MicroTestBot.this.log_input("x10", "\u041f\u043e\u0434\u0441\u0447\u0435\u0442 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u0438 \u043e\u0445\u043b\u0430\u0436\u0434\u0435\u043d\u0438\u044f \u043f\u0443\u0448\u043a\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d", result);
            return result;
        }

        private boolean x20() {
            boolean result = this.cur_gun_heat / this.gun_heat_decrement <= 3.0;
            MicroTestBot.this.log_input("x20", "\u041f\u0443\u0448\u043a\u0430 \u0441\u043a\u043e\u0440\u043e \u043e\u0445\u043b\u0430\u0434\u0438\u0442\u0441\u044f", result);
            return result;
        }

        private boolean x21() {
            boolean result = this.cur_gun_heat <= 0.0;
            MicroTestBot.this.log_input("x21", "\u041f\u0443\u0448\u043a\u0430 \u043e\u0445\u043b\u0430\u0434\u0438\u043b\u0430\u0441\u044c", result);
            return result;
        }

        private boolean x22() {
            boolean result = this.cur_gun_heat / this.gun_heat_decrement <= 1.0;
            MicroTestBot.this.log_input("x22", "\u0414\u043e \u043a\u043e\u043d\u0446\u0430 \u043e\u0445\u043b\u0430\u0436\u0434\u0435\u043d\u0438\u044f \u043f\u0443\u0448\u043a\u0438 \u043c\u0435\u043d\u044c\u0448\u0435 \u0434\u0432\u0443\u0445 \u0445\u043e\u0434\u043e\u0432", result);
            return result;
        }

        private boolean x25() {
            boolean result = this.cur_target != null;
            MicroTestBot.this.log_input("x25", "\u0426\u0435\u043b\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u0430", result);
            return result;
        }

        private boolean x26() {
            boolean result = true;
            if (this.cur_target != null) {
                result = !this.cur_target.is_tracked();
            }
            MicroTestBot.this.log_input("x26", "\u0426\u0435\u043b\u044c \u043f\u043e\u0442\u0435\u0440\u044f\u043d\u0430", result);
            return result;
        }

        private boolean x30() {
            boolean result = true;
            double gun_to_go = MicroTestBot.this.get_angle_diff(this.cur_heading, this.cur_aim.a);
            double turn_direction = gun_to_go >= 0.0 ? 1 : -1;
            double gun_turning_speed = turn_direction * MicroTestBot.this.gun_rotation_speed + MicroTestBot.this.driver.turning_speed();
            result = Math.abs(gun_to_go / gun_turning_speed) <= 1.0;
            MicroTestBot.this.log_input("x30", "\u0414\u043e \u043a\u043e\u043d\u0446\u0430 \u043f\u043e\u0432\u043e\u0440\u043e\u0442\u0430 \u043f\u0443\u0448\u043a\u0438 \u043c\u0435\u043d\u044c\u0448\u0435 \u0434\u0432\u0443\u0445 \u0445\u043e\u0434\u043e\u0432", result);
            return result;
        }

        private boolean x50() {
            boolean result = true;
            double gun_to_go = MicroTestBot.this.get_angle_diff(this.cur_heading, this.cur_aim.a);
            result = Math.abs(gun_to_go) < 1.0E-6;
            MicroTestBot.this.log_input("x50", "\u041d\u0430\u0432\u043e\u0434\u043a\u0430 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0430\u044f", result);
            return result;
        }

        private void z30() {
            MicroTestBot.this.log_output("z30", "\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0446\u0435\u043b\u044c");
            this.cur_target = MicroTestBot.this.targets.get_closest_target(8.0);
            if (this.cur_target == null) {
                this.cur_target = ((MicroTestBot)MicroTestBot.this).targets.closest_target;
            }
        }

        private void z35() {
            MicroTestBot.this.log_output("z35", "\u041f\u043e\u0434\u0441\u0447\u0435\u0442 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u0438 \u043e\u0445\u043b\u0430\u0436\u0434\u0435\u043d\u0438\u044f \u043f\u0443\u0448\u043a\u0438");
            this.gun_heat_decrement = this.old_gun_heat - this.cur_gun_heat;
        }

        private void z36() {
            MicroTestBot.this.log_output("z36", "\u0412\u044b\u0432\u0435\u0441\u0442\u0438 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u043e\u0445\u043b\u0430\u0436\u0434\u0435\u043d\u0438\u044f \u043f\u0443\u0448\u043a\u0438");
            MicroTestBot.this.log("gun_heat_decrement = " + this.gun_heat_decrement);
        }

        private void z40() {
            MicroTestBot.this.log_output("z40", "\u0420\u0430\u0441\u0441\u0447\u0438\u0442\u0430\u0442\u044c \u043c\u043e\u0449\u043d\u043e\u0441\u0442\u044c \u0432\u044b\u0441\u0442\u0440\u0435\u043b\u0430");
            double P = 0.25;
            if (MicroTestBot.this.cur_life >= 50.0) {
                P = 0.2;
                if (MicroTestBot.this.cur_robots_count > 2) {
                    P = 0.4;
                }
            } else if (MicroTestBot.this.cur_life <= 30.0) {
                P = 0.25;
                if (MicroTestBot.this.cur_robots_count > 2) {
                    P = 0.5;
                }
            } else if (MicroTestBot.this.cur_life <= 15.0) {
                P = 0.6;
            }
            this.cur_firepower = this.cur_target.get_firepower(P);
        }

        private void z50_0() {
            MicroTestBot.this.log_output("z50_0", "\u0420\u0430\u0441\u0441\u0447\u0438\u0442\u0430\u0442\u044c \u0442\u043e\u0447\u043d\u043e\u0435 \u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u0438 \u043d\u0430\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043f\u0443\u0448\u043a\u0443");
            if (this.cur_target != null) {
                vect_t predicted_pos = this.cur_target.predict_position_medium(MicroTestBot.this.get_bullet_speed(this.cur_firepower), 2.0);
                this.cur_aim.reset(predicted_pos.a, predicted_pos.R);
                this.da = MicroTestBot.this.get_angle_diff(this.cur_heading, predicted_pos.a);
            }
        }

        private void z50_1() {
            MicroTestBot.this.log_output("z50_1", "\u0420\u0430\u0441\u0441\u0447\u0438\u0442\u0430\u0442\u044c \u043f\u0440\u0438\u0431\u043b\u0438\u0437\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u0438 \u043d\u0430\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043f\u0443\u0448\u043a\u0443");
            if (this.cur_target != null) {
                vect_t predicted_pos = this.cur_target.predict_position_roughly(MicroTestBot.this.get_bullet_speed(1.5), 2.0);
                this.cur_aim.reset(predicted_pos.a, predicted_pos.R);
                this.da = MicroTestBot.this.get_angle_diff(this.cur_heading, predicted_pos.a);
            }
        }

        private void z60() {
            MicroTestBot.this.log_output("z60", "\u0412\u044b\u0441\u0442\u0440\u0435\u043b");
            this.firepower = this.cur_firepower;
        }

        private void z70() {
            MicroTestBot.this.log_output("z70", "\u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u0438\u0441\u0442\u043e\u0440\u0438\u044e \u043c\u0430\u043d\u0435\u0432\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0446\u0435\u043b\u0438");
            if (this.cur_target != null) {
                this.cur_target.reset_speed_history();
            }
        }

        private void z80() {
            MicroTestBot.this.log_output("z80", "\u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u0442\u0435\u043a\u0443\u0449\u0443\u044e \u0446\u0435\u043b\u044c");
            this.cur_target = null;
        }
    }

    public class radar_t {
        private final boolean SWITCH_DEBUG = true;
        private final boolean INPUTS_LOGGING = true;
        private final boolean OUTPUTS_LOGGING = true;
        private final boolean A4_LOGGING = true;
        private final boolean A4_BEGIN_LOGGING = true;
        private final boolean A4_END_LOGGING = true;
        private final boolean A4_ERROR_LOGGING = true;
        private final boolean A4_TRANS_LOGGING = true;
        private double old_heading;
        private double cur_heading;
        private double da;
        private double radar_path;
        private int y4 = 0;

        public void begin_round() {
            this.old_heading = this.cur_heading = MicroTestBot.this.getRadarHeadingRadians();
            this.da = 0.0;
            this.radar_path = 0.0;
        }

        public void begin_turn() {
            this.old_heading = this.cur_heading;
            this.cur_heading = MicroTestBot.this.getRadarHeadingRadians();
            this.radar_path += MicroTestBot.this.get_angle_diff(this.old_heading, this.cur_heading);
            this.A4(10);
        }

        public void end_turn() {
            MicroTestBot.this.setTurnRadarRightRadians(this.da);
        }

        private void A4(int e) {
            int y_old = this.y4;
            MicroTestBot.this.log("\u0414\u043b\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 '\u0420\u0430\u0434\u0430\u0440':");
            MicroTestBot.this.log_begin("A4", this.y4, e);
            switch (this.y4) {
                case 0: {
                    boolean X70 = this.x70();
                    if (X70 && this.x80()) {
                        this.z101_0();
                        this.y4 = 1;
                        break;
                    }
                    if (X70) {
                        this.y4 = 2;
                        break;
                    }
                    this.z100_0();
                    break;
                }
                case 1: {
                    boolean X70 = this.x70();
                    if (X70 && this.x80()) {
                        this.z101_0();
                        this.y4 = 0;
                        break;
                    }
                    if (X70) {
                        this.y4 = 3;
                        break;
                    }
                    this.z100_1();
                    break;
                }
                case 2: {
                    if (this.x70()) {
                        this.z101_0();
                        this.y4 = 0;
                        break;
                    }
                    this.y4 = 0;
                    break;
                }
                case 3: {
                    if (this.x70()) {
                        this.z101_0();
                        this.y4 = 1;
                        break;
                    }
                    this.y4 = 1;
                    break;
                }
                default: {
                    MicroTestBot.this.log_error("A4", this.y4);
                }
            }
            if (this.y4 != y_old) {
                MicroTestBot.this.log_trans("A4", this.y4, y_old);
                switch (this.y4) {
                    case 0: {
                        this.z100_0();
                        break;
                    }
                    case 1: {
                        this.z100_1();
                        break;
                    }
                    case 2: {
                        this.z101_0();
                        this.z100_1();
                        break;
                    }
                    case 3: {
                        this.z101_0();
                        this.z100_0();
                    }
                }
            }
            MicroTestBot.this.log_end("A4", this.y4);
        }

        private boolean x70() {
            boolean result = MicroTestBot.this.targets.scan_completed();
            MicroTestBot.this.log_input("x70", "\u0426\u0438\u043a\u043b \u0441\u043a\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d", result);
            return result;
        }

        private boolean x80() {
            boolean result = Math.abs(this.radar_path) < Math.PI;
            MicroTestBot.this.log_input("x80", "\u041f\u0440\u043e\u0439\u0434\u0435\u043d\u043d\u044b\u0439 \u0440\u0430\u0434\u0430\u0440\u043e\u043c \u043f\u0443\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 180 \u0433\u0440\u0430\u0434\u0443\u0441\u043e\u0432", result);
            return result;
        }

        private void z100_0() {
            MicroTestBot.this.log_output("z100_0", "\u041f\u043e\u0432\u0435\u0440\u043d\u0443\u0442\u044c \u0440\u0430\u0434\u0430\u0440 \u0432\u043b\u0435\u0432\u043e");
            this.da = -1000.0;
        }

        private void z100_1() {
            MicroTestBot.this.log_output("z100_1", "\u041f\u043e\u0432\u0435\u0440\u043d\u0443\u0442\u044c \u0440\u0430\u0434\u0430\u0440 \u0432\u043f\u0440\u0430\u0432\u043e");
            this.da = 1000.0;
        }

        private void z101_0() {
            MicroTestBot.this.log_output("z101_0", "\u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u043f\u0430\u043c\u044f\u0442\u044c \u043f\u0440\u043e\u0439\u0434\u0435\u043d\u043d\u043e\u0433\u043e \u0440\u0430\u0434\u0430\u0440\u043e\u043c \u043f\u0443\u0442\u0438");
            this.radar_path = 0.0;
        }
    }

    public class target_t {
        private final boolean SWITCH_DEBUG = true;
        private final boolean INPUTS_LOGGING = true;
        private final boolean OUTPUTS_LOGGING = true;
        private final boolean A5_LOGGING = true;
        private final boolean A5_BEGIN_LOGGING = true;
        private final boolean A5_END_LOGGING = true;
        private final boolean A5_ERROR_LOGGING = true;
        private final boolean A5_TRANS_LOGGING = true;
        private final double long_range = 650.0;
        private final double close_range = 150.0;
        private final double point_blank_range = 70.0;
        private final long old_info = 20L;
        private String name;
        private double a;
        private double R;
        private double v;
        private double old_v;
        private double med_v;
        private double dv;
        private double w;
        private double old_w;
        private double med_w;
        private boolean collision_detected;
        private double cur_target_heading;
        private double old_target_heading;
        private long last_update_time;
        private double prediction_interval;
        private vect_t predicted_vector;
        private double cur_target_life;
        private double hits;
        private double shots;
        private double T_base;
        private double P_base;
        private double P0;
        private double T_medium;
        private int y5;

        target_t(ScannedRobotEvent e) {
            this.predicted_vector = new vect_t();
            this.y5 = 0;
            this.name = e.getName();
            this.a = MicroTestBot.this.normalize_angle(MicroTestBot.this.getHeadingRadians() + e.getBearingRadians());
            this.R = e.getDistance();
            this.old_v = this.v = e.getVelocity();
            this.med_v = this.v;
            this.dv = 0.0;
            this.w = 0.0;
            this.old_w = 0.0;
            this.med_w = 0.0;
            this.old_target_heading = this.cur_target_heading = e.getHeadingRadians();
            this.last_update_time = MicroTestBot.this.cur_time;
            this.hits = 0.0;
            this.shots = 0.0;
            this.T_base = 3.0;
            this.T_medium = 3.0;
            this.P_base = 1.0;
            this.P0 = 1.2;
            this.A5(100, (Event)e);
        }

        public void begin_round() {
            this.A5(120, null);
        }

        public void refresh() {
            this.A5(140, null);
        }

        public void update(ScannedRobotEvent e) {
            this.A5(100, (Event)e);
        }

        public void destroyed() {
            this.A5(110, null);
        }

        public void hit() {
            this.A5(130, null);
        }

        public void collide() {
            this.A5(135, null);
        }

        public void hit_by_bullet() {
            this.A5(136, null);
        }

        public void shoot(double firepower) {
            double T = this.predicted_vector.R / MicroTestBot.this.get_bullet_speed(firepower);
            T = T < 1.0 ? 1.0 : T;
            double P = this.P0 - T * (this.P0 - this.P_base) / this.T_base;
            P = P > this.P0 ? this.P0 : P;
            P = P < 0.0 ? 0.0 : P;
            this.P_base = this.P0 - this.T_base * (this.P0 - (P /= 1.2)) / T;
            this.P_base = this.P_base > this.P0 ? this.P0 : this.P_base;
            this.P_base = this.P_base < 0.0 ? 0.0 : this.P_base;
            this.T_medium = (this.T_medium + T) / 2.0;
            this.shots += 1.0;
        }

        public void reset_speed_history() {
            this.med_w = this.w;
            this.med_v = this.v;
        }

        public boolean is_tracked() {
            return this.y5 == 2;
        }

        public boolean is_unknown() {
            return this.y5 == 0;
        }

        public boolean was_scanned_after(long scan_time) {
            return this.last_update_time > scan_time;
        }

        public double get_firepower(double P) {
            double R = this.predicted_vector.R;
            double S = (this.P0 - this.P_base) * R / ((this.P0 - P) * this.T_base);
            double F = (20.0 - S) / 3.0;
            F = F > 3.0 ? 3.0 : F;
            double damage = F * 3.0 + (F > 1.0 ? 2.0 * (F - 1.0) : 0.0);
            if (damage > this.cur_target_life) {
                F = this.cur_target_life < 3.0 ? ((F = this.cur_target_life / 3.0) < 0.1 ? 0.1 : F) : (this.cur_target_life + 2.0) / 5.0;
            }
            if (F < 0.1) {
                if (R < 650.0 && MicroTestBot.this.cur_life > 30.0) {
                    F = 0.1;
                } else if (this.cur_target_life > MicroTestBot.this.cur_life && (double)(MicroTestBot.this.cur_time - MicroTestBot.this.last_fire_time) > 400.0) {
                    F = 0.1;
                }
            } else if (MicroTestBot.this.cur_life < 15.0) {
                F = F > MicroTestBot.this.cur_life / 5.0 ? MicroTestBot.this.cur_life / 5.0 : F;
                double d = F = F < 0.1 ? 0.1 : F;
                if (MicroTestBot.this.cur_life < 0.2) {
                    F = 0.0;
                }
            }
            return F;
        }

        public vect_t predict_position_roughly(double bullet_speed, double prediction_gap) {
            double cur_bullet_time = prediction_gap + this.R / bullet_speed;
            this.predicted_vector.reset(this.a, this.R);
            if (this.R > 150.0 && Math.abs(this.v) > 1.0E-6) {
                this.predicted_vector.add(MicroTestBot.this.get_path(this.med_v, this.med_w, this.cur_target_heading, cur_bullet_time));
            }
            return this.predicted_vector;
        }

        public vect_t predict_position_exactly(double bullet_speed, double prediction_gap) {
            this.predict_position(this.v, this.w, bullet_speed, prediction_gap);
            return this.predicted_vector;
        }

        public vect_t predict_position_medium(double bullet_speed, double prediction_gap) {
            this.predict_position(this.med_v, this.med_w, bullet_speed, prediction_gap);
            return this.predicted_vector;
        }

        public void show_statistics() {
            MicroTestBot.this.log("---- \u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 \u0434\u043b\u044f " + this.name + " ----");
            MicroTestBot.this.log("\u0412\u044b\u0441\u0442\u0440\u0435\u043b\u043e\u0432: " + this.shots + ", \u043f\u043e\u043f\u0430\u0434\u0430\u043d\u0438\u0439: " + this.hits);
            MicroTestBot.this.log("\u0412\u0435\u0440\u043e\u044f\u0442\u043d\u043e\u0441\u0442\u044c: " + this.hits / this.shots + ", \u0431\u0430\u0437\u043e\u0432\u0430\u044f: " + this.P_base);
            MicroTestBot.this.log("---------");
        }

        private void A5(int e, Event robocode_event) {
            int y_old = this.y5;
            MicroTestBot.this.log("\u0414\u043b\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 '\u0426\u0435\u043b\u044c' (" + this.name + "):");
            MicroTestBot.this.log_begin("A5", this.y5, e);
            switch (this.y5) {
                case 0: {
                    if (e == 100) {
                        this.z1001(robocode_event);
                        this.y5 = 2;
                        break;
                    }
                    if (e == 130) {
                        this.z1010(robocode_event);
                        this.y5 = 2;
                        break;
                    }
                    if (e == 135 || e == 136) {
                        this.y5 = 2;
                        break;
                    }
                    if (e != 140 || !this.x1000()) break;
                    this.y5 = 1;
                    break;
                }
                case 1: {
                    if (e == 100) {
                        this.z1001(robocode_event);
                        this.y5 = 2;
                        break;
                    }
                    if (e == 130) {
                        this.z1010(robocode_event);
                        this.y5 = 2;
                        break;
                    }
                    if (e == 135 || e == 136) {
                        this.y5 = 2;
                        break;
                    }
                    if (e != 120) break;
                    this.y5 = 0;
                    break;
                }
                case 2: {
                    if (e == 110 || e == 140 && this.x1000()) {
                        this.y5 = 1;
                        break;
                    }
                    if (e == 120) {
                        this.y5 = 0;
                        break;
                    }
                    if (e == 100) {
                        this.z1001(robocode_event);
                        break;
                    }
                    if (e != 130) break;
                    this.z1010(robocode_event);
                    break;
                }
                default: {
                    MicroTestBot.this.log_error("A5", this.y5);
                }
            }
            if (this.y5 != y_old) {
                MicroTestBot.this.log_trans("A5", this.y5, y_old);
                switch (this.y5) {
                    case 0: {
                        this.z1000();
                        break;
                    }
                    case 1: {
                        this.z1000();
                    }
                }
            }
            MicroTestBot.this.log_end("A5", this.y5);
        }

        private boolean x1000() {
            boolean result = MicroTestBot.this.cur_time - this.last_update_time > 20L;
            MicroTestBot.this.log_input("x1000", "\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0446\u0435\u043b\u0438 \u0443\u0441\u0442\u0430\u0440\u0435\u043b\u0430", result);
            return result;
        }

        private void z1000() {
            MicroTestBot.this.log_output("z1000", "\u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0446\u0435\u043b\u0438");
            this.w = 0.0;
            this.old_w = 0.0;
            this.med_w = 0.0;
            this.dv = 0.0;
            this.v = 0.0;
            this.old_v = 0.0;
            this.med_v = 0.0;
            this.last_update_time = 0L;
            this.predicted_vector.reset();
        }

        private void z1001(Event event) {
            MicroTestBot.this.log_output("z1001", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0446\u0435\u043b\u0438");
            if (this.last_update_time != MicroTestBot.this.cur_time) {
                ScannedRobotEvent e = (ScannedRobotEvent)event;
                this.cur_target_life = e.getLife();
                this.R = Math.abs(e.getDistance());
                this.a = MicroTestBot.this.normalize_angle(MicroTestBot.this.getHeadingRadians() + e.getBearingRadians());
                this.old_v = this.v;
                this.v = e.getVelocity();
                this.med_v = (this.v + this.med_v) / 2.0;
                this.dv = (this.v - this.old_v) / (double)(MicroTestBot.this.cur_time - this.last_update_time);
                this.old_target_heading = this.cur_target_heading;
                this.cur_target_heading = MicroTestBot.this.normalize_angle(e.getHeadingRadians());
                this.old_w = this.w;
                this.w = MicroTestBot.this.get_angle_diff(this.old_target_heading, this.cur_target_heading) / (double)(MicroTestBot.this.cur_time - this.last_update_time);
                this.med_w = (this.w + this.med_w) / 2.0;
                this.last_update_time = MicroTestBot.this.cur_time;
            }
        }

        private void z1010(Event e) {
            MicroTestBot.this.log_output("z1010", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0443 \u043f\u043e\u043f\u0430\u0434\u0430\u043d\u0438\u0439 \u0432 \u0446\u0435\u043b\u044c");
            double P = this.P0 - this.T_medium * (this.P0 - this.P_base) / this.T_base;
            P = P > this.P0 ? this.P0 : (P *= 1.4);
            P = P < 0.0 ? 0.0 : P;
            this.P_base = this.P0 - this.T_base * (this.P0 - P) / this.T_medium;
            this.P_base = this.P_base > this.P0 ? this.P0 : this.P_base;
            this.P_base = this.P_base < 0.0 ? 0.0 : this.P_base;
            this.hits += 1.0;
        }

        private vect_t predict_position(double v, double w, double bullet_speed, double prediction_gap) {
            int i = 0;
            vect_t cur_prediction = new vect_t();
            if (this.R < 70.0) {
                cur_prediction.reset(this.a, this.R);
            } else if (Math.abs(v) > 1.0E-6) {
                double cur_bullet_time;
                double old_bullet_time = cur_bullet_time = prediction_gap + this.R / bullet_speed;
                this.collision_detected = false;
                cur_prediction = this.get_predicted_point(v, w, cur_bullet_time, true);
                if (!this.collision_detected) {
                    i = 0;
                    while (i < 5) {
                        cur_bullet_time = prediction_gap + cur_prediction.R / bullet_speed;
                        old_bullet_time = cur_bullet_time;
                        if (!(Math.abs(cur_bullet_time - old_bullet_time) < 0.5)) {
                            cur_prediction = this.get_predicted_point(v, w, cur_bullet_time, false);
                            ++i;
                            continue;
                        }
                        break;
                    }
                }
            } else {
                cur_prediction.reset(this.a, this.R);
            }
            this.predicted_vector.reset(cur_prediction.a, cur_prediction.R);
            return this.predicted_vector;
        }

        private vect_t get_predicted_point(double v, double w, double t, boolean check_collisions) {
            vect_t cur_prediction = new vect_t(this.a, this.R);
            double time_discret = 5.0;
            if (check_collisions) {
                double i = 0.0;
                while (i * time_discret < t) {
                    double time_delta = Math.min(time_discret, t - i * time_discret);
                    cur_prediction.add(MicroTestBot.this.get_path(v, w, this.cur_target_heading, time_delta));
                    if (this.vector_out_of_field(cur_prediction)) {
                        this.collision_detected = true;
                        cur_prediction.reset(this.a, this.R);
                        cur_prediction.add(MicroTestBot.this.get_path(v, w, this.cur_target_heading, i * time_discret));
                        int j = 1;
                        while ((double)j <= time_delta) {
                            cur_prediction.add(MicroTestBot.this.get_path(v, w, this.cur_target_heading, 1.0));
                            if (this.vector_out_of_field(cur_prediction)) {
                                cur_prediction.reset(this.a, this.R);
                                cur_prediction.add(MicroTestBot.this.get_path(v, w, this.cur_target_heading, i * time_discret + (double)j));
                                return cur_prediction;
                            }
                            ++j;
                        }
                        cur_prediction.reset(this.a, this.R);
                        cur_prediction.add(MicroTestBot.this.get_path(v, w, this.cur_target_heading, i * time_discret + time_delta));
                        return cur_prediction;
                    }
                    i += 1.0;
                }
            }
            cur_prediction.reset(this.a, this.R);
            cur_prediction.add(MicroTestBot.this.get_path(v, w, this.cur_target_heading, t));
            return cur_prediction;
        }

        private boolean vector_out_of_field(vect_t vector) {
            double x = MicroTestBot.this.getX() + vector.x;
            double y = MicroTestBot.this.getY() + vector.y;
            return x < 0.0 + MicroTestBot.this.collision_delta || x > MicroTestBot.this.battlefield_width - MicroTestBot.this.collision_delta || y < 0.0 + MicroTestBot.this.collision_delta || y > MicroTestBot.this.battlefield_height - MicroTestBot.this.collision_delta;
        }
    }

    public class targets_t {
        public target_t closest_target;
        private final double targets_k_delta = 13.0;
        private double targets_k;
        private Hashtable targets_table = new Hashtable(1);
        private long last_scan_completion_time = 0L;

        public void begin_round() {
            Enumeration targets_list = this.targets_table.elements();
            this.targets_k = 270.0 - (double)MicroTestBot.this.getOthers() * 13.0;
            if (this.targets_k <= 0.0) {
                this.targets_k = 10.0;
            }
            this.closest_target = null;
            while (targets_list.hasMoreElements()) {
                target_t t = (target_t)targets_list.nextElement();
                t.begin_round();
            }
            this.last_scan_completion_time = 0L;
        }

        public void begin_turn() {
            Enumeration targets_list = this.targets_table.elements();
            while (targets_list.hasMoreElements()) {
                target_t t = (target_t)targets_list.nextElement();
                t.refresh();
            }
            this.closest_target = this.get_closest_target(100.0);
        }

        public void update(ScannedRobotEvent e) {
            String robot_name = e.getName();
            target_t t = (target_t)this.targets_table.get(robot_name);
            if (t != null) {
                t.update(e);
            } else {
                t = new target_t(e);
                this.targets_table.put(robot_name, t);
            }
        }

        public void one_less(RobotDeathEvent e) {
            String robot_name = e.getName();
            target_t t = (target_t)this.targets_table.get(robot_name);
            this.targets_k += 13.0;
            if (t != null) {
                t.destroyed();
            }
        }

        public void hit(BulletHitEvent e) {
            String robot_name = e.getName();
            target_t t = (target_t)this.targets_table.get(robot_name);
            if (t != null) {
                t.hit();
            }
        }

        public void collide(HitRobotEvent e) {
            String robot_name = e.getName();
            target_t t = (target_t)this.targets_table.get(robot_name);
            if (t != null) {
                t.collide();
            }
        }

        public void hit_by_bullet(HitByBulletEvent e) {
            String robot_name = e.getName();
            target_t t = (target_t)this.targets_table.get(robot_name);
            if (t != null) {
                t.hit_by_bullet();
            }
        }

        public target_t get_closest_target(double time_on_aiming) {
            Enumeration targets_list = this.targets_table.elements();
            target_t chosen_target = null;
            target_t t = null;
            while (targets_list.hasMoreElements()) {
                t = (target_t)targets_list.nextElement();
                if (!t.is_tracked() || !(Math.abs(MicroTestBot.this.get_angle_diff(MicroTestBot.this.gunner.cur_heading(), t.a)) < time_on_aiming * MicroTestBot.this.gun_rotation_speed)) continue;
                if (chosen_target == null) {
                    chosen_target = t;
                    continue;
                }
                if (!(t.R < chosen_target.R)) continue;
                chosen_target = t;
            }
            return chosen_target;
        }

        public vect_t get_reaction_vector() {
            Enumeration targets_list = this.targets_table.elements();
            vect_t reaction = new vect_t();
            while (targets_list.hasMoreElements()) {
                target_t t = (target_t)targets_list.nextElement();
                if (!t.is_tracked()) continue;
                reaction.addrad(MicroTestBot.this.normalize_angle(t.a + Math.PI), this.targets_k / t.R);
            }
            return reaction;
        }

        /*
         * Unable to fully structure code
         */
        public boolean scan_completed() {
            targets_list = this.targets_table.elements();
            tracked_targets = 0;
            if (!targets_list.hasMoreElements()) {
                return false;
            }
            if (MicroTestBot.access$1(MicroTestBot.this) >= 20L) ** GOTO lbl12
            return false;
lbl-1000:
            // 1 sources

            {
                t = (target_t)targets_list.nextElement();
                if (!t.is_tracked()) continue;
                if (!t.was_scanned_after(this.last_scan_completion_time)) {
                    return false;
                }
                ++tracked_targets;
lbl12:
                // 3 sources

                ** while (targets_list.hasMoreElements())
            }
lbl13:
            // 1 sources

            if (tracked_targets > 0) {
                this.last_scan_completion_time = MicroTestBot.access$1(MicroTestBot.this);
                return true;
            }
            return false;
        }

        public void show_statistics() {
            Enumeration targets_list = this.targets_table.elements();
            while (targets_list.hasMoreElements()) {
                target_t t = (target_t)targets_list.nextElement();
                t.show_statistics();
            }
        }
    }

    public class vect_t {
        public double a;
        public double R;
        public double x;
        public double y;

        vect_t() {
            this.reset();
        }

        vect_t(double a1, double R1) {
            this.reset(a1, R1);
        }

        public void reset() {
            this.a = 0.0;
            this.R = 0.0;
            this.x = 0.0;
            this.y = 0.0;
        }

        public void reset(double a1, double R1) {
            this.a = a1;
            this.R = R1;
            this.x = R1 * Math.sin(a1);
            this.y = R1 * Math.cos(a1);
        }

        public void add(vect_t vect2) {
            this.adddec(vect2.x, vect2.y);
        }

        public void adddec(double x2, double y2) {
            double x1 = this.x;
            double y1 = this.y;
            double x3 = 0.0;
            double y3 = 0.0;
            double a3 = 0.0;
            double R3 = 0.0;
            x3 = x1 + x2;
            y3 = y1 + y2;
            R3 = x3 * x3 + y3 * y3;
            this.x = x3;
            this.y = y3;
            if (R3 < 0.0) {
                return;
            }
            R3 = Math.sqrt(R3);
            a3 = MicroTestBot.this.get_angle(x3, y3);
            this.a = MicroTestBot.this.normalize_angle(a3);
            this.R = R3;
        }

        public void addrad(double a2, double R2) {
            double x1 = this.x;
            double y1 = this.y;
            double x2 = 0.0;
            double y2 = 0.0;
            double x3 = 0.0;
            double y3 = 0.0;
            double a3 = 0.0;
            double R3 = 0.0;
            x2 = R2 * Math.sin(a2);
            y2 = R2 * Math.cos(a2);
            x3 = x1 + x2;
            y3 = y1 + y2;
            R3 = x3 * x3 + y3 * y3;
            this.x = x3;
            this.y = y3;
            if (R3 < 0.0) {
                return;
            }
            R3 = Math.sqrt(R3);
            a3 = MicroTestBot.this.get_angle(x3, y3);
            this.a = MicroTestBot.this.normalize_angle(a3);
            this.R = R3;
        }
    }
}

