/*
 * Decompiled with CFR 0.152.
 */
package wcsv.PowerHouse.Gun;

import java.util.LinkedList;
import java.util.ListIterator;
import robocode.AdvancedRobot;
import wcsv.PowerHouse.Gun.GFGun;
import wcsv.PowerHouse.Gun.Gun;
import wcsv.PowerHouse.Utilities.Coordinator;
import wcsv.PowerHouse.Utilities.Target;
import wcsv.PowerHouse.Utilities.Utilities;
import wcsv.PowerHouse.Utilities.Wave;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GunCoordinator
extends Coordinator {
    private static final double MIN_GUN_TURN = 0.001;
    private static Gun gun;
    public static long actualBulletHits;
    public static long actualBulletMisses;
    public double bulletPower;
    public boolean aim;
    public boolean willFireThisTick;
    public LinkedList waves;
    public Wave wave;

    public void performAction(Target target, Target source) {
        if (this.robot.getGunHeat() > this.robot.getGunCoolingRate()) {
            this.robot.setTurnGunRightRadians(Utilities.relativeAngle(target.absoluteBearing - this.robot.getGunHeadingRadians()));
            this.aim = false;
        } else if (this.willFireThisTick && this.robot.setFireBullet(this.bulletPower) != null) {
            this.aim = false;
        } else {
            this.robot.setTurnGunRightRadians(Utilities.relativeAngle(this.getFiringAngle(target, source) - this.robot.getGunHeadingRadians()));
            this.aim = true;
        }
    }

    public void reset() {
        this.waves = new LinkedList();
        System.out.println("Real Bullet Hit %: " + Double.toString((double)actualBulletHits / (double)(actualBulletHits + actualBulletMisses) * 100.0));
        System.out.println("---");
    }

    public double getFiringAngle(Target t, Target src) {
        if (t.energy <= 0.0) {
            return t.absoluteBearing;
        }
        return gun.computeFiringAngle(t, src, this.wave);
    }

    public void update(Target target, Target source) {
        boolean bl = false;
        if (this.aim && Math.abs(this.robot.getGunTurnRemainingRadians()) < 0.001) {
            bl = this.willFireThisTick = true;
        }
        if (target.energy <= 0.0) {
            return;
        }
        this.bulletPower = Math.max(Math.min(600.0 / target.distance, (double)3), (double)2);
        this.bulletPower = Math.min(this.bulletPower, target.energy / (double)4);
        this.bulletPower = Math.min(this.bulletPower, source.energy / (double)5);
        Wave added = this.wave = new Wave(source, target, this.bulletPower, 0, this.willFireThisTick);
        this.waves.add(added);
        ListIterator it = this.waves.listIterator();
        while (it.hasNext()) {
            Wave w = (Wave)it.next();
            w.advance();
            if (!(w.distanceToPoint(target.location) <= 18.0)) continue;
            gun.update(target, w);
            it.remove();
        }
    }

    private final /* synthetic */ void this() {
        this.aim = false;
        this.willFireThisTick = false;
    }

    public GunCoordinator(AdvancedRobot ar) {
        super(ar);
        this.this();
        this.waves = new LinkedList();
        gun = new GFGun();
        this.bulletPower = 3;
    }

    static {
        actualBulletHits = 0L;
        actualBulletMisses = 0L;
    }
}

