/*
 * Decompiled with CFR 0.152.
 */
package wcsv.PowerHouse.Utilities;

import wcsv.PowerHouse.Utilities.Utilities;
import wcsv.PowerHouse.Utilities.Wave;

public class SegmentationDimension {
    public double minValue;
    public double maxValue;
    public double interval;
    public int intervalCount;
    public int segments;

    public static int getIndex(SegmentationDimension s, double value) {
        int i = 0;
        while (i < s.segments) {
            if (value <= s.minValue + (double)i * s.interval) {
                return i;
            }
            ++i;
        }
        return s.segments;
    }

    public static int wallIndex(Wave w, SegmentationDimension s) {
        double dist = w.targetRobot.distance;
        int i = 0;
        while (i < s.segments) {
            if (Utilities.outsideWall(Utilities.projectPoint(w.sourceRobot.location, (s.minValue + (double)i * s.interval) * (double)w.targetRobot.orbitDir + w.targetRobot.absoluteBearing, dist))) {
                return i;
            }
            ++i;
        }
        return s.segments;
    }

    public SegmentationDimension(double min, double max, int intervals) {
        this.minValue = min;
        this.maxValue = max;
        this.intervalCount = intervals;
        this.segments = intervals + 1;
        this.interval = (max - min) / (double)intervals;
    }
}

