/*
 * Decompiled with CFR 0.152.
 */
package pulsar.gf;

import pulsar.gf.Segmentation;
import pulsar.util.RobotData;

public class LateralVelocitySegmentation
extends Segmentation {
    public LateralVelocitySegmentation() {
        this(0);
    }

    public LateralVelocitySegmentation(int segmentation) {
        switch (segmentation) {
            case 0: {
                this.setLimits(new double[]{3, 6});
                break;
            }
            case 1: {
                this.setLimits(new double[]{0.5, 3, 5, 7.51});
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid segmentation: " + segmentation);
            }
        }
    }

    protected double getValue(RobotData firedFrom, RobotData firedAt, int stepsBack) {
        return Math.abs(firedAt.getLateralVelocityRelativeTo(firedFrom, stepsBack));
    }
}

