/*
 * Decompiled with CFR 0.152.
 */
package pulsar.gf;

import java.awt.geom.Point2D;
import pulsar.PulsarMax;
import pulsar.gf.Segmentation;
import pulsar.util.RobotData;
import pulsar.util.Util;

public class Wall2Segmentation
extends Segmentation {
    private double direction = 1.0;

    public Wall2Segmentation(int segmentation) {
        this(segmentation, 1.0);
    }

    public Wall2Segmentation(int segmentation, double direction) {
        switch (segmentation) {
            case 0: {
                this.setLimits(new double[]{0.35, 0.8});
                break;
            }
            case 1: {
                this.setLimits(new double[]{0.4, 0.9});
                break;
            }
            case 2: {
                this.setLimits(new double[]{0.2, 0.5, 0.8, 1.2});
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid segmentation: " + segmentation);
            }
        }
        this.direction = direction;
    }

    private static Point2D project(double x, double y, double angle, double length) {
        return new Point2D.Double(x + Math.sin(angle) * length, y + Math.cos(angle) * length);
    }

    protected double getValue(RobotData firedFrom, RobotData firedAt, int stepsBack) {
        double distance = firedFrom.getDistanceTo(firedAt, stepsBack);
        double absBearing = firedFrom.getAbsBearingTo(firedAt, stepsBack);
        double latVel = Util.sign(firedAt.getLateralVelocityRelativeTo(firedFrom, stepsBack));
        double maxEscapeAngle = Util.maxEscapeAngle(firedFrom.lastFirePower);
        double d = 0.0;
        while (!(d >= (double)2)) {
            if (!PulsarMax.fieldWithMargin.contains(Wall2Segmentation.project(firedFrom.getValue(firedFrom.x, stepsBack), firedFrom.getValue(firedFrom.y, stepsBack), absBearing + latVel * this.direction * maxEscapeAngle * d, distance))) {
                return d;
            }
            d += 0.01;
        }
        return 2;
    }
}

