/*
 * Decompiled with CFR 0.152.
 */
package origin;

import java.awt.geom.Point2D;
import origin.Analysis;
import origin.Enemy;
import origin.SleepSiphon;
import origin.Util;
import robocode.Rules;
import robocode.util.Utils;

public class Aim {
    public static void basic(SleepSiphon self, Enemy target, double BULLET_POWER) {
        if (self.getGunTurnRemaining() == 0.0 && target != null) {
            double targetAbsoluteBearing = self.getHeadingRadians() + target.getBearing();
            self.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(targetAbsoluteBearing - self.getGunHeadingRadians())));
            self.setFire(BULLET_POWER);
        }
    }

    public static double firePowerByDist(SleepSiphon self, Enemy target) {
        double currentDist = Math.sqrt(Math.pow(target.getX() - self.getX(), 2.0) + Math.pow(target.getY() - self.getY(), 2.0));
        double power = Util.limitValueBounds(1.0 / (currentDist / Math.min(Math.max(self.getBattleFieldWidth(), self.getBattleFieldHeight()), 1000.0)), 1.5, 3.0);
        return power;
    }

    public static double[] linearPredictionFire(SleepSiphon self, Enemy target, double BULLET_POWER) {
        double c;
        double bulletVelocity;
        double a2;
        double a;
        double eVelocityY;
        double time = -1.0;
        double endX = 0.0;
        double endY = 0.0;
        double eX = target.getX() - self.getX();
        double eY = target.getY() - self.getY();
        double eVelocityX = target.getVelocity() * Math.sin(target.getHeading());
        double b = 2.0 * (eX * eVelocityX + eY * (eVelocityY = target.getVelocity() * Math.cos(target.getHeading())));
        double discrim = b * b - 4.0 * (a = eVelocityX * eVelocityX + eVelocityY * eVelocityY - (a2 = (bulletVelocity = Rules.getBulletSpeed((double)BULLET_POWER)) * bulletVelocity)) * (c = eX * eX + eY * eY);
        if (discrim >= 0.0) {
            double t2;
            double t1 = (-b + Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
            time = (Math.min(t1, t2 = (-b - Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a)) >= 0.0 ? Math.min(t1, t2) : Math.max(t1, t2)) + (double)(self.getTime() - target.getTime());
            double[] bounds = Util.getFieldBoundsxXyY();
            endX = Util.limitValueBounds(eX + self.getX() + eVelocityX * time, bounds[0], bounds[1]);
            endY = Util.limitValueBounds(eY + self.getY() + eVelocityY * time, bounds[2], bounds[3]);
            self.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(Math.atan2(endX - self.getX(), endY - self.getY()) - self.getGunHeadingRadians())));
            self.setFire(BULLET_POWER);
        }
        return new double[]{endX, endY, time};
    }

    public static Point2D.Double constantTurnPredict(SleepSiphon self, Enemy target, double BULLET_POWER) {
        double turnRate = target.getLatestTurnRate();
        double relX = target.getX() - self.getX();
        double relY = target.getY() - self.getY();
        double cHeading = target.getHeading();
        double velocity = target.getVelocity();
        double selfX = self.getX();
        double selfY = self.getY();
        double deltaTime = 0.0;
        double bulletVelocity = Rules.getBulletSpeed((double)BULLET_POWER);
        while (bulletVelocity * deltaTime < Math.abs(Point2D.distance(0.0, 0.0, relX, relY))) {
            relX += velocity * Math.sin(cHeading + turnRate);
            relY += velocity * Math.cos(cHeading + turnRate);
            cHeading += turnRate;
            deltaTime += 1.0;
        }
        Point2D.Double targetCoord = Util.limitCoordinateToMap(new Point2D.Double(relX + selfX, relY + selfY));
        Aim.aimToCoordinate(self, targetCoord);
        self.setFire(BULLET_POWER);
        return targetCoord;
    }

    public static Point2D.Double predictCircle(SleepSiphon self, Enemy target) {
        double firePower = Aim.firePowerByDist(self, target);
        Point2D.Double predictedCoordinate = Analysis.predictInterceptionPoint_TargetConstantTurn(self, target, Analysis.predictConstantTurn(self, target), firePower);
        Aim.aimToCoordinate(self, predictedCoordinate);
        self.setFireBullet(firePower);
        return predictedCoordinate;
    }

    public static Point2D.Double averageMovementGun(SleepSiphon self, Enemy target, double BULLET_POWER) {
        double c;
        double bulletVelocity;
        double a2;
        double a;
        double avgVelocityY;
        double avgVelocity = Analysis.getAvgVelocity(target);
        double avgHeading = Analysis.getAvgHeading(target);
        double time = -1.0;
        double endX = 0.0;
        double endY = 0.0;
        double eX = target.getX() - self.getX();
        double eY = target.getY() - self.getY();
        double avgVelocityX = avgVelocity * Math.sin(avgHeading);
        double b = 2.0 * (eX * avgVelocityX + eY * (avgVelocityY = avgVelocity * Math.cos(avgHeading)));
        double discrim = b * b - 4.0 * (a = avgVelocityX * avgVelocityX + avgVelocityY * avgVelocityY - (a2 = (bulletVelocity = Rules.getBulletSpeed((double)BULLET_POWER)) * bulletVelocity)) * (c = eX * eX + eY * eY);
        if (discrim >= 0.0) {
            double t2;
            double t1 = (-b + Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
            time = (Math.min(t1, t2 = (-b - Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a)) >= 0.0 ? Math.min(t1, t2) : Math.max(t1, t2)) + (double)(self.getTime() - target.getTime());
            double[] bounds = Util.getFieldBoundsxXyY();
            endX = Util.limitValueBounds(eX + self.getX() + avgVelocityX * time, bounds[0], bounds[1]);
            endY = Util.limitValueBounds(eY + self.getY() + avgVelocityY * time, bounds[2], bounds[3]);
            self.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(Math.atan2(endX - self.getX(), endY - self.getY()) - self.getGunHeadingRadians())));
            self.setFire(BULLET_POWER);
        }
        Point2D.Double predictedPoint = new Point2D.Double(endX, endY);
        return predictedPoint;
    }

    public static void aimToCoordinate(SleepSiphon self, double x, double y) {
        self.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(Math.atan2(x - self.getX(), y - self.getY()) - self.getGunHeadingRadians())));
    }

    public static void aimToCoordinate(SleepSiphon self, Point2D.Double coords) {
        self.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(Math.atan2(coords.getX() - self.getX(), coords.getY() - self.getY()) - self.getGunHeadingRadians())));
    }
}

