/*
 * Decompiled with CFR 0.152.
 */
package origin;

import origin.BotData;

public class EnemyData
implements BotData {
    private double energy;
    private double bearing;
    private double distance;
    private double heading;
    private double velocity;
    private int time;
    private double x;
    private double y;
    private double prevHeading;
    private long timeSinceDecel;
    private int scanOrder;

    public EnemyData(double e, double b, double d, double h, double v, int t, double selfX, double selfY, double selfHeading, double pH, double pV, long tD, int so) {
        this.energy = e;
        this.bearing = b;
        this.distance = d;
        this.heading = h;
        this.velocity = v;
        this.time = t;
        this.x = selfX + Math.sin((selfHeading + b) % (Math.PI * 2)) * d;
        this.y = selfY + Math.cos((selfHeading + b) % (Math.PI * 2)) * d;
        this.prevHeading = pH;
        this.timeSinceDecel = pV == v ? 0L : tD + 1L;
        this.scanOrder = so;
    }

    public double getEnergy() {
        return this.energy;
    }

    public double getBearing() {
        return this.bearing;
    }

    public double getDistance() {
        return this.distance;
    }

    @Override
    public double getHeading() {
        return this.heading;
    }

    @Override
    public double getVelocity() {
        return this.velocity;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    public long getTimeSinceDecel() {
        return this.timeSinceDecel;
    }

    @Override
    public long getAge(long currentTime) {
        return currentTime - (long)this.time;
    }

    @Override
    public double getLatestTurnRate() {
        return this.heading - this.prevHeading;
    }

    public int getScanOrder() {
        return this.scanOrder;
    }
}

