/*
 * Decompiled with CFR 0.152.
 */
package origin;

import gun.VirtualAngleGuns;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import origin.Aim;
import origin.Analysis;
import origin.Enemy;
import origin.EnemyData;
import origin.EnemyML;
import origin.EnemyWave;
import origin.Graphics;
import origin.Gun;
import origin.MoveActor;
import origin.Radar;
import origin.SelfData;
import origin.SelfWave;
import origin.Target;
import origin.Util;
import origin.WeightedPoint;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobocodeFileOutputStream;
import robocode.RobocodeFileWriter;
import robocode.RobotDeathEvent;
import robocode.RoundEndedEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import util.TimedWeightedPoint;

public class SleepSiphon
extends AdvancedRobot {
    private int totalNumEnemies;
    private int knownEnemies = 0;
    private ConcurrentHashMap<String, Enemy> currentEnemies;
    private ArrayList<SelfData> selfDataHistory;
    private int radarMode = 3;
    private int targetMode = 0;
    private int moveMode = 9000;
    private String cTargetName = "";
    private Enemy cTargetEnemy;
    private int[] destinationXY = null;
    private boolean is1v1 = false;
    private Point2D.Double predictedEnemyPoint = null;
    private double[] predictedEnemyPointAtTime = new double[]{0.0, 0.0, -1.0};
    private double[] circleCenter = new double[2];
    private WeightedPoint[] destinationPoints = null;
    private int NUM_GUNS = 4;
    private VirtualAngleGuns vAngleGuns;
    private File gStats;
    RobocodeFileWriter gStatsWriter;
    private boolean fileOutput = false;
    private LinkedList<EnemyWave> eWaves = new LinkedList();
    private int pointsPerWave = 3;
    private Point2D.Double[] destinations = null;
    private TimedWeightedPoint[][] paths = null;
    private Point2D bestDestinationPoint = null;
    private double[] pathRisks = null;
    private static boolean gunToggle = true;
    Ellipse2D.Double[] closestDistCircles;
    private LinkedList<Bullet> myBullets;
    private Gun gunActor;
    private LinkedList<SelfWave> selfWaves;
    private static HashMap<String, EnemyML> enemiesml;
    private File debugFile;
    private RobocodeFileOutputStream debugWriter;
    private static HashMap<String, int[][]> bulletHitStats;
    private int moveWait = 0;
    private int scanOrder = 0;
    private int numAdded = 0;
    private static boolean showDistanceCircles;
    private static boolean showEnemyWaves;
    private static boolean showSelfWaves;
    private static boolean showMovement;
    private static int statsMode;
    private static final int NUMDISPLAYS = 4;
    private static final String disableGunPass = "johnpaul";
    private static String latestEightKeys;
    private static boolean vBulletDisplay;

    static {
        bulletHitStats = new HashMap();
        showDistanceCircles = false;
        showEnemyWaves = false;
        showSelfWaves = false;
        showMovement = false;
        statsMode = 0;
        latestEightKeys = "12345678";
        vBulletDisplay = false;
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        this.totalNumEnemies = this.getOthers();
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setColors(Color.black, Color.gray, Color.white, Color.orange, Color.yellow);
        this.currentEnemies = new ConcurrentHashMap<K, V>(this.getOthers());
        this.selfDataHistory = new ArrayList<E>(1000);
        SleepSiphon.enemiesml = new HashMap<K, V>(this.getOthers());
        this.setTurnRadarRight(Infinity);
        this.predictedEnemyPointAtTime[2] = -1.0;
        FIELD_BUFFER = 12.0;
        Util.setFieldBoundsArray(this, 12.0);
        this.vAngleGuns = new VirtualAngleGuns(this, this.currentEnemies);
        this.gStats = this.getDataFile("SleepSiphon_GunStats.csv");
        this.debugFile = this.getDataFile("debugOutput.log");
        try {
            this.debugWriter = new RobocodeFileOutputStream(this.debugFile);
            this.debugWriter.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("ERROR > Could not load the PrintWriter 'debugWriter' in the SleepSiphon class.");
            System.out.println("Local Exception Message:  " + e.getLocalizedMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.myBullets = new LinkedList<E>();
        this.selfWaves = new LinkedList<E>();
        this.gunActor = new Gun(this, this.myBullets, this.selfWaves, this.currentEnemies, SleepSiphon.enemiesml);
        prevHeading = this.getHeading();
        while (true) {
            block77: {
                block76: {
                    block74: {
                        block75: {
                            this.scanOrder = 0;
                            currentTime = this.getTime();
                            this.setGunColor(Graphics.spectrumCycleHSB());
                            this.setRadarColor(Graphics.gunFire(this.getGunHeat()));
                            this.closestDistCircles = Analysis.enemyDistToClosestCircles(this.currentEnemies);
                            this.selfDataHistory.add(new SelfData(this.getGunHeadingRadians(), this.getHeadingRadians(), this.getVelocity(), this.getX(), this.getY(), this.getTime(), prevHeading));
                            prevHeading = this.getHeadingRadians();
                            if (this.getOthers() == 1) {
                                this.is1v1 = true;
                            }
                            if (this.getOthers() > 0) {
                                i = 0;
                                while (i < this.selfWaves.size()) {
                                    sWave = this.selfWaves.get(i);
                                    if (sWave.getRemove()) {
                                        this.selfWaves.remove(i);
                                        --i;
                                    } else {
                                        sWave.update(currentTime);
                                    }
                                    ++i;
                                }
                            }
                            if (this.cTargetEnemy == null || !SleepSiphon.gunToggle) break block74;
                            this.vAngleGuns.virtualFireAll();
                            this.vAngleGuns.updateAll();
                            BULLET_POWER = Aim.firePowerByDist(this, this.cTargetEnemy);
                            if (this.getEnergy() < 0.2) {
                                BULLET_POWER = 0.0;
                            } else if (this.getEnergy() <= 5.0) {
                                BULLET_POWER = 0.1;
                            } else if (this.getEnergy() <= 15.0) {
                                BULLET_POWER *= 0.2;
                            } else if (this.getEnergy() <= 20.0) {
                                BULLET_POWER *= 0.3;
                            } else if (this.getEnergy() <= 25.0) {
                                BULLET_POWER *= 0.6;
                            } else if (this.getEnergy() >= 80.0) {
                                BULLET_POWER *= 2.0;
                            }
                            disabledEnemy = false;
                            for (Enemy cEnemy : this.currentEnemies.values()) {
                                if (cEnemy.getEnergy() != 0.0) continue;
                                this.gunActor.basic(cEnemy, 0.1);
                                disabledEnemy = true;
                            }
                            if (disabledEnemy || !(BULLET_POWER > 0.0)) break block74;
                            if (currentTime <= 70L && (this.getNumRounds() <= 1 || !(this.cTargetEnemy.getBestGunHitRate() >= 0.15))) break block75;
                            if (this.getGunHeat() == 0.0) {
                                System.out.println(String.format("[%d] %s", new Object[]{currentTime, "Firing at " + this.cTargetName + " With vGuns"}));
                            }
                            this.predictedEnemyPointAtTime = null;
                            switch (this.cTargetEnemy.getBestGun()) {
                                case 0: {
                                    this.gunActor.basic(this.cTargetEnemy, BULLET_POWER);
                                    break;
                                }
                                case 1: {
                                    this.predictedEnemyPointAtTime = this.gunActor.linearPredictionFire(this.cTargetEnemy, BULLET_POWER);
                                    this.predictedEnemyPoint = null;
                                    break;
                                }
                                case 2: {
                                    this.predictedEnemyPoint = this.gunActor.constantTurnPredict(this.cTargetEnemy, BULLET_POWER);
                                    break;
                                }
                                case 3: {
                                    this.predictedEnemyPoint = this.gunActor.averageMovementGun(this.cTargetEnemy, BULLET_POWER);
                                }
                            }
                            break block74;
                        }
                        if (SleepSiphon.enemiesml.get(this.cTargetName) == null) ** GOTO lbl-1000
                        SleepSiphon.enemiesml.get(this.cTargetName);
                        if (EnemyML.dataSet.size() > 5) {
                            this.predictedEnemyPoint = Util.limitCoordinateToMap(SleepSiphon.enemiesml.get(this.cTargetName).getPredictedCoordinate(new Point2D.Double(this.getX(), this.getY()), this.cTargetEnemy));
                            this.gunActor.aimToCoordinate(this.predictedEnemyPoint);
                            if (this.getGunHeat() == 0.0) {
                                this.gunActor.setFireBullet(BULLET_POWER);
                                System.out.println(String.format("[%d] %s", new Object[]{currentTime, " \t\t\tFiring at " + this.cTargetName + " Based on ML Data"}));
                            }
                        } else lbl-1000:
                        // 2 sources

                        {
                            this.predictedEnemyPoint = this.gunActor.constantTurnPredict(this.cTargetEnemy, BULLET_POWER);
                            System.out.print(String.format("[%d] No ML or vGun ||", new Object[]{currentTime}));
                        }
                    }
                    if (this.getGunHeat() > 0.5) {
                        if (this.targetMode == 0) {
                            this.cTargetName = Target.closest(this.currentEnemies);
                        } else if (this.targetMode == 1) {
                            System.out.println("THE IMPOSSIBLE HAS HAPPENED");
                        }
                        this.cTargetEnemy = this.currentEnemies.get(this.cTargetName);
                    }
                    if ((this.is1v1 || this.moveMode == 9000) && this.moveMode >= 0) {
                        for (Map.Entry<String, Enemy> entry : this.currentEnemies.entrySet()) {
                            cName = entry.getKey();
                            cEnemy = entry.getValue();
                            crashedEnemy = false;
                            crashedWall = false;
                            hitByBullet = false;
                            if (cEnemy.getClosestDist() < 50.0) {
                                System.out.println(String.valueOf(cName) + " " + cEnemy.getClosestDist());
                            }
                            if (cEnemy.getClosestDist() < 50.0) {
                                crashedEnemy = true;
                            }
                            if (cEnemy.getDistFromWall() < 20.0 && cEnemy.getVelocity() == 0.0) {
                                crashedWall = true;
                            }
                            if (!(cEnemy == null || cEnemy.numEntries() < 3 || crashedEnemy || crashedWall || hitByBullet || cEnemy.getUpdatedWaves())) {
                                eData = cEnemy.getDataSet();
                                eDataSize = eData.size();
                                eDmgTaken = cEnemy.getEnergyLostThisTurn();
                                eEnergyGained = cEnemy.getEnergyGainedThisTurn();
                                eEnergyDiffBetweenTurns = cEnemy.getEnergy() - cEnemy.getPreviousData().getEnergy();
                                eBulletPower = Math.abs(eEnergyDiffBetweenTurns - eDmgTaken + eEnergyGained);
                                if (eEnergyDiffBetweenTurns < 0.0 && eEnergyDiffBetweenTurns > -3.1) {
                                    this.eWaves.add(new EnemyWave(cEnemy.getPreviousData().getX(), cEnemy.getPreviousData().getY(), this.getTime() - 1L, Math.abs(eBulletPower), this.selfDataHistory.get(this.selfDataHistory.size() - 2), cName));
                                }
                                cEnemy.setEnergyLost(0.0);
                                cEnemy.setEnergyGained(0.0);
                                cEnemy.setUpdatedWaves(true);
                            }
                            closestWave = null;
                            closestDist = Infinity;
                            i = 0;
                            while (i < this.eWaves.size()) {
                                cWave = this.eWaves.get(i);
                                cDist = cWave.getDist(this.getX(), this.getY(), this.getTime());
                                if (cDist < closestDist) {
                                    closestDist = cDist;
                                    closestWave = cWave;
                                }
                                if (cDist < 40.0) {
                                    cWave.setClose();
                                }
                                if (cWave.getClose() <= 0) {
                                    this.eWaves.remove(i);
                                    --i;
                                }
                                ++i;
                            }
                        }
                        if ((this.is1v1 || this.moveMode == 9000) && this.cTargetEnemy != null) {
                            minDistance = 20.0;
                            this.destinations = MoveActor.generatePointsCircular(new Point2D.Double(this.getX(), this.getY()), 16, 150.0);
                            this.paths = MoveActor.generatePaths(this, this.destinations);
                            pathRisks_wave = Analysis.calcPathRisksByDist_WAVE(this.paths, this.eWaves, this.pointsPerWave, this.getTime());
                            pathRisks_bot = Analysis.calcPathRisksByDist_BOT(this.paths, this.cTargetEnemy.getLatest(), this.getTime());
                            Analysis.calcPath_repelWalls(this.paths);
                            pathRepelCorners = Analysis.calcPath_repelCorners(this.paths);
                            this.pathRisks = Analysis.getPathRisks(this.paths);
                            this.bestDestinationPoint = this.destinations[Analysis.getSafestPathIndex(this.pathRisks)];
                            MoveActor.aGoTo(this, this.bestDestinationPoint.getX(), this.bestDestinationPoint.getY());
                        }
                    }
                    if (this.moveWait != 0) break block76;
                    switch (this.moveMode) {
                        case 0: {
                            MoveActor.random(this);
                            break;
                        }
                        case 1: {
                            this.setMaxVelocity(5.0);
                            MoveActor.spin(this);
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            if (this.getOthers() > 1) {
                                this.destinationPoints = MoveActor.fourCornersLoose(this);
                                break;
                            }
                            this.moveMode = 4;
                            this.destinationXY = null;
                            break;
                        }
                        case 4: {
                            if (this.cTargetEnemy != null) {
                                this.destinationPoints = MoveActor.circularPointDistribution(this, this.cTargetEnemy);
                                break;
                            }
                            break block77;
                        }
                        case 5: {
                            if (this.getOthers() > 4) {
                                HYPOT = 150.0;
                                this.destinationPoints = MoveActor.circleDistribution_NeverClosest2(this, this.closestDistCircles, this.currentEnemies, 150.0);
                                break;
                            }
                            this.moveMode = 9000;
                            this.destinationPoints = null;
                            this.destinationXY = null;
                        }
                    }
                    break block77;
                }
                --this.moveWait;
            }
            if (this.cTargetName != null) {
                switch (this.radarMode) {
                    case 0: {
                        Radar.spinToCenter(this);
                        break;
                    }
                    case 1: {
                        Radar.infinityLock(this.cTargetEnemy, this);
                        break;
                    }
                    case 2: {
                        Radar.factorLock(this.cTargetEnemy, this);
                    }
                }
            }
            if (this.radarMode == 3) {
                if (this.currentEnemies.size() < this.getOthers() || this.cTargetEnemy == null) {
                    Radar.spinToCenter(this);
                    System.out.print(String.format("[%d] URS ||", new Object[]{currentTime}));
                } else if (this.getOthers() > 1) {
                    Radar.oldestScanned(this.currentEnemies, this);
                } else if (this.cTargetEnemy != null) {
                    if (this.cTargetEnemy.timeSinceUpdate((int)this.getTime()) > 8L) {
                        Radar.spinToCenter(this);
                    } else {
                        Radar.factorLock(this.cTargetEnemy, this);
                    }
                }
            } else if (this.radarMode == 0) {
                Radar.spinToCenter(this);
            }
            this.execute();
        }
    }

    public Point2D.Double getPosition() {
        return new Point2D.Double(this.getX(), this.getY());
    }

    public void onHitRobot(HitRobotEvent e) {
        MoveActor.circularAwayPointDistribution(this, this.cTargetEnemy, 150.0);
        this.moveWait = 16;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        ++this.scanOrder;
        if (this.knownEnemies < this.getOthers()) {
            if (!this.currentEnemies.containsKey(e.getName())) {
                if (!bulletHitStats.containsKey(e.getName())) {
                    bulletHitStats.put(e.getName(), new int[this.NUM_GUNS][2]);
                }
                this.currentEnemies.put(e.getName(), new Enemy(new EnemyData(e.getEnergy(), e.getBearingRadians(), e.getDistance(), e.getHeadingRadians(), e.getVelocity(), (int)this.getTime(), this.getX(), this.getY(), this.getHeadingRadians(), 0.0, 0.0, 0L, this.scanOrder), bulletHitStats.get(e.getName()), this.numAdded++));
                ++this.knownEnemies;
                if (!enemiesml.containsKey(e.getName())) {
                    enemiesml.put(e.getName(), new EnemyML());
                }
            } else {
                EnemyData cEnemyLastData = this.currentEnemies.get(e.getName()).getLatest();
                this.currentEnemies.get(e.getName()).addEnemyData(new EnemyData(e.getEnergy(), e.getBearingRadians(), e.getDistance(), e.getHeadingRadians(), e.getVelocity(), (int)this.getTime(), this.getX(), this.getY(), this.getHeadingRadians(), this.currentEnemies.get(e.getName()).getLatestTurnRate(), cEnemyLastData.getVelocity(), cEnemyLastData.getTimeSinceDecel(), this.scanOrder));
                this.currentEnemies.get(e.getName()).setUpdatedWaves(false);
            }
        } else {
            EnemyData cEnemyLastData = this.currentEnemies.get(e.getName()).getLatest();
            this.currentEnemies.get(e.getName()).addEnemyData(new EnemyData(e.getEnergy(), e.getBearingRadians(), e.getDistance(), e.getHeadingRadians(), e.getVelocity(), (int)this.getTime(), this.getX(), this.getY(), this.getHeadingRadians(), this.currentEnemies.get(e.getName()).getLatestTurnRate(), cEnemyLastData.getVelocity(), cEnemyLastData.getTimeSinceDecel(), this.scanOrder));
            this.currentEnemies.get(e.getName()).setUpdatedWaves(false);
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (this.currentEnemies.containsKey(e.getName())) {
            Enemy source = this.currentEnemies.get(e.getName());
            source.setEnergyGained(e.getPower() * 3.0);
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        if (this.currentEnemies.containsKey(e.getName())) {
            this.currentEnemies.get(e.getName()).setEnergyLost(Rules.getBulletDamage((double)e.getBullet().getPower()));
        }
    }

    public void onHitWall(HitWallEvent e) {
        System.out.println("I HIT A WALL!");
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (this.fileOutput) {
            try {
                this.gStatsWriter = new RobocodeFileWriter(this.gStats.getAbsolutePath(), true);
                this.gStatsWriter.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        this.currentEnemies.remove(e.getName());
        --this.knownEnemies;
        this.cTargetName = Target.closest(this.currentEnemies);
        this.cTargetEnemy = this.currentEnemies.get(this.cTargetName);
    }

    public void onRoundEnded(RoundEndedEvent e) {
        if (this.fileOutput) {
            System.out.println("Data Directory:\t" + this.gStats.getAbsolutePath());
            try {
                this.gStatsWriter = new RobocodeFileWriter(this.gStats.getAbsolutePath(), true);
                for (Map.Entry<String, Enemy> entry : this.currentEnemies.entrySet()) {
                }
                this.gStatsWriter.append((CharSequence)"\n");
                this.gStatsWriter.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        } else {
            System.out.println("File writing is disabled");
        }
    }

    public void onKeyPressed(KeyEvent e) {
        latestEightKeys = String.valueOf(latestEightKeys.substring(1)) + e.getKeyChar();
        if (e.getKeyChar() == 'd') {
            showDistanceCircles = !showDistanceCircles;
        } else if (e.getKeyChar() == 'w') {
            showEnemyWaves = !showEnemyWaves;
        } else if (e.getKeyChar() == 'm') {
            showMovement = !showMovement;
        } else if (e.getKeyChar() == 's') {
            showSelfWaves = !showSelfWaves;
        } else if (e.getKeyChar() == 'v') {
            vBulletDisplay = !vBulletDisplay;
        } else if (e.getKeyChar() == 'x') {
            statsMode = statsMode < 2 ? ++statsMode : 0;
        }
        if (disableGunPass.equals(latestEightKeys)) {
            gunToggle = !gunToggle;
        }
    }

    public void onPaint(Graphics2D g) {
        long cTime = this.getTime();
        g.setColor(new Color(255, 0, 255, 255));
        g.drawOval((int)this.getX() - 18, (int)this.getY() - 18, 36, 36);
        g.drawOval((int)this.getX() - 36, (int)this.getY() - 36, 72, 72);
        g.drawOval((int)this.getX() - 32, (int)this.getY() - 32, 64, 64);
        if (showDistanceCircles) {
            g.setColor(new Color(255, 255, 0, 255));
            int i = 0;
            while (i < this.closestDistCircles.length) {
                Ellipse2D.Double current = this.closestDistCircles[i];
                g.drawOval((int)current.getX(), (int)current.getY(), (int)current.getWidth(), (int)current.getHeight());
                ++i;
            }
        }
        if (showSelfWaves) {
            g.setColor(new Color(255, 255, 255, 150));
            for (SelfWave wave : this.selfWaves) {
                Ellipse2D.Double circle = wave.getCircle(cTime);
                g.drawOval((int)circle.getX(), (int)circle.getY(), (int)circle.getWidth(), (int)circle.getHeight());
            }
        }
        if (showEnemyWaves) {
            for (EnemyWave wave : this.eWaves) {
                Enemy waveSource = this.currentEnemies.get(wave.getSource());
                if (waveSource == null) continue;
                float hueValue = (float)((double)waveSource.getNumAddedID() / (double)this.totalNumEnemies);
                Color rgb = new Color(Color.HSBtoRGB(hueValue, 1.0f, 1.0f));
                Color rgba = new Color(rgb.getRed(), rgb.getGreen(), rgb.getBlue(), 100);
                g.setColor(rgba);
                Ellipse2D.Double circle = wave.getCircle(cTime);
                g.drawOval((int)circle.getX(), (int)circle.getY(), (int)circle.getWidth(), (int)circle.getHeight());
                Point2D.Double[] bulletLocs = wave.getBulletLocations(cTime);
                int j = 0;
                while (j < bulletLocs.length) {
                    g.setColor(new Color(Color.HSBtoRGB((float)(1.0 / (double)bulletLocs.length * (double)(j + 1)), 1.0f, 1.0f)));
                    int size1 = 8;
                    int size2 = 10;
                    int cBulletX = (int)bulletLocs[j].getX();
                    int cBulletY = (int)bulletLocs[j].getY();
                    g.drawOval(cBulletX - size1 / 2, cBulletY - size1 / 2, size1, size1);
                    g.setColor(new Color(255, 255, 255, 100));
                    g.fillOval(cBulletX - size2 / 2, cBulletY - size2 / 2, size2, size2);
                    ++j;
                }
            }
        }
        if (showMovement && this.destinations != null) {
            g.setColor(new Color(0, 255, 0, 100));
            Point2D.Double[] destinations = MoveActor.generatePointsCircular(new Point2D.Double(this.getX(), this.getY()), 16, 150.0);
            int rad = 4;
            int i = 0;
            while (i < this.paths.length) {
                g.fillOval((int)destinations[i].getX() - 4, (int)destinations[i].getY() - 4, 8, 8);
                int j = 0;
                while (j < this.paths[0].length) {
                    TimedWeightedPoint cPoint = this.paths[i][j];
                    g.setColor(new Color(Color.HSBtoRGB((float)cPoint.getWeight(), 1.0f, 1.0f)));
                    g.drawOval((int)cPoint.getX() - 4, (int)cPoint.getY() - 4, 8, 8);
                    ++j;
                }
                ++i;
            }
            Point2D.Double bestDestinationPoint = destinations[Analysis.getSafestPathIndex(this.pathRisks)];
            g.setColor(new Color(255, 255, 255, 255));
            g.drawLine((int)this.getX(), (int)this.getY(), (int)((Point2D)bestDestinationPoint).getX(), (int)((Point2D)bestDestinationPoint).getY());
        }
        g.setColor(new Color(0, 255, 0, 170));
        int yStart = 20;
        int xStart = 10;
        int lineSpacing = 10;
        g.drawString("EnemyCircles (d):  " + showDistanceCircles, 10, 30);
        g.drawString("EnemyWaves (w):  " + showEnemyWaves, 10, 40);
        g.drawString("MovePaths (m):  " + showMovement, 10, 50);
        switch (statsMode) {
            case 0: {
                g.drawString("Stats Mode: " + statsMode + " (Off)", 10, 10);
                break;
            }
            case 1: {
                g.drawString("Stats Mode: " + statsMode + " (1v1)", 10, 10);
                g.drawString("Target Name: " + this.cTargetName, 10, 110);
                g.drawString("Best vGun: " + this.cTargetEnemy.getBestGun(), 10, 100);
                break;
            }
            case 2: {
                g.drawString("Stats Mode: " + statsMode + " (Melee)", 10, 10);
            }
        }
        g.setColor(new Color(255, 0, 0, 128));
        for (Map.Entry<String, Enemy> entry : this.currentEnemies.entrySet()) {
            String name = entry.getKey();
            Enemy enemy = entry.getValue();
            if (name.equals(this.cTargetName)) {
                g.setColor(new Color(0, 255, 0, 255));
                g.drawLine((int)enemy.getX(), (int)enemy.getY(), (int)this.getX(), (int)this.getY());
                g.drawRect((int)enemy.getX() - 20, (int)enemy.getY() - 20, 40, 40);
                g.setColor(new Color(255, 0, 0, 128));
                continue;
            }
            g.drawRect((int)enemy.getX() - 20, (int)enemy.getY() - 20, 40, 40);
        }
        if (this.destinationXY != null) {
            g.setColor(new Color(255, 0, 0));
            g.fillOval(this.destinationXY[0], this.destinationXY[1], 10, 10);
        } else if (this.destinationPoints != null) {
            int i = 0;
            while (i < this.destinationPoints.length) {
                g.setColor(new Color((int)(this.destinationPoints[i].getWeight() * 255.0) % 255, ((int)(this.destinationPoints[i].getWeight() * 127.0) + 63) % 255, 0, 200));
                g.fillOval((int)this.destinationPoints[i].getX(), (int)this.destinationPoints[i].getY(), 7, 7);
                ++i;
            }
        }
        if (this.cTargetEnemy != null) {
            if (this.predictedEnemyPointAtTime != null && this.predictedEnemyPointAtTime[2] != -1.0) {
                g.setColor(new Color(15, 255, 0, 128));
                g.fillOval((int)this.predictedEnemyPointAtTime[0] - 20, (int)this.predictedEnemyPointAtTime[1] - 20, 40, 40);
                g.drawLine((int)this.cTargetEnemy.getX(), (int)this.cTargetEnemy.getY(), (int)this.predictedEnemyPointAtTime[0], (int)this.predictedEnemyPointAtTime[1]);
                g.drawString(new String("Prediction time offset: " + Math.round(this.predictedEnemyPointAtTime[2]) + " ticks.  -  " + this.getName()), 0, 0);
                g.setColor(new Color(255, 0, 255, 128));
                g.fillOval((int)this.circleCenter[0] - 10 + (int)this.getX(), (int)this.circleCenter[1] - 10 + (int)this.getY(), 20, 20);
            }
            if (this.predictedEnemyPoint != null) {
                g.setColor(new Color(255, 255, 0, 128));
                g.fillOval((int)this.predictedEnemyPoint.getX() - 20, (int)this.predictedEnemyPoint.getY() - 20, 40, 40);
                g.drawLine((int)this.cTargetEnemy.getX(), (int)this.cTargetEnemy.getY(), (int)this.predictedEnemyPoint.getX(), (int)this.predictedEnemyPoint.getY());
            }
            this.vAngleGuns.onPaint(g, vBulletDisplay);
        }
    }
}

