/*
 * Decompiled with CFR 0.152.
 */
package de._4geeks.robots.guns.DC;

import de._4geeks.robots.guns.DC.EnemyInfo;
import de._4geeks.robots.guns.manager.EnemyScan;
import de._4geeks.robots.guns.manager.Wave;
import de._4geeks.robots.utils.SUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EnemyFeature
implements Cloneable {
    private double weight = 1.0;
    protected double[] slices;
    private boolean isCachedAttributeEntropy = false;
    private double cachedAttributeEntropy;

    public abstract double getAttributeValue(EnemyScan var1);

    public abstract double getAttributeValueNormalized(EnemyScan var1);

    public abstract String getFeatureName();

    public double getSegmentedGuessFactorEntropy(List<EnemyInfo> infos, int bins) {
        if (infos.size() == 0) {
            return 0.0;
        }
        long[][] vcs = new long[this.slices.length + 1][bins];
        for (EnemyInfo info : infos) {
            long[] lArray = vcs[SUtils.indexSlice(this.slices, this.getAttributeValue(info.getEnemy()))];
            int n = SUtils.indexGuessFactor(bins, info.getGuessFactor());
            lArray[n] = lArray[n] + 1L;
        }
        return SUtils.getEntropy(vcs);
    }

    public double getSegmentedGuessFactorInformationGain(List<EnemyInfo> infos, int bins) {
        if (infos.size() == 0) {
            return 0.0;
        }
        long[][] vcs = new long[this.slices.length + 1][bins];
        for (EnemyInfo info : infos) {
            long[] lArray = vcs[SUtils.indexSlice(this.slices, this.getAttributeValue(info.getEnemy()))];
            int n = SUtils.indexGuessFactor(bins, info.getGuessFactor());
            lArray[n] = lArray[n] + 1L;
        }
        return SUtils.informationGain(vcs);
    }

    public double getAttributeEntropy(List<EnemyInfo> infos) {
        if (this.isCachedAttributeEntropy) {
            return this.cachedAttributeEntropy;
        }
        long[] stats = new long[this.slices.length + 1];
        for (EnemyInfo info : infos) {
            int n = SUtils.indexSlice(this.slices, this.getAttributeValue(info.getEnemy()));
            stats[n] = stats[n] + 1L;
        }
        this.isCachedAttributeEntropy = true;
        return SUtils.getEntropy(stats, infos.size());
    }

    public double getMutualInformation(List<EnemyInfo> infos, EnemyFeature feat) {
        long[][] stats = new long[feat.slices.length + 1][this.slices.length + 1];
        for (EnemyInfo info : infos) {
            long[] lArray = stats[SUtils.indexSlice(feat.slices, feat.getAttributeValue(info.getEnemy()))];
            int n = SUtils.indexSlice(this.slices, this.getAttributeValue(info.getEnemy()));
            lArray[n] = lArray[n] + 1L;
        }
        return this.getAttributeEntropy(infos) - SUtils.getEntropy(stats);
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public void resetCache() {
        this.isCachedAttributeEntropy = false;
    }

    public double[] getSlices() {
        return this.slices;
    }

    public void setSlices(double[] slices) {
        this.slices = slices;
    }

    public int index(Wave wave) {
        return SUtils.indexSlice(this.slices, this.getAttributeValue(wave.getEnemy()));
    }

    public EnemyFeature clone() throws CloneNotSupportedException {
        return (EnemyFeature)super.clone();
    }
}

