/*
 * Decompiled with CFR 0.152.
 */
package DM.mega;

import DM.mega.Bullegon;
import DM.mega.InFire;
import DM.mega.Regicide;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Legs {
    private final AdvancedRobot self;
    static final int DIST_SEGS = 16;
    static final int VEL_SEGS = 16;
    static final int ACCEL_SEGS = 3;
    static final int WALL_DIST_SEGS = 16;
    static final int HEAD_SEGS = 16;
    static final int MAX_MAP_SIZE = 251;
    static final int SHRINK_TARGET = 224;
    static final int MAX_FLATTEN_SIZE = 255;
    static final int FLATTENER_SHRINK_TARGET = 124;
    static final int NUM_NEIGHBORS = 33;
    static final int NUM_FLATTENER_NEIGHBORS = 33;
    static final int B_POWER_SEGS = 6;
    static final int SECOND_WAVE_NEIGHBORS = 33;
    static final int ACCEL_BIN = 0;
    static final int DIST_BIN = 1;
    static final int VEL_BIN = 2;
    static final int WALL_BIN = 3;
    static final int REV_WALL_BIN = 4;
    static final int HEAD_BIN = 5;
    static final int BULLET_BIN = 6;
    final HashMap<float[], Double> offsetMap;
    final HashMap<float[], Double> flattenerMap;
    final List<InFire> waves;
    final List<Bullegon> shades;
    final List<Point2D.Double> futures;
    final List<Point2D.Double> secondFutures;
    final List<float[]> neighbors;
    final List<float[]> secondNeighbors;
    final List<float[]> flatteners;
    final List<float[]> secondFlatteners;
    final Point2D.Double enemyPos;
    final Point2D.Double myHead;
    final Point2D.Double myCenter;
    final double wallDistSegSize = 50.0;
    int activeID;
    int activeSecondID;
    double lastEHealth;
    double oldVelocity;
    double healthDisadvantage;
    double flattenerWeight;
    double lastShotPower;
    double waveBreakHeading;
    double waveBreakVelocity;
    double eAcc;
    double enemyPosX;
    double enemyPosY;
    double lastAbsBearing;
    double lastDistance;
    double lastHeading;
    double lastVelocity;
    double eRangeAcc;
    double oldFlattenerWeight;
    double eOldAbsVelocity;
    float distSeg;
    float velSeg;
    float accelSeg;
    float wallSpaceSeg;
    float revWallSpaceSeg;
    float headSeg;
    float bPowerSeg;
    long firstWaveBreak;
    long timeOfHit;
    int dir;
    int lastDir;
    int latDir;
    int goldenShades;
    int emptyDir;
    int eShots;
    int eHits;
    int eSide;
    int eRangeShots;
    int eRangeHits;
    boolean swapped;
    boolean swappedDualSurf;
    boolean updated;
    boolean surfTwo;

    public static <A, B, C> Stream<C> zip(Stream<A> stream, Stream<B> stream2, final BiFunction<A, B, C> biFunction) {
        final Iterator iterator = stream.iterator();
        final Iterator iterator2 = stream2.iterator();
        Iterator iterator3 = new Iterator<C>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext() && iterator2.hasNext();
            }

            @Override
            public C next() {
                return biFunction.apply(iterator.next(), iterator2.next());
            }
        };
        boolean bl = stream.isParallel() || stream2.isParallel();
        return Legs.iteratorToFiniteStream(iterator3, bl);
    }

    public static <T> Stream<T> iteratorToFiniteStream(Iterator<T> iterator, boolean bl) {
        Iterable iterable = () -> iterator;
        return StreamSupport.stream(iterable.spliterator(), bl);
    }

    public Legs(AdvancedRobot advancedRobot) {
        this.self = advancedRobot;
        this.offsetMap = new HashMap();
        this.flattenerMap = new HashMap();
        this.waves = new ArrayList<InFire>();
        this.shades = new ArrayList<Bullegon>();
        this.futures = new ArrayList<Point2D.Double>();
        this.secondFutures = new ArrayList<Point2D.Double>();
        this.neighbors = new ArrayList<float[]>();
        this.secondNeighbors = new ArrayList<float[]>();
        this.flatteners = new ArrayList<float[]>();
        this.secondFlatteners = new ArrayList<float[]>();
        this.enemyPos = new Point2D.Double(0.0, 0.0);
        this.myHead = new Point2D.Double(0.0, 0.0);
        this.myCenter = new Point2D.Double(0.0, 0.0);
        this.latDir = 1;
        this.emptyDir = 1;
        this.dir = 1;
        this.lastDir = 1;
        this.eSide = 1;
        this.flattenerWeight = 3.0;
        this.lastShotPower = 1.7;
    }

    public void update(ScannedRobotEvent scannedRobotEvent, List<Bullet> list, double d) {
        boolean bl = false;
        for (Bullegon bullegon : this.shades) {
            if (bullegon.parent != this.activeID || !bullegon.contains(new Point2D.Double(this.self.getX(), this.self.getY()))) continue;
            bl = true;
            break;
        }
        if (bl && !this.swapped) {
            this.self.setColors(Color.ORANGE, Color.YELLOW.darker(), Color.ORANGE);
            this.swapped = true;
        } else if (!bl && this.swapped) {
            this.self.setColors(Color.ORANGE.brighter().brighter(), Color.YELLOW.brighter(), Color.ORANGE.brighter().brighter());
            this.swapped = false;
        }
        this.eAcc = (double)this.eHits / Math.max((double)this.eShots, 1.0);
        this.eRangeAcc = (double)this.eRangeHits / Math.max((double)this.eRangeShots, 1.0);
        this.flattenerWeight = this.eRangeShots < 50 ? 0.0 : 0.4618 * (Math.min(33.0, (double)this.offsetMap.size() + 1.0) / 33.0);
        long l = this.self.getTime();
        this.enemyPosX = this.lastDistance * Math.sin(this.lastAbsBearing) + this.myCenter.x;
        this.enemyPosY = this.lastDistance * Math.cos(this.lastAbsBearing) + this.myCenter.y;
        this.latDir = this.self.getVelocity() == 0.0 ? this.latDir : (scannedRobotEvent.getBearingRadians() * this.self.getVelocity() >= 0.0 ? 1 : -1);
        this.eSide = Double.compare(scannedRobotEvent.getBearingRadians(), 0.0) == 0 ? this.eSide : Double.compare(scannedRobotEvent.getBearingRadians(), 0.0);
        this.lastAbsBearing = d;
        this.lastDistance = scannedRobotEvent.getDistance();
        this.lastHeading = scannedRobotEvent.getHeadingRadians();
        this.lastVelocity = this.self.getVelocity();
        this.determineSegmentation(scannedRobotEvent.getBearingRadians());
        this.oldFlattenerWeight = this.flattenerWeight;
        double d2 = this.lastEHealth - scannedRobotEvent.getEnergy();
        if (d2 <= 3.0 && d2 > 0.1 && Math.abs(Math.abs(scannedRobotEvent.getVelocity()) - this.eOldAbsVelocity) <= 2.05) {
            this.bPowerSeg = (int)(d2 / 3.0 * 6.0);
            this.waves.add(new InFire(this.enemyPos.x, this.enemyPos.y, Math.atan2(this.myCenter.x - this.enemyPos.x, this.myCenter.y - this.enemyPos.y), Rules.getBulletSpeed((double)d2), l - 1L, this.latDir, this.distSeg, this.velSeg, this.accelSeg, this.wallSpaceSeg, this.revWallSpaceSeg, this.headSeg, true, this.bPowerSeg, this.enemyPos.distance(this.myCenter) > 450.0));
            this.lastShotPower = d2;
        }
        this.lastEHealth = scannedRobotEvent.getEnergy();
        this.enemyPos.x = this.enemyPosX;
        this.enemyPos.y = this.enemyPosY;
        this.myCenter.x = this.self.getX();
        this.myCenter.y = this.self.getY();
        this.cull(this.shades);
        this.self.setMaxVelocity(8.0);
        InFire inFire = this.getSurfWave();
        if (!this.offsetMap.isEmpty() && inFire != null) {
            this.emptyDir = this.latDir;
            InFire inFire2 = this.getSecondWave();
            this.shades.addAll(this.findHallowedGround(list));
            this.futures.clear();
            this.futures.addAll(this.surfFromTill(this.myCenter, inFire, this.self.getHeadingRadians(), this.self.getVelocity(), this.self.getTime()));
            Point2D.Double double_ = this.getLeastDangerous(inFire, inFire2);
            this.driveTo(double_);
        } else {
            this.emptySurf(this.enemyPos);
        }
        this.oldVelocity = this.lastVelocity;
        this.eOldAbsVelocity = Math.abs(scannedRobotEvent.getVelocity());
    }

    private void emptySurf(Point2D.Double double_) {
        double d = Math.atan2(double_.x - this.myCenter.x, double_.y - this.myCenter.y);
        double d2 = Utils.normalRelativeAngle((double)(d - this.self.getHeadingRadians()));
        int n = this.emptyDir * this.sign(d2);
        double d3 = this.wallSmooth(this.myCenter, this.latDir, Utils.normalAbsoluteAngle((double)(d - 1.5707963267948966 * (double)this.sign(d2) - 0.3141592653589793 * (double)this.latDir)), n);
        Point2D.Double double_2 = this.project(this.myCenter, 135.0 * (double)n, d3);
        int n2 = 1;
        if (!Regicide.playTains(double_2) && double_2.distance(this.enemyPos) < this.myCenter.distance(this.enemyPos) || double_2.distance(this.enemyPos) + 97.0 < this.myCenter.distance(this.enemyPos)) {
            n2 = -1;
        }
        this.emptyDir *= n2;
        double d4 = Utils.normalRelativeAngle((double)(d3 - this.self.getHeadingRadians()));
        this.self.setTurnRightRadians(d4);
        this.self.setAhead(100.0 * (double)(n *= n2));
        this.self.setMaxVelocity(this.offsetMap.isEmpty() ? 4.0 : 8.0);
    }

    private void determineSegmentation(double d) {
        this.distSeg = (float)(this.lastDistance / 50.0);
        this.velSeg = (float)(Math.abs(this.lastVelocity) / 0.50625);
        this.accelSeg = (float)Double.compare(Math.abs(this.lastVelocity), Math.abs(this.oldVelocity)) + 1.0f;
        this.headSeg = (float)(Math.abs(1.5707963267948966 - Math.abs(d)) / 1.5707963267948966 * 16.0);
        double d2 = this.self.getVelocity() < 0.0 ? Math.PI + this.self.getHeadingRadians() : this.self.getHeadingRadians();
        double d3 = Utils.normalAbsoluteAngle((double)d2) < Math.PI ? (this.self.getBattleFieldWidth() - this.myCenter.x) / Math.cos(1.5707963267948966 - d2) : this.self.getX() / Math.cos(4.71238898038469 - d2);
        double d4 = Math.abs(Utils.normalRelativeAngle((double)d2)) < 1.5707963267948966 ? (this.self.getBattleFieldHeight() - this.self.getY()) / Math.cos(d2) : this.self.getY() / Math.cos(Math.PI - d2);
        this.wallSpaceSeg = (float)Math.min(16.0, Math.max(0.0, Math.min(d3, d4) / 50.0));
        d2 = Utils.normalRelativeAngle((double)(d2 + Math.PI));
        d3 = Utils.normalAbsoluteAngle((double)d2) < Math.PI ? (this.self.getBattleFieldWidth() - this.self.getX()) / Math.cos(1.5707963267948966 - d2) : this.self.getX() / Math.cos(4.71238898038469 - d2);
        d4 = Math.abs(Utils.normalRelativeAngle((double)d2)) < 1.5707963267948966 ? (this.self.getBattleFieldHeight() - this.self.getY()) / Math.cos(d2) : this.self.getY() / Math.cos(Math.PI - Utils.normalAbsoluteAngle((double)d2));
        this.revWallSpaceSeg = (float)Math.min(16.0, Math.max(0.0, Math.min(d3, d4) / 50.0));
    }

    private InFire getSurfWave() {
        long l = this.self.getTime();
        double d = Double.POSITIVE_INFINITY;
        InFire inFire = null;
        Iterator<InFire> iterator = this.waves.iterator();
        while (iterator.hasNext()) {
            InFire inFire2 = iterator.next();
            double d2 = inFire2.sourceDist(new Point2D.Double(this.self.getX(), this.self.getY())) / inFire2.velocity - (double)(l - inFire2.fireTime);
            if (d2 <= -3.0) {
                iterator.remove();
                ++this.eShots;
                ++this.eRangeShots;
                if (inFire2.isRange) continue;
                --this.eRangeShots;
                continue;
            }
            if (inFire2.checkHit(this.myCenter, l) && inFire2.isActive()) {
                this.flatten(inFire2);
                inFire2.setInactive();
                continue;
            }
            if (!(d2 < d) || !(d2 > 1.0) || !inFire2.isActive() || !inFire2.isReal) continue;
            d = d2;
            inFire = inFire2;
            this.activeID = inFire.hashCode();
            this.timeOfHit = (long)d2;
        }
        return inFire;
    }

    private InFire getSecondWave() {
        InFire inFire = null;
        long l = this.self.getTime();
        double d = Double.POSITIVE_INFINITY;
        for (InFire inFire2 : this.waves) {
            double d2 = inFire2.sourceDist(new Point2D.Double(this.self.getX(), this.self.getY())) / inFire2.velocity - (double)(l - inFire2.fireTime);
            if (inFire2.hashCode() == this.activeID || !(d2 < d) || !(d2 > (double)this.timeOfHit) || !inFire2.isActive() || !inFire2.isReal) continue;
            d = d2;
            inFire = inFire2;
            this.activeSecondID = inFire2.hashCode();
        }
        return inFire;
    }

    private List<Point2D.Double> surfFromTill(Point2D.Double double_, InFire inFire, double d, double d2, long l) {
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
        double d3 = 8.0;
        Point2D.Double double_2 = new Point2D.Double(double_.x, double_.y);
        boolean bl = Double.compare(d2, 2.0) <= 0;
        arrayList.add(double_2);
        for (int i = 1; i > -2; i -= 2) {
            double_2.x = double_.x;
            double_2.y = double_.y;
            double d4 = Math.atan2(inFire.sourceX() - double_2.x, inFire.sourceY() - double_2.y);
            double d5 = Utils.normalRelativeAngle((double)(d4 - d));
            int n = i * this.sign(d5);
            double d6 = this.wallSmooth(double_2, n, d4 - 1.5707963267948966 * (double)this.sign(d5) + (bl ? 0.0 : (double)(-n) * Rules.MAX_TURN_RATE_RADIANS * 1.8 * (this.healthDisadvantage + 2.7)), i);
            double d7 = d2 * (double)i < 0.0 ? d2 + 2.0 * (double)i : d2 + (double)i;
            d7 = this.limit(-d3, d7, d3);
            long l2 = l + 1L;
            double_2 = this.project(double_2, d7, d6);
            arrayList.add(double_2);
            while (!inFire.breaks(double_2, l2)) {
                bl = Double.compare(d7, 0.0) == 0;
                d4 = Math.atan2(inFire.sourceX() - double_2.x, inFire.sourceY() - double_2.y);
                d5 = Utils.normalRelativeAngle((double)(d4 - d6));
                n = i * this.sign(d5);
                d6 = this.wallSmooth(double_2, this.sign(d7 * d5), d4 - 1.5707963267948966 * (double)this.sign(d5) + (bl ? 0.0 : (double)(-n) * Rules.MAX_TURN_RATE_RADIANS * 1.8 * (this.healthDisadvantage + 2.7)), this.sign(d7));
                d7 += d7 * (double)i < 0.0 ? (double)(2 * i) : (double)i;
                d7 = this.limit(-d3, d7, d3);
                double_2 = this.project(double_2, d7, d6);
                arrayList.add(double_2);
                ++l2;
            }
        }
        return arrayList;
    }

    private Point2D.Double getLeastDangerous(InFire inFire, InFire inFire2) {
        this.neighbors.clear();
        this.flatteners.clear();
        this.secondNeighbors.clear();
        this.secondFlatteners.clear();
        float[] fArray4 = new float[]{inFire.accelSegD, inFire.distSegD, inFire.velSegD, inFire.wallSpaceSegD, inFire.revWallSpaceSegD, inFire.headSegD, inFire.bPowerSegD};
        double d2 = 2.0 * Math.atan(18.0 / this.dist(this.myCenter.x, this.myCenter.y, inFire.sourceX(), inFire.sourceY())) / 1.7;
        AtomicInteger atomicInteger = new AtomicInteger(-1);
        double[] dArray = new double[this.futures.size()];
        int n = this.futures.size() / Math.min(this.offsetMap.size(), 33);
        double d3 = this.flattenerWeight;
        Legs.zip(this.offsetMap.keySet().stream().sorted((fArray2, fArray3) -> Double.compare(this.manDistBetween((float[])fArray2, fArray4), this.manDistBetween((float[])fArray3, fArray4))).limit(33L), this.flattenerMap.keySet().stream().sorted((fArray2, fArray3) -> Double.compare(this.manDistBetween((float[])fArray2, fArray4), this.manDistBetween((float[])fArray3, fArray4))).limit(33L), (fArray, fArray2) -> new float[][]{fArray, fArray2}).flatMapToDouble(fArray -> {
            double d3 = this.offsetMap.get(fArray[0]);
            double d4 = this.flattenerMap.get(fArray[1]);
            return ((Stream)this.futures.stream().parallel()).mapToDouble(double_ -> {
                if (this.shades.stream().filter(bullegon -> bullegon.parent == inFire.hashCode() && bullegon.contains(new Rectangle2D.Double(double_.x - 5.0, double_.y - 5.0, 10.0, 10.0))).findAny().isPresent()) {
                    return 0.0;
                }
                double d5 = inFire.getOffsetFactor((Point2D.Double)double_);
                return Math.exp(-0.5 * ((d5 - d3) * (d5 - d3) / (d2 * d2))) + d3 * Math.exp(-0.5 * ((d5 - d4) * (d5 - d4) / (d2 * d2)));
            });
        }).forEach(d -> {
            int n = atomicInteger.incrementAndGet() % dArray.length;
            dArray[n] = dArray[n] + d;
        });
        int n2 = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] < dArray[n2])) continue;
            n2 = i;
        }
        return this.futures.get(n2);
    }

    private Point2D.Double predictToWith(Point2D.Double double_, InFire inFire) {
        long l = this.self.getTime();
        Point2D.Double double_2 = new Point2D.Double(this.myCenter.x, this.myCenter.y);
        double d = this.self.getHeadingRadians();
        double d2 = this.self.getVelocity();
        int n = 0;
        do {
            double d3 = double_2.distance(double_);
            double d4 = Utils.normalAbsoluteAngle((double)Math.atan2(double_.x - double_2.x, double_.y - double_2.y));
            double d5 = Utils.normalRelativeAngle((double)(d4 - d));
            int n2 = 1;
            if (Math.abs(d5) > 1.5707963267948966) {
                n2 = -1;
                d5 = Utils.normalRelativeAngle((double)(Math.PI - d5));
            }
            double d6 = Rules.getTurnRateRadians((double)Math.abs(d2));
            double d7 = d5;
            d5 = this.limit(-d6, d5, d6);
            d = Utils.normalAbsoluteAngle((double)(d + d5 * (double)Double.compare(d3, 0.0) * (double)n2));
            d2 = Legs.getNewVelocity2(d2, d3 * (double)n2);
            double_2.setLocation(this.project(double_2, d2, d));
        } while (!inFire.checkHit(double_2, l + (long)(++n)));
        this.firstWaveBreak = l + (long)n;
        this.waveBreakHeading = d;
        this.waveBreakVelocity = d2;
        return double_2;
    }

    private double getNewVelocity(double d, double d2) {
        double d3;
        if (d2 < 0.0) {
            return -this.getNewVelocity(-d, -d2);
        }
        double d4 = Math.abs(d);
        if (d < 0.0) {
            d3 = d4 - 2.0;
            if (d3 < 0.0) {
                double d5 = d4 / 2.0;
                double d6 = 1.0 - d5;
                d3 = Math.min(1.0 * d6, d2);
                d *= -1.0;
            }
        } else {
            double d7 = Legs.decelDistance(d4);
            long l = Math.round(Math.ceil((d4 - 2.0) / 2.0));
            double d8 = (double)(l + 1L) / 2.0 * (double)l * 2.0;
            d3 = d2 <= 2.0 ? Math.max(d4 - 2.0, d2) : (d2 <= d8 ? d4 - 2.0 + (d2 - d7) / (double)l : Math.min(d4 + 1.0, (double)l * 2.0 + (d2 - d8) / Math.max((double)(l + 1L), 2.0)));
        }
        d3 = Math.max(d4 - 2.0, Math.min(d4 + 1.0, Math.min(d3, this.getMaxVelocity(d2))));
        return d < 0.0 ? -d3 : d3;
    }

    private static final double decelDistance(double d) {
        double d2 = 0.0;
        while (d > 0.0) {
            d = Math.max(0.0, d - 2.0);
            d2 += d;
        }
        return d2;
    }

    double getMaxVelocity(double d) {
        long l = this.decelTime(d);
        double d2 = (double)l / 2.0 * (double)(l - 1L) * 2.0;
        return (double)(l - 1L) * 2.0 + (d - d2) / (double)l;
    }

    long decelTime(double d) {
        long l = 1L;
        while (!(d <= (double)((this.square(l) + l) / 2L) * 2.0)) {
            ++l;
        }
        return l;
    }

    long square(long l) {
        return l * l;
    }

    private static double getNewVelocity2(double d, double d2) {
        if (d2 < 0.0) {
            return -Legs.getNewVelocity2(-d, -d2);
        }
        double d3 = d2 == Double.POSITIVE_INFINITY ? 8.0 : Math.min(Legs.getMaxVelocity2(d2), 8.0);
        if (d >= 0.0) {
            return Math.max(d - 2.0, Math.min(d3, d + 1.0));
        }
        return Math.max(d - 1.0, Math.min(d3, d + Legs.maxDecel(-d)));
    }

    static final double getMaxVelocity2(double d) {
        double d2 = Math.max(1.0, Math.ceil((Math.sqrt(4.0 * d + 1.0) - 1.0) / 2.0));
        double d3 = d2 / 2.0 * (d2 - 1.0) * 2.0;
        return (d2 - 1.0) * 2.0 + (d - d3) / d2;
    }

    private static double maxDecel(double d) {
        double d2 = d / 2.0;
        double d3 = 1.0 - d2;
        return Math.min(1.0, d2) * 2.0 + Math.max(0.0, d3) * 1.0;
    }

    private void driveTo(Point2D.Double double_) {
        double d = double_.distance(this.myCenter);
        double d2 = Utils.normalAbsoluteAngle((double)Math.atan2(double_.x - this.myCenter.x, double_.y - this.myCenter.y));
        double d3 = Utils.normalRelativeAngle((double)(d2 - this.self.getHeadingRadians()));
        double d4 = 1.0;
        if (Math.abs(d3) > 1.5707963267948966) {
            d3 = Utils.normalRelativeAngle((double)(Math.PI - d3));
            d4 = -1.0;
        }
        double d5 = 2.0 * d;
        this.self.setAhead(d5 * d4);
        this.self.setTurnRightRadians(d3 * (double)Double.compare(d, 0.0) * d4);
    }

    private void flatten(InFire inFire) {
        float[] fArray = new float[]{this.self.getRoundNum(), this.self.getTime(), inFire.accelSegD, inFire.distSegD, inFire.velSegD, inFire.wallSpaceSegD, inFire.revWallSpaceSegD, inFire.headSegD, inFire.bPowerSegD};
        double d = inFire.getOffsetFactor(this.myCenter);
        this.flattenerMap.put(fArray, d);
    }

    private List<Bullegon> findHallowedGround(List<Bullet> list) {
        long l = this.self.getTime();
        ArrayList<Bullegon> arrayList = new ArrayList<Bullegon>(0);
        for (InFire inFire : this.waves) {
            if (!inFire.isReal) continue;
            double d = inFire.velocity * (double)(l - inFire.fireTime);
            Ellipse2D[] ellipse2DArray = new Ellipse2D[]{new Ellipse2D.Double(inFire.sourceX() - d + 0.01 * inFire.velocity, inFire.sourceY() - d + 0.01 * inFire.velocity, 2.0 * (d - 0.01 * inFire.velocity), 2.0 * (d - 0.01 * inFire.velocity)), new Ellipse2D.Double(inFire.sourceX() - d - 1.0 * inFire.velocity, inFire.sourceY() - d - 1.0 * inFire.velocity, 2.0 * (d + 1.0 * inFire.velocity), 2.0 * (d + 1.0 * inFire.velocity))};
            double d2 = inFire.sourceDist(new Point2D.Double(this.self.getX(), this.self.getY()));
            for (Bullet bullet : list) {
                int[] nArray = new int[4];
                int[] nArray2 = new int[4];
                int[] nArray3 = this.project(bullet.getX(), bullet.getY(), -0.0 * bullet.getVelocity(), bullet.getHeadingRadians());
                nArray[0] = nArray3[0];
                nArray2[0] = nArray3[1];
                int[] nArray4 = this.project(bullet.getX(), bullet.getY(), 1.0 * bullet.getVelocity(), bullet.getHeadingRadians());
                nArray[1] = nArray4[0];
                nArray2[1] = nArray4[1];
                Rectangle2D rectangle2D = new Line2D.Double(nArray[0], nArray2[0], nArray[1], nArray2[1]).getBounds2D();
                if (ellipse2DArray[0].intersects(rectangle2D) || !ellipse2DArray[1].intersects(rectangle2D)) continue;
                int[] nArray5 = this.project(inFire.sourceX(), inFire.sourceY(), 1.85 * d2, Math.atan2((double)nArray[1] - inFire.sourceX(), (double)nArray2[1] - inFire.sourceY()));
                nArray[2] = nArray5[0];
                nArray2[2] = nArray5[1];
                int[] nArray6 = this.project(inFire.sourceX(), inFire.sourceY(), 1.85 * d2, Math.atan2((double)nArray[0] - inFire.sourceX(), (double)nArray2[0] - inFire.sourceY()));
                nArray[3] = nArray6[0];
                nArray2[3] = nArray6[1];
                arrayList.add(new Bullegon(inFire.hashCode(), nArray, nArray2));
            }
        }
        return arrayList;
    }

    private double wallSmooth(Point2D.Double double_, int n, double d, int n2) {
        for (int i = 0; !Regicide.surfTains(this.project(double_, 156 * n2, d)) && i < 128; ++i) {
            d += 0.04908738521234052 * (double)n;
        }
        return d;
    }

    private void storeWave(InFire inFire, double d, double d2, boolean bl) {
        if (inFire == null) {
            System.out.println("Dropped waved, sir");
            return;
        }
        if (bl && this.dist(inFire.sourceX(), inFire.sourceY(), d, d2) > 450.0) {
            ++this.eRangeHits;
        }
        float[] fArray = new float[]{this.self.getRoundNum(), this.self.getTime(), inFire.accelSegD, inFire.distSegD, inFire.velSegD, inFire.wallSpaceSegD, inFire.revWallSpaceSegD, inFire.headSegD, inFire.bPowerSegD};
        double d3 = inFire.getOffsetFactor(new Point2D.Double(d, d2));
        this.offsetMap.put(fArray, d3);
    }

    public void storeBullet(Bullet bullet, boolean bl) {
        double d = this.myCenter.x;
        double d2 = this.myCenter.y;
        ++this.eHits;
        if (!bl) {
            --this.eHits;
            d = bullet.getX();
            d2 = bullet.getY();
        }
        InFire inFire = this.getWave(bullet);
        this.storeWave(inFire, d, d2, bl);
        if (inFire != null) {
            inFire.setInactive();
        }
    }

    private InFire getWave(Bullet bullet) {
        long l = this.self.getTime();
        InFire inFire = null;
        for (InFire inFire2 : this.waves) {
            if (!inFire2.isReal || !(Math.abs(inFire2.velocity - bullet.getVelocity()) < 0.1) || !(Math.abs(this.dist(bullet.getX(), bullet.getY(), inFire2.sourceX(), inFire2.sourceY()) - inFire2.velocity * (double)(l - 1L - inFire2.fireTime)) <= 1.5 * bullet.getVelocity())) continue;
            inFire = inFire2;
            break;
        }
        return inFire;
    }

    private void cull(List<Bullegon> list) {
        Iterator<Bullegon> iterator = list.iterator();
        while (iterator.hasNext()) {
            Bullegon bullegon = iterator.next();
            if (this.waves.stream().filter(inFire -> inFire.hashCode() == bullegon.parent).findAny().isPresent()) continue;
            iterator.remove();
        }
    }

    double manDistBetween(float[] fArray, float[] fArray2) {
        return Math.abs(fArray[2] - fArray2[0]) + Math.abs(fArray[3] - fArray2[1]) + Math.abs(fArray[4] - fArray2[2]) + Math.abs(fArray[5] - fArray2[3]) + Math.abs(fArray[6] - fArray2[4]) + Math.abs(fArray[7] - fArray2[5]) + Math.abs(fArray[8] - fArray2[6]);
    }

    private int[] project(double d, double d2, double d3, double d4) {
        return new int[]{(int)(d + d3 * Math.sin(d4)), (int)(d2 + d3 * Math.cos(d4))};
    }

    private Point2D.Double project(Point2D.Double double_, double d, double d2) {
        return new Point2D.Double(double_.x + d * Math.sin(d2), double_.y + d * Math.cos(d2));
    }

    double dist(double d, double d2, double d3, double d4) {
        return Math.sqrt((d - d3) * (d - d3) + (d2 - d4) * (d2 - d4));
    }

    int sign(double d) {
        return d < 0.0 ? -1 : 1;
    }

    double limit(double d, double d2, double d3) {
        return Math.max(d, Math.min(d2, d3));
    }

    public void onPaint(Graphics2D graphics2D) {
        long l = this.self.getTime();
        for (Bullegon object : this.shades) {
            if (object.parent == this.activeID) {
                graphics2D.setColor(!object.golden ? Color.MAGENTA : Color.YELLOW.darker().darker());
            } else {
                graphics2D.setColor(Color.GREEN.darker());
            }
            graphics2D.draw(object);
        }
        for (InFire inFire : this.waves) {
            if (!inFire.isReal) continue;
            graphics2D.setColor(inFire.checkHit(this.myCenter, l) ? Color.ORANGE.darker() : (inFire.hashCode() == this.activeSecondID ? Color.RED.darker() : (inFire.hashCode() == this.activeID ? Color.MAGENTA.darker() : Color.WHITE.darker().darker())));
            double d = inFire.velocity * (double)(l - inFire.fireTime);
            graphics2D.draw(new Ellipse2D.Double(inFire.sourceX() - d, inFire.sourceY() - d, 2.0 * d, 2.0 * d));
        }
        graphics2D.setColor(Color.MAGENTA.darker());
        for (Point2D.Double double_ : this.futures) {
            graphics2D.draw(new Ellipse2D.Double(double_.x - 2.0, double_.y - 2.0, 4.0, 4.0));
        }
        graphics2D.setColor(Color.RED.darker());
        for (Point2D.Double double_ : this.secondFutures) {
            graphics2D.draw(new Ellipse2D.Double(double_.x - 1.0, double_.y - 1.0, 2.0, 2.0));
        }
    }

    public void reset() {
        this.waves.clear();
        this.shades.clear();
        this.futures.clear();
        this.secondFutures.clear();
        this.neighbors.clear();
        this.flatteners.clear();
        this.secondNeighbors.clear();
        this.secondFlatteners.clear();
        this.activeID = 0;
        this.activeSecondID = 0;
        if (this.offsetMap.size() > 251) {
            System.out.println("Clearing " + (this.offsetMap.size() - 224) + " surf datums");
            this.offsetMap.keySet().stream().sorted((fArray, fArray2) -> fArray[0] == fArray2[0] ? Double.compare(fArray[1], fArray2[1]) : Double.compare(fArray[0], fArray2[0])).limit(this.offsetMap.size() - 224).forEach(fArray -> this.offsetMap.remove(fArray));
        }
        if (this.flattenerMap.size() > 255) {
            List list = this.flattenerMap.keySet().stream().sorted((fArray, fArray2) -> Double.compare(fArray[0], fArray2[0])).limit(this.flattenerMap.size() - 124).collect(Collectors.toList());
            System.out.println("Clearing " + list.size() + " flattening logs");
            for (float[] fArray3 : list) {
                this.flattenerMap.remove(fArray3);
            }
        }
        System.out.println("Real enemy acc (idgafwyt): %" + (double)Math.round(this.eAcc * 10000.0) / 100.0);
        System.out.println("Real enemy range acc     : %" + (double)Math.round(this.eRangeAcc * 10000.0) / 100.0);
        System.out.println("Arbitrary flattener weight: %" + (double)Math.round(this.flattenerWeight / (Math.min(33.0, (double)this.offsetMap.size() + 1.0) / 33.0) * 10000.0) / 100.0);
    }
}

