/*
 * Decompiled with CFR 0.152.
 */
package cf.RiO;

import cf.OPs.AspidLikeS_OP;
import cf.OPs.DisponserS_OP;
import cf.OPs.MirrorS_OP;
import cf.OPs.RandomS_OP;
import cf.OPs.RedRoseS_OP;
import cf.OPs.RiOxM_OP;
import cf.OPs.RiOxS_OP;
import cf.util.Calc;
import cf.util.Operator;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.Condition;
import robocode.DeathEvent;
import robocode.HitWallEvent;
import robocode.MoveCompleteCondition;
import robocode.RobocodeFileOutputStream;
import robocode.RobocodeFileWriter;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

public class RiOx
extends AdvancedRobot {
    Operator operator;
    boolean dodging = true;
    boolean firing = true;
    boolean moving = true;
    boolean debugging = false;
    int wallHit;
    File behaviorFile;
    BufferedReader readB;
    PrintWriter writeB;
    Vector scores;
    double thisScore = 0.0;
    public static final int RiOxS = 0;
    public static final int DisponserS = 1;
    public static final int AspidLikeS = 2;
    public static final int MirrorS = 3;
    public static final int RandomS = 4;
    public static final int RedRoseS = 5;
    public static final int MeleeM = 6;
    int currentOperator = -1;
    String e_name;
    boolean singleMode = false;

    public void run() {
        this.startInit();
        while (true) {
            this.operator.work();
        }
    }

    public void startInit() {
        this.readData();
        if (this.getOthers() == 1) {
            this.singleMode = true;
        }
        if (this.getRoundNum() == 0) {
            this.startInitFirst();
        } else {
            this.startInitNormal();
        }
    }

    public void startInitFirst() {
        if (this.getOthers() != 1) {
            this.operator = this.getMeleeOp();
            return;
        }
        if (this.getOthers() == 0) {
            System.out.println("No opp left");
            return;
        }
        if (this.debugging) {
            System.out.println("Suche bot");
        }
        this.stop();
        while (this.e_name == null) {
            this.turnRadarRight(90.0);
            if (!this.debugging) continue;
            System.out.println("suche");
        }
        if (this.debugging) {
            System.out.println("Name: " + this.e_name);
        }
        this.stop();
        try {
            ObjectOutputStream writer = new ObjectOutputStream(new GZIPOutputStream((OutputStream)new RobocodeFileOutputStream(this.getDataFile("lastEnemy.info"))));
            writer.writeObject(this.e_name);
            writer.close();
        }
        catch (Exception e) {
            System.out.println("Kann lastenemy.info nicht anlegen:" + e);
        }
        this.readScores(this.e_name);
        this.operator = this.get1v1Op();
    }

    public void startInitNormal() {
        if (this.getOthers() != 1) {
            this.operator = this.getMeleeOp();
            return;
        }
        try {
            ObjectInputStream reader = new ObjectInputStream(new GZIPInputStream(new FileInputStream(this.getDataFile("lastEnemy.info"))));
            this.e_name = (String)reader.readObject();
            if (this.debugging) {
                System.out.println("Ols enemy:" + this.e_name);
            }
            reader.close();
        }
        catch (Exception e) {
            System.out.println("no lastEnemy.info bot stoppes." + e);
            while (true) {
                this.execute();
            }
        }
        this.readScores(this.e_name);
        this.operator = this.get1v1Op();
    }

    public Operator get1v1Op() {
        this.thisScore = 0.0;
        double DisponserScore = (Double)this.scores.get(1);
        double RiOScore = (Double)this.scores.get(0);
        double AspidLikeScore = (Double)this.scores.get(2);
        double MeleeScore = (Double)this.scores.get(6);
        double MirrorScore = (Double)this.scores.get(3);
        double RedRoseScore = (Double)this.scores.get(5);
        double RandomScore = (Double)this.scores.get(4);
        if (this.debugging) {
            System.out.println("RiOScore:" + (int)RiOScore + " DisponserScore:" + (int)DisponserScore + " AspidLike:" + (int)AspidLikeScore + " MirrorScore:" + (int)MirrorScore + " RandomScore:" + (int)RandomScore + "RedRose:" + (int)RedRoseScore + " MeleeScore:" + (int)MeleeScore);
        }
        this.currentOperator = this.getBestOp(new double[]{RiOScore, DisponserScore, AspidLikeScore, MirrorScore, RandomScore, RedRoseScore, MeleeScore});
        switch (this.currentOperator) {
            case 0: {
                return new RiOxS_OP(this, this.dodging, this.firing, this.moving);
            }
            case 1: {
                return new DisponserS_OP(this, this.dodging, this.firing, this.moving);
            }
            case 2: {
                return new AspidLikeS_OP(this, this.dodging, this.firing, this.moving);
            }
            case 3: {
                return new MirrorS_OP(this, this.dodging, this.firing, this.moving);
            }
            case 4: {
                return new RandomS_OP(this, this.dodging, this.firing, this.moving);
            }
            case 5: {
                return new RedRoseS_OP(this, this.dodging, this.firing, this.moving);
            }
            case 6: {
                return new RiOxM_OP(this, this.dodging, this.firing, this.moving);
            }
        }
        System.out.println("unknown operator:" + this.currentOperator);
        return null;
    }

    public int getBestOp(double[] values) {
        int bestScoreIndex = -1;
        double bestScore = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < values.length) {
            if (values[i] > bestScore) {
                bestScoreIndex = i;
                bestScore = values[i];
            }
            ++i;
        }
        return bestScoreIndex;
    }

    public Operator getMeleeOp() {
        this.currentOperator = 6;
        this.operator = new RiOxM_OP(this, this.dodging, this.firing, this.moving);
        return this.operator;
    }

    public void createNewScores() {
        this.scores = new Vector();
        this.scores.add(0, new Double(100.0));
        this.scores.add(1, new Double(0.0));
        this.scores.add(2, new Double(-9999.0));
        this.scores.add(3, new Double(0.0));
        this.scores.add(4, new Double(0.0));
        this.scores.add(5, new Double(0.0));
        this.scores.add(6, new Double(0.0));
    }

    public void readData() {
        try {
            this.behaviorFile = new File(this.getDataDirectory() + "\\" + "my.behavior");
            this.readB = new BufferedReader(new FileReader(this.behaviorFile));
            this.readB.readLine();
            this.readB.readLine();
            String s1 = this.readB.readLine().trim();
            String s2 = this.readB.readLine().trim();
            String s3 = this.readB.readLine().trim();
            if (!s1.equals("true") && !s1.equals("false") || !s2.equals("true") && !s2.equals("false") || !s3.equals("true") && !s3.equals("false")) {
                System.out.println(s1 + "/" + s2 + "/" + s3 + " wrong input creating new file...");
                throw new FileNotFoundException();
            }
            this.dodging = s1.equals("true");
            this.firing = s2.equals("true");
            this.moving = s3.equals("true");
        }
        catch (FileNotFoundException e1) {
            try {
                this.writeB = new PrintWriter((Writer)new RobocodeFileWriter(this.behaviorFile));
                this.writeB.println("### HERE YOU CAN SET MY BEHAVIOR: ###");
                this.writeB.println("### DODGING/FIRING/MOVING:        ###");
                this.writeB.println(this.dodging);
                this.writeB.println(this.firing);
                this.writeB.println(this.moving);
                this.writeB.close();
            }
            catch (Exception e3) {
                System.out.println("e3" + e3);
            }
        }
        catch (Exception e2) {
            System.out.println("e2" + e2);
        }
    }

    public void readScores(String e_name) {
        try {
            ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(new FileInputStream(this.getDataFile(e_name + ".scores"))));
            this.scores = new Vector();
            try {
                while (true) {
                    this.scores.add(new Double(in.readDouble()));
                }
            }
            catch (EOFException eOFException) {
                in.close();
            }
        }
        catch (Exception e) {
            if (e instanceof FileNotFoundException) {
                System.out.println("Noch keine " + e_name + ".scores");
            } else {
                System.out.println("error at:read scores:" + e);
            }
            this.createNewScores();
        }
    }

    public void saveScores(String e_name) {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new GZIPOutputStream((OutputStream)new RobocodeFileOutputStream(this.getDataFile(e_name + ".scores"))));
            Enumeration enumeration = this.scores.elements();
            while (enumeration.hasMoreElements()) {
                out.writeDouble((Double)enumeration.nextElement());
            }
            out.close();
        }
        catch (Exception e) {
            System.out.println("error at:save scores:" + e);
        }
    }

    public void victoryDance() {
        this.setMaxVelocity(50.0);
        boolean canFire = this.getEnergy() > 4.0;
        double middleX = this.getBattleFieldWidth() / 2.0;
        double middleY = this.getBattleFieldHeight() / 2.0;
        Calc.setGoto(this, middleX, middleY);
        this.waitFor((Condition)new MoveCompleteCondition((AdvancedRobot)this));
        this.setTurnRadarRight(Double.POSITIVE_INFINITY);
        double area = Math.min(this.getBattleFieldHeight(), this.getBattleFieldWidth()) / 8.0;
        while (true) {
            Calc.setGotoWin(this, middleX + (Math.random() * (area * 2.0) - area), middleY + (Math.random() * (area * 2.0) - area));
            this.waitFor((Condition)new MoveCompleteCondition((AdvancedRobot)this));
            if (!canFire) continue;
            this.setFire(0.3);
        }
    }

    public void onWin(WinEvent e) {
        this.thisScore += 100.0;
        this.setStop();
        this.end();
        this.operator.onWin(e);
        this.victoryDance();
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.operator.onRobotDeath(e);
    }

    public void onBulletHit(BulletHitEvent e) {
        this.operator.onBulletHit(e);
        this.thisScore += e.getBullet().getPower();
    }

    public void onBulletMissed(BulletMissedEvent e) {
        this.operator.onBulletMissed(e);
        this.thisScore -= e.getBullet().getPower() / 2.0;
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        this.operator.onBulletHitBullet(e);
        this.thisScore += 1.0;
    }

    public void onDeath(DeathEvent e) {
        this.operator.onDeath(e);
        this.thisScore -= 70.0;
        this.end();
    }

    public void onHitWall(HitWallEvent e) {
        this.operator.onHitWall(e);
        this.thisScore -= 5.0;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (this.e_name == null && this.singleMode) {
            if (this.debugging) {
                System.out.println("FoundName:" + e.getName());
            }
            StringTokenizer tempNameTokenizer = new StringTokenizer(e.getName(), "/({[! ");
            this.e_name = tempNameTokenizer.nextToken();
            return;
        }
        if (this.operator != null) {
            this.operator.onScannedRobot(e);
        }
    }

    public void end() {
        if (!this.singleMode) {
            return;
        }
        if (this.debugging) {
            System.out.println(this.currentOperator + " gets: " + this.thisScore);
        }
        this.scores.set(this.currentOperator, new Double((Double)this.scores.get(this.currentOperator) + this.thisScore));
        this.saveScores(this.e_name);
    }
}

