/*
 * Decompiled with CFR 0.152.
 */
package bh.units;

import bh.units.Angle;
import bh.units.Bearing;
import bh.units.interfaces.AbsoluteToRelative;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Heading
implements AbsoluteToRelative<Heading, Bearing> {
    private final Angle angle;

    public Heading(Angle angle) {
        this.angle = angle.normalAbsolute();
    }

    @Override
    public Heading plus(Bearing bearing) {
        return new Heading(this.angle.plus(bearing.toAngle()));
    }

    @Override
    public Heading minus(Bearing bearing) {
        return new Heading(this.angle.minus(bearing.toAngle()));
    }

    @Override
    public Bearing minus(Heading heading) {
        return new Bearing(this.angle.minus(heading.angle));
    }

    public Heading opposite() {
        return new Heading(this.angle.plus(Angle.HALF_CIRCLE));
    }

    public Angle toAngle() {
        return this.angle;
    }

    public Bearing getBearingTo(Heading heading) {
        return new Bearing(heading.angle.minus(this.angle));
    }

    public Bearing getBearingFrom(Heading heading) {
        return heading.getBearingTo(this);
    }

    public String toString() {
        return this.angle.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Heading)) {
            return false;
        }
        Heading heading = (Heading)o;
        return heading.angle.equals(this.angle);
    }

    public int hashCode() {
        return this.angle.hashCode();
    }
}

