/*
 * Decompiled with CFR 0.152.
 */
package bh.units;

import bh.units.Distance;
import bh.units.Heading;
import bh.units.RelativeLocation;
import bh.units.interfaces.AbsoluteToRelative;
import bh.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Location
implements AbsoluteToRelative<Location, RelativeLocation> {
    private final Vector vector;

    public Location(Vector vector) {
        this.vector = vector;
    }

    public Location(Distance x, Distance y) {
        this(new Vector(x, y));
    }

    public Distance getX() {
        return this.vector.getX();
    }

    public Distance getY() {
        return this.vector.getY();
    }

    public Vector toVector() {
        return this.vector;
    }

    @Override
    public Location plus(RelativeLocation rl) {
        return new Location(this.vector.plus(rl.toVector()));
    }

    @Override
    public Location minus(RelativeLocation rl) {
        return new Location(this.vector.plus(rl.toVector().negate()));
    }

    @Override
    public RelativeLocation minus(Location location) {
        return new RelativeLocation(location, this);
    }

    public Distance getDistanceTo(Location l) {
        return new RelativeLocation(this, l).getDistance();
    }

    public Heading getHeadingTo(Location l) {
        return new RelativeLocation(this, l).getHeading();
    }

    public String toString() {
        return this.vector.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Location)) {
            return false;
        }
        Location l = (Location)o;
        return l.vector.equals(this.vector);
    }

    public int hashCode() {
        return this.vector.hashCode();
    }
}

