/*
 * Decompiled with CFR 0.152.
 */
package xander.core.log;

import xander.core.Resources;
import xander.core.log.Logger;

public class Log {
    private String className;
    private Level level;

    public Log(String className) {
        this(className, null);
    }

    public Log(String className, Level level) {
        this.className = className;
        this.level = level;
    }

    public Level getLevel() {
        return this.level;
    }

    public boolean isActiveForLevel(Level level) {
        Level useLevel;
        Level level2 = useLevel = level == null ? Logger.defaultLevel : level;
        return level.getPriority() >= useLevel.getPriority();
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    private void log(String s, Level msgLevel) {
        Level useLevel;
        Level level = useLevel = this.level == null ? Logger.defaultLevel : this.level;
        if (msgLevel.getPriority() >= useLevel.getPriority()) {
            String[] lines = s.split("\n");
            String time = String.valueOf(Resources.getTime());
            int i = 0;
            while (i < lines.length) {
                System.out.println(String.valueOf(this.className) + " [" + time + "] " + msgLevel.getDescription() + ": " + lines[i]);
                ++i;
            }
        }
    }

    public void debug(String s) {
        this.log(s, Level.DEBUG);
    }

    public void info(String s) {
        this.log(s, Level.INFO);
    }

    public void warn(String s) {
        this.log(s, Level.WARN);
    }

    public void stat(String s) {
        this.log(s, Level.STAT);
    }

    public void error(String s) {
        this.log(s, Level.ERROR);
    }

    public static enum Level {
        DEBUG(0, "DEBUG"),
        INFO(1, "INFO"),
        WARN(2, "WARN"),
        STAT(3, "STAT"),
        ERROR(4, "ERROR");

        private int priority;
        private String description;

        private Level(int priority, String description) {
            this.priority = priority;
            this.description = description;
        }

        public int getPriority() {
            return this.priority;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

