/*
 * Decompiled with CFR 0.152.
 */
package xander.core.math;

import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import xander.core.math.LinearEquation;
import xander.core.math.RCPhysics;
import xander.core.math.VelocityVector;
import xander.core.track.Snapshot;
import xander.core.track.Wave;
import xander.gfws.RelativeAngleRange;

public class RCMath {
    private static final double MAX_ESCAPE_ANGLE = Math.toDegrees(Math.asin(8.0 / RCPhysics.MIN_BULLET_VELOCITY));

    public static double normalizeRadians(double radians) {
        double circ = Math.PI * 2;
        while (radians < 0.0) {
            radians += Math.PI * 2;
        }
        while (radians > Math.PI * 2) {
            radians -= Math.PI * 2;
        }
        return radians;
    }

    public static double normalizeDegrees(double degrees) {
        while (degrees < 0.0) {
            degrees += 360.0;
        }
        while (degrees > 360.0) {
            degrees -= 360.0;
        }
        return degrees;
    }

    public static double convertDegrees(double degrees) {
        return RCMath.normalizeDegrees(90.0 - degrees);
    }

    public static double getTurnAngle(double oldHeading, double newHeading) {
        double turnAngle = newHeading - oldHeading;
        if (Math.abs(turnAngle) > 180.0) {
            turnAngle = turnAngle > 0.0 ? (turnAngle -= 360.0) : (turnAngle += 360.0);
        }
        return turnAngle;
    }

    public static double convertRadiansRobocodeToNormal(double roboRadians) {
        return RCMath.normalizeRadians(1.5707963267948966 - roboRadians);
    }

    public static double getDistanceBetweenPoints(Point2D.Double p1, Point2D.Double p2) {
        return RCMath.getDistanceBetweenPoints(p1.x, p1.y, p2.x, p2.y);
    }

    public static double getDistanceBetweenPoints(double x1, double y1, double x2, double y2) {
        double xd = x2 - x1;
        double yd = y2 - y1;
        return Math.sqrt(xd * xd + yd * yd);
    }

    public static Point2D.Double getRobotPosition(double bearingRadians, double distance, double myX, double myY, double myHeadingInRadians) {
        double fixedBearing = bearingRadians + myHeadingInRadians;
        double s_ex = distance * Math.sin(fixedBearing) + myX;
        double s_ey = distance * Math.cos(fixedBearing) + myY;
        return new Point2D.Double(s_ex, s_ey);
    }

    public static boolean differenceLessThan(double a, double b, double m) {
        return Math.abs(a - b) < m;
    }

    public static boolean differenceLessThanPercent(double a, double b, double percent) {
        return a == 0.0 && b == 0.0 || Math.abs((a - b) / Math.max(Math.abs(a), Math.abs(b))) < percent;
    }

    public static Point2D.Double getLocation(double x, double y, double travelDistance, double headingRoboDegrees) {
        double pheta = Math.toRadians(RCMath.convertDegrees(headingRoboDegrees));
        Point2D.Double location = new Point2D.Double();
        location.x = x + travelDistance * Math.cos(pheta);
        location.y = y + travelDistance * Math.sin(pheta);
        return location;
    }

    public static double getMaximumEscapeAngle(double bulletVelocity) {
        return Math.toDegrees(Math.asin(8.0 / bulletVelocity));
    }

    public static double getMEASignificance(Wave wave) {
        return RCMath.getMEASignificance(wave.getInitialMEA(), wave.getOriginDistance());
    }

    public static double getMEASignificance(RelativeAngleRange MEA, double distance) {
        double robotWidthDegrees = 7200.0 / (Math.PI * distance);
        double sArc = RCMath.limit(Math.abs(MEA.getArc()) - robotWidthDegrees, 0.0, MAX_ESCAPE_ANGLE);
        return 1.0 - sArc / MAX_ESCAPE_ANGLE;
    }

    public static double getRobocodeAngle(Snapshot fromRobot, Snapshot toRobot) {
        return RCMath.getRobocodeAngle(fromRobot.getX(), fromRobot.getY(), toRobot.getX(), toRobot.getY());
    }

    public static double getRobocodeAngle(double x, double y) {
        double angle;
        double d = angle = x == 0.0 ? 90.0 : Math.abs(Math.atan(y / x)) * 57.29577951308232;
        angle = x >= 0.0 ? (y > 0.0 ? 90.0 - angle : (angle += 90.0)) : (y > 0.0 ? (angle += 270.0) : 270.0 - angle);
        return angle;
    }

    public static double getRobocodeAngle(Point2D.Double fromPoint, Point2D.Double toPoint) {
        return RCMath.getRobocodeAngle(fromPoint.x, fromPoint.y, toPoint.x, toPoint.y);
    }

    public static double getRobocodeAngle(double fromX, double fromY, double toX, double toY) {
        return RCMath.getRobocodeAngle(toX - fromX, toY - fromY);
    }

    public static double getRobocodeAngleToCenter(double x, double y, Rectangle2D.Double bb) {
        return RCMath.getRobocodeAngle(x, y, bb.getCenterX(), bb.getCenterY());
    }

    public static double limit(double value, double min, double max) {
        if (value < min || value > max) {
            return value < min ? min : max;
        }
        return value;
    }

    public static boolean between(double value, double end1, double end2) {
        if (end1 > end2) {
            return value >= end2 && value <= end1;
        }
        return value >= end1 && value <= end2;
    }

    public static Rectangle2D.Double shrink(Rectangle2D.Double source, double shrinkSidesBy) {
        return new Rectangle2D.Double(source.x + shrinkSidesBy, source.y + shrinkSidesBy, source.width - shrinkSidesBy * 2.0, source.height - shrinkSidesBy * 2.0);
    }

    public static double getDistanceToIntersect(double x, double y, double headingRoboDegrees, Rectangle2D.Double box) {
        VelocityVector vv = new VelocityVector(headingRoboDegrees, 1.0);
        double endX = vv.getX() > 0.0 ? box.getMaxX() : box.getMinX();
        double endY = vv.getY() > 0.0 ? box.getMaxY() : box.getMinY();
        double timeToX = (endX - x) / vv.getX();
        double timeToY = (endY - y) / vv.getY();
        double timeToIntercept = Math.min(timeToX, timeToY);
        double x_i = x + timeToIntercept * vv.getX();
        double y_i = y + timeToIntercept * vv.getY();
        return RCMath.getDistanceBetweenPoints(x, y, x_i, y_i);
    }

    public static Arc2D.Double getYAxisInvertedArc(double x, double y, double w, double h, double start, double extent, int type) {
        return new Arc2D.Double(x, y, w, h, RCMath.normalizeDegrees(-start), -extent, type);
    }

    public static double getBackAsFrontHeading(Snapshot snapshot) {
        double bafHeading = snapshot.getHeadingRoboDegrees();
        if (snapshot.getVelocity() < 0.0) {
            bafHeading = RCMath.normalizeDegrees(bafHeading + 180.0);
        }
        return bafHeading;
    }

    public static List<int[]> getKPermutations(int[] S, int k) {
        if (k == 0) {
            ArrayList<int[]> kperms = new ArrayList<int[]>();
            kperms.add(new int[0]);
            return kperms;
        }
        ArrayList<int[]> kperms = new ArrayList<int[]>();
        int[] nS = new int[S.length - 1];
        int i = 0;
        while (i < S.length) {
            if (i > 0) {
                System.arraycopy(S, 0, nS, 0, i);
            }
            if (i < S.length - 1) {
                System.arraycopy(S, i + 1, nS, i, S.length - i - 1);
            }
            for (int[] p : RCMath.getKPermutations(nS, k - 1)) {
                int[] np = new int[p.length + 1];
                System.arraycopy(p, 0, np, 0, p.length);
                np[p.length] = S[i];
                kperms.add(np);
            }
            ++i;
        }
        return kperms;
    }

    public static List<int[]> getKCombinations(int[] S, int k) {
        List<int[]> kperms = RCMath.getKPermutations(S, k);
        Iterator<int[]> iter = kperms.iterator();
        while (iter.hasNext()) {
            int[] perm = iter.next();
            boolean ordered = true;
            int i = 1;
            while (i < perm.length) {
                if (perm[i] < perm[i - 1]) {
                    ordered = false;
                }
                ++i;
            }
            if (ordered) continue;
            iter.remove();
        }
        return kperms;
    }

    public static List<int[]> getAllKCombinations(int[] S) {
        ArrayList<int[]> allKPerms = new ArrayList<int[]>();
        int k = 1;
        while (k <= S.length) {
            allKPerms.addAll(RCMath.getKCombinations(S, k));
            ++k;
        }
        return allKPerms;
    }

    public static double getStandardDeviation(double[] array) {
        return RCMath.getStandardDeviation(array, 0, array.length - 1);
    }

    public static double getStandardDeviation(double[] array, int beginIndex, int endIndex) {
        double sum = 0.0;
        int i = beginIndex;
        while (i <= endIndex) {
            sum += array[i];
            ++i;
        }
        if (sum == 0.0) {
            return 0.0;
        }
        double avg = sum / (double)(endIndex - beginIndex + 1);
        sum = 0.0;
        int i2 = beginIndex;
        while (i2 <= endIndex) {
            double diff = avg - array[i2];
            sum += diff * diff;
            ++i2;
        }
        return Math.sqrt(sum / avg);
    }

    public static Point2D.Double[] getCircleToLineIntersections(Point2D.Double circleCenter, double circleRadius, Point2D.Double linePoint1, Point2D.Double linePoint2) {
        LinearEquation le = new LinearEquation(linePoint1.x, linePoint1.y, linePoint2.x, linePoint2.y);
        LinearEquation perpLe = le.getPerpendicularThroughPoint(circleCenter.x, circleCenter.y);
        double[] perpLeIntersect = LinearEquation.getIntersection(le, perpLe);
        double checkDist = RCMath.getDistanceBetweenPoints(circleCenter.x, circleCenter.y, perpLeIntersect[0], perpLeIntersect[1]);
        if (checkDist > circleRadius) {
            return null;
        }
        if (checkDist == circleRadius) {
            return new Point2D.Double[]{new Point2D.Double(perpLeIntersect[0], perpLeIntersect[1])};
        }
        Point2D.Double[] intersections = new Point2D.Double[2];
        if (le.getSlope() == null) {
            double x = linePoint1.x - circleCenter.x;
            double y = Math.sqrt(circleRadius * circleRadius - x * x);
            intersections[0] = new Point2D.Double(x + circleCenter.x, y + circleCenter.y);
            intersections[1] = new Point2D.Double(x + circleCenter.x, -y + circleCenter.y);
        } else {
            double m = le.getSlope();
            double sx = linePoint1.x - circleCenter.x;
            double sy = linePoint1.y - circleCenter.y;
            double h = sy - m * sx;
            double a = 1.0 + m * m;
            double b = 2.0 * m * h;
            double c = h * h - circleRadius * circleRadius;
            double S = Math.sqrt(b * b - 4.0 * a * c);
            double x0 = (-b + S) / (2.0 * a);
            double x1 = (-b - S) / (2.0 * a);
            double y0 = m * x0 + h;
            double y1 = m * x1 + h;
            intersections[0] = new Point2D.Double(x0 + circleCenter.x, y0 + circleCenter.y);
            intersections[1] = new Point2D.Double(x1 + circleCenter.x, y1 + circleCenter.y);
        }
        return intersections;
    }

    public static int parseInt(String intValueAsString, int defaultValue) {
        try {
            return Integer.parseInt(intValueAsString);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

