/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import java.text.NumberFormat;
import shrub.Bearing;
import shrub.Heading;
import shrub.Location;
import shrub.QuadrantAdjust;
import shrub.ShrubMath;

public class Line {
    private final Location mStartLocn;
    private final Location mEndLocn;
    private final Heading mHeading;
    private final double mLength;
    private boolean mIsEquationSet = false;
    private double mGradient = 0.0;
    private double mOffsetY = 0.0;
    private static final NumberFormat dp2 = NumberFormat.getInstance();

    private Line(Location start, Location end, Heading hdng, double length) {
        this.mStartLocn = start;
        this.mEndLocn = end;
        this.mHeading = hdng;
        this.mLength = length;
    }

    public static Line valueOfStartEnd(Location start, Location end) {
        Heading hdng = Heading.valueOfFromTo(start, end);
        double length = start.DistanceTo(end);
        Line answer = new Line(start, end, hdng, length);
        return answer;
    }

    public static Line valueOfStartHdng(Location start, Heading hdng) {
        Location end = null;
        double length = 0.0;
        Line answer = new Line(start, end, hdng, length);
        return answer;
    }

    public static Line valueOfStartHdngLength(Location start, Heading hdng, double length) {
        Location end = Location.valueOfRelative(start, hdng, length);
        Line answer = new Line(start, end, hdng, length);
        return answer;
    }

    public final Location GetStartLocn() {
        return this.mStartLocn;
    }

    public final Heading GetHeading() {
        return this.mHeading;
    }

    public final double GetGradient() {
        if (!this.mIsEquationSet) {
            this.CalcEquation();
        }
        return this.mGradient;
    }

    public final double GetOffsetY() {
        if (!this.mIsEquationSet) {
            this.CalcEquation();
        }
        return this.mOffsetY;
    }

    private final boolean CalcEquation() {
        if (!this.mIsEquationSet) {
            Bearing brng = this.mHeading.toBearing();
            if (brng.IsAligned() || brng.IsOpposed()) {
                this.mGradient = 9999.0;
            } else if (brng.IsLeft90() || brng.IsRight90()) {
                this.mGradient = 0.0;
            } else {
                QuadrantAdjust qAdj = QuadrantAdjust.valueOf(this.mHeading.Get());
                int adjSenseX = qAdj.GetAdjSenseX();
                int adjSenseY = qAdj.GetAdjSenseY();
                double adjThetaDegY = qAdj.GetAdjThetaDegY();
                double adjThetaDegX = 90.0 - adjThetaDegY;
                double absGradient = ShrubMath.Tan(adjThetaDegX);
                this.mGradient = adjSenseX == adjSenseY ? absGradient : -absGradient;
            }
            this.mOffsetY = this.mStartLocn.GetY() - this.mStartLocn.GetX() * this.mGradient;
            this.mIsEquationSet = true;
        } else {
            System.out.println("ERROR: Line::CalcEquation(), already calc'ed");
        }
        return this.mIsEquationSet;
    }

    public final Line PerpendicularLine(Location otherLocn) {
        Heading perpHdng = Heading.valueOfAdjust(this.mHeading, 90.0);
        Line perpLine = Line.valueOfStartHdng(otherLocn, perpHdng);
        return perpLine;
    }

    public final Location IntersectionLocn(Line otherLine) {
        double intX = 0.0;
        double intY = 0.0;
        double offsetY1 = this.GetOffsetY();
        double offsetY2 = otherLine.GetOffsetY();
        double gradient1 = this.GetGradient();
        double gradient2 = otherLine.GetGradient();
        intX = (offsetY1 - offsetY2) / (gradient2 - gradient1);
        intY = gradient1 * intX + offsetY1;
        Location intLocn = Location.valueOf(intX, intY);
        return intLocn;
    }

    public void Print() {
        System.out.println("===== Line =====");
        if (this.mStartLocn != null) {
            System.out.print(" StartLocn: " + this.mStartLocn.toString());
        }
        if (this.mEndLocn != null) {
            System.out.print(" EndLocn: " + this.mEndLocn.toString());
        }
        System.out.println();
        if (this.mHeading != null) {
            System.out.print(" Hdng: " + this.mHeading.toString());
        }
        if (this.mLength != 0.0) {
            System.out.print(" Length: " + dp2.format(this.mLength));
        }
        System.out.println();
        if (this.mIsEquationSet) {
            System.out.print(" Gradient: " + dp2.format(this.mGradient));
            System.out.print(" OffsetY: " + dp2.format(this.mOffsetY));
            System.out.println();
        }
    }

    static {
        dp2.setMaximumFractionDigits(2);
        dp2.setMinimumFractionDigits(2);
    }
}

