/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import java.text.NumberFormat;
import java.util.Vector;
import shrub.Box;
import shrub.Heading;
import shrub.Location;
import shrub.Sighting;
import shrub.TrackerAPI;

public class Navigator {
    private TrackerAPI mTrackerRef = null;
    private Box mArena = null;
    private double mWallAvoidDistance = 100.0;
    private Box mAllowedArea = null;
    private double mStepLength = 100.0;
    private double mStepLengthVar = 0.0;
    private int mNumPaths = 16;
    private double mPathHdngBase = 0.0;
    private double mPathHdngVar = 0.0;
    private double mEvalPowerLaw = 1.0;
    private static final NumberFormat dp2 = NumberFormat.getInstance();
    private static Navigator THE_INSTANCE = new Navigator();

    public static Navigator getInstance() {
        return THE_INSTANCE;
    }

    private Navigator() {
    }

    public void SetTrackerRef(TrackerAPI trackerRef) {
        this.mTrackerRef = trackerRef;
    }

    public void SetArena(Box arena) {
        this.mArena = arena;
    }

    public void SetWallAvoidDistance(double newValue) {
        this.mWallAvoidDistance = newValue;
        double minX = this.mArena.GetMinX() + this.mWallAvoidDistance;
        double minY = this.mArena.GetMinY() + this.mWallAvoidDistance;
        double maxX = this.mArena.GetMaxX() - this.mWallAvoidDistance;
        double maxY = this.mArena.GetMaxY() - this.mWallAvoidDistance;
        Location corner1 = Location.valueOf(minX, minY);
        Location corner2 = Location.valueOf(maxX, maxY);
        this.mAllowedArea = Box.valueOf(corner1, corner2);
    }

    public void SetStepLength(double newValue) {
        this.mStepLength = newValue;
    }

    public void SetStepLengthVar(double newValue) {
        this.mStepLengthVar = newValue;
    }

    public void SetNumPaths(int newValue) {
        this.mNumPaths = newValue;
    }

    public void SetPathHdngBase(double newValue) {
        this.mPathHdngBase = newValue;
    }

    public void SetPathHdngVar(double newValue) {
        this.mPathHdngVar = newValue;
    }

    public void SetEvalPowerLaw(double newValue) {
        this.mEvalPowerLaw = newValue;
    }

    public final Location RandomWaypointAbs() {
        double maxX = this.mAllowedArea.GetMaxX();
        double maxY = this.mAllowedArea.GetMaxY();
        double minX = this.mAllowedArea.GetMinX();
        double minY = this.mAllowedArea.GetMinY();
        double deltaX = maxX - minX;
        double deltaY = maxY - minY;
        double randomX = minX + Math.random() * deltaX;
        double randomY = minY + Math.random() * deltaY;
        Location answer = Location.valueOf(randomX, randomY);
        return answer;
    }

    public final Location RandomWaypointRel(Location sourceLocn) {
        Location answer = Location.ZERO_ZERO;
        boolean done = false;
        int numAttempts = 0;
        if (this.mNumPaths <= 0 || this.mStepLength < 1.0) {
            System.out.println("ERROR: Navigator.RandomWaypointRel(), input error " + this.mNumPaths + "/" + this.mStepLength);
        } else {
            while (!done) {
                int randomIndex;
                double tempHdng;
                Heading adjPathHdng;
                Location pathEnd;
                ++numAttempts;
                double adjPathLength = this.mStepLength;
                if (this.mStepLengthVar > 0.5) {
                    adjPathLength = this.mStepLength - this.mStepLengthVar + 2.0 * Math.random() * this.mStepLengthVar;
                }
                double hdngOffset = 0.0;
                if (this.mPathHdngVar > 0.5) {
                    hdngOffset = 2.0 * Math.random() * this.mPathHdngVar - this.mPathHdngVar;
                }
                if (this.mAllowedArea.IsInside(pathEnd = Location.valueOfRelative(sourceLocn, adjPathHdng = Heading.valueOf((tempHdng = 360.0 * (double)(randomIndex = (int)(Math.random() * (double)this.mNumPaths)) / (double)this.mNumPaths + this.mPathHdngBase) + hdngOffset), adjPathLength))) {
                    done = true;
                    answer = pathEnd;
                    continue;
                }
                if (numAttempts <= 20) continue;
                System.out.println("RelWp, too many attempts, aborting!");
                done = true;
                answer = this.RandomWaypointAbs();
            }
        }
        return answer;
    }

    public Location QuantumGravWaypoint(Location sourceLocn) {
        Location answer = Location.ZERO_ZERO;
        int pathIndex = 0;
        Vector<Location> locnArray = new Vector<Location>();
        if (this.mNumPaths <= 0 || this.mStepLength < 1.0) {
            System.out.println("ERROR: Navigator.QuantumGravWaypoint, input error " + this.mNumPaths + "/" + this.mStepLength);
        } else {
            double adjPathLength = this.mStepLength;
            double hdngOffset = 0.0;
            if (this.mStepLengthVar > 0.5) {
                adjPathLength = this.mStepLength - this.mStepLengthVar + 2.0 * Math.random() * this.mStepLengthVar;
            }
            if (this.mPathHdngVar > 0.5) {
                hdngOffset = 2.0 * Math.random() * this.mPathHdngVar - this.mPathHdngVar;
            }
            double adjustStep = 360 / this.mNumPaths;
            Heading pathHdng = Heading.valueOf(this.mPathHdngBase);
            for (pathIndex = 0; pathIndex < this.mNumPaths; ++pathIndex) {
                Heading adjPathHdng = Heading.valueOfAdjust(pathHdng, hdngOffset);
                Location pathEnd = Location.valueOfRelative(sourceLocn, adjPathHdng, adjPathLength);
                if (this.mAllowedArea.IsInside(pathEnd)) {
                    locnArray.add(pathEnd);
                }
                pathHdng = Heading.valueOfAdjust(pathHdng, adjustStep);
            }
            answer = this.EvaluatePaths(locnArray);
            if (answer == Location.ZERO_ZERO) {
                int numValidPaths = locnArray.size();
                if (numValidPaths <= 0) {
                    System.out.println("ERROR - valid paths array empty");
                } else {
                    int randomIndex = (int)(Math.random() * (double)numValidPaths);
                    answer = (Location)locnArray.get(randomIndex);
                }
            }
        }
        return answer;
    }

    private final Location EvaluatePaths(Vector locnArray) {
        Location bestAnswer = Location.ZERO_ZERO;
        double biggestEvalSoFar = 0.0;
        int numLocns = 0;
        int numTargets = 0;
        numTargets = this.mTrackerRef.GetNumTargets();
        numLocns = locnArray.size();
        if (numTargets > 0) {
            if (numLocns <= 0) {
                System.out.println("ERROR: Navigator.EvaluatePaths() - none!");
            } else {
                for (int locnIndex = 0; locnIndex < numLocns; ++locnIndex) {
                    Location thisLocn = (Location)locnArray.get(locnIndex);
                    double thisEval = this.EvalDistanceFunc(thisLocn, this.mEvalPowerLaw);
                    if (!(thisEval > biggestEvalSoFar)) continue;
                    biggestEvalSoFar = thisEval;
                    bestAnswer = thisLocn;
                }
            }
        }
        return bestAnswer;
    }

    private double EvalDistanceFunc(Location refLocn, double powerLaw) {
        double thisEval = 0.0;
        double sumEval = 0.0;
        int thisIndex = 0;
        int numTargets = 0;
        sumEval = 0.0;
        numTargets = this.mTrackerRef.GetNumTargets();
        for (thisIndex = 0; thisIndex < numTargets; ++thisIndex) {
            Sighting thisTarget = this.mTrackerRef.GetTargetByIndex(thisIndex);
            Location thisLocn = thisTarget.GetLocation();
            double thisDist = thisLocn.DistanceTo(refLocn);
            thisEval = Math.pow(thisDist, powerLaw);
            sumEval += thisEval;
        }
        return sumEval;
    }

    static {
        dp2.setMaximumFractionDigits(2);
        dp2.setMinimumFractionDigits(2);
    }
}

