/*
 * Decompiled with CFR 0.152.
 */
package morbid;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import morbid.BasicRandomMotionStrategy;
import morbid.BrokeredObject;
import morbid.EnemyFireDetectedEvent;
import morbid.IBulletObject;
import morbid.IEnemyBulletManager;
import morbid.IPotentialManager;
import morbid.IRobotController;
import morbid.IRobotPositionManager;
import morbid.Utils;
import robocode.Event;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;

class BulletDodgingMotionStrategy2
extends BasicRandomMotionStrategy {
    private final int m_eventCutoffAge;
    private final int m_maxGunCooloffTime;
    private final int m_strategyLifetime;
    private long m_lastEnemyFireTime;
    private final Set m_permanentForcePoints;
    private final List m_enemyFireEvents;
    private final double m_bulletScale;
    private final double m_enemyScale;
    private final double m_obstacleScale;
    private final double m_perimeterScale;
    private static final Class[] ACCEPTABLE_EVENTS = new Class[]{class$morbid$EnemyFireDetectedEvent == null ? (class$morbid$EnemyFireDetectedEvent = BulletDodgingMotionStrategy2.class$("morbid.EnemyFireDetectedEvent")) : class$morbid$EnemyFireDetectedEvent};
    private static final boolean DO_ENEMY_FORCE_POINT = true;
    private static final boolean DO_DIRECT_BULLET_FORCE_POINT = true;
    private static final boolean DO_MOTION_NOISE = true;
    private static final boolean DEBUG = false;
    static /* synthetic */ Class class$morbid$EnemyFireDetectedEvent;

    public BulletDodgingMotionStrategy2(IRobotController controller) {
        super(controller);
        double maxGunHeat = Utils.bulletPowerToGunHeat(3.0);
        this.m_maxGunCooloffTime = (int)Math.ceil(maxGunHeat / this.m_robot.getGunCoolingRate());
        this.m_strategyLifetime = 10 + this.m_maxGunCooloffTime;
        double diagonal = Utils.relativeDistance(0.0, 0.0, this.m_field_width, this.m_field_height);
        this.m_eventCutoffAge = (int)(diagonal / Utils.bulletPowerToVelocity(3.0));
        this.m_bulletScale = 1.0;
        this.m_enemyScale = -this.m_bulletScale;
        this.m_obstacleScale = 2.0 * this.m_bulletScale;
        this.m_perimeterScale = this.m_obstacleScale * 0.08 * 32.0 * this.m_size * this.m_size * this.m_size / ((diagonal - 4.0 * this.m_size) * (diagonal - 4.0 * this.m_size));
        this.m_permanentForcePoints = new HashSet();
        this.m_enemyFireEvents = new ArrayList();
    }

    public Class[] getAcceptableEventTypes() {
        return BrokeredObject.mergeTypeArrays(super.getAcceptableEventTypes(), ACCEPTABLE_EVENTS);
    }

    public void acceptEvent(Event event) {
        if (event instanceof EnemyFireDetectedEvent) {
            this.m_enemyFireEvents.add(event);
            this.m_lastEnemyFireTime = this.m_robot.getTime();
        } else {
            super.acceptEvent(event);
        }
    }

    protected void activate() {
        super.activate();
        IPotentialManager potentialManager = this.m_controller.getPotentialManager();
        if (this.m_permanentForcePoints.isEmpty()) {
            this.m_permanentForcePoints.add(new IPotentialManager.PermanentForceLine3(this.m_perimeterScale, this.m_size, this.m_field_width / 2.0, 0.0, 0.0));
            this.m_permanentForcePoints.add(new IPotentialManager.PermanentForceLine3(this.m_perimeterScale, this.m_size, this.m_field_width / 2.0, this.m_field_height, Math.PI));
            this.m_permanentForcePoints.add(new IPotentialManager.PermanentForceLine3(this.m_perimeterScale, this.m_size, 0.0, this.m_field_height / 2.0, 1.5707963267948966));
            this.m_permanentForcePoints.add(new IPotentialManager.PermanentForceLine3(this.m_perimeterScale, this.m_size, this.m_field_width, this.m_field_height / 2.0, 4.71238898038469));
            this.m_permanentForcePoints.add(new IPotentialManager.PermanentForceLine3(this.m_perimeterScale, this.m_size, 0.0, 0.0, 0.7853981633974483));
            this.m_permanentForcePoints.add(new IPotentialManager.PermanentForceLine3(this.m_perimeterScale, this.m_size, this.m_field_width, this.m_field_height, 3.9269908169872414));
            this.m_permanentForcePoints.add(new IPotentialManager.PermanentForceLine3(this.m_perimeterScale, this.m_size, 0.0, this.m_field_height, 2.356194490192345));
            this.m_permanentForcePoints.add(new IPotentialManager.PermanentForceLine3(this.m_perimeterScale, this.m_size, this.m_field_width, 0.0, 5.497787143782138));
        }
        Iterator i = this.m_permanentForcePoints.iterator();
        while (i.hasNext()) {
            potentialManager.addForcePoint((IPotentialManager.IForcePoint)i.next());
        }
        this.m_controller.getMotionManager().setNoiseLevel(12, 7.0, 4, Utils.degreesToRadians(40.0));
    }

    protected void passivate() {
        this.m_controller.getMotionManager().setNoiseLevel(-1, Double.MAX_VALUE, -1, 0.0);
        IPotentialManager potentialManager = this.m_controller.getPotentialManager();
        Iterator i = this.m_permanentForcePoints.iterator();
        while (i.hasNext()) {
            potentialManager.removeForcePoint(((IPotentialManager.IForcePoint)i.next()).getID());
        }
        super.passivate();
    }

    protected double bid() {
        long activeTime = this.m_robot.getTime() - this.m_lastEnemyFireTime;
        long activeBid = this.isActive() && activeTime < (long)this.m_strategyLifetime ? (long)this.m_strategyLifetime - activeTime : 0L;
        return this.m_controller.getRobotPositionManager().getKnownAliveObjectCount() <= 2 && !this.m_enemyFireEvents.isEmpty() ? (double)(activeBid + 1L + (long)this.m_enemyFireEvents.size()) : (double)(activeBid - 1L);
    }

    protected boolean handleObstacleEvents(double[] out) {
        if (!this.m_obstacleEvents.isEmpty()) {
            this.m_robotIDs.clear();
            this.m_collisionHeadings.clear();
            int e = this.m_obstacleEvents.size() - 1;
            while (e >= 0) {
                HitRobotEvent event;
                Event _event = (Event)this.m_obstacleEvents.get(e);
                if (_event instanceof HitRobotEvent) {
                    event = (HitRobotEvent)_event;
                    if (!this.m_robotIDs.contains(event.getName())) {
                        this.m_robotIDs.add(event.getName());
                        this.m_collisionHeadings.add(new Double(event.getBearingRadians()));
                    }
                } else if (_event instanceof HitWallEvent) {
                    event = (HitWallEvent)_event;
                    this.m_collisionHeadings.add(new Double(event.getBearingRadians()));
                }
                --e;
            }
            double netHeadingX = 0.0;
            double netHeadingY = 0.0;
            int h = 0;
            int hSize = this.m_collisionHeadings.size();
            while (h < hSize) {
                double heading = (Double)this.m_collisionHeadings.get(h) + this.m_robot.getHeadingRadians();
                netHeadingX += Math.sin(heading);
                netHeadingY += Math.cos(heading);
                ++h;
            }
            double netHeading = Utils.reversePhi(Utils.relativeHeading(0.0, 0.0, netHeadingX, netHeadingY));
            this.m_controller.getPotentialManager().addForcePoint(new IPotentialManager.TimedForceLine(this.m_controller, this.m_obstacleScale, this.m_size, this.m_robot.getX() + 10.0 * Math.sin(netHeading += 0.15 * (0.5 - this.m_random.nextDouble())), this.m_robot.getY() + 10.0 * Math.cos(netHeading), netHeading, 6L));
            double shift = this.m_size;
            out[0] = this.m_robot.getX() + shift * Math.sin(netHeading);
            out[1] = this.m_robot.getY() + shift * Math.cos(netHeading);
            this.clearEvents();
            return true;
        }
        return false;
    }

    protected void computeNextGoTo(double[] out) {
        double[] f;
        double abs_f;
        IPotentialManager potentialManager = this.m_controller.getPotentialManager();
        IRobotPositionManager robotPositionManager = this.m_controller.getRobotPositionManager();
        long time = this.m_robot.getTime();
        IRobotPositionManager.ITrackedRobot[] enemies = robotPositionManager.getKnownAliveObjects();
        int e = 0;
        while (e < enemies.length) {
            if (potentialManager.getForcePoint(enemies[e].getID()) == null) {
                IPotentialManager.EnemyForcePoint enemyForcePoint = new IPotentialManager.EnemyForcePoint(this.m_controller, this.m_enemyScale, this.m_size, enemies[e]);
                this.m_permanentForcePoints.add(enemyForcePoint);
                potentialManager.addForcePoint(enemyForcePoint);
            }
            ++e;
        }
        if (!this.m_enemyFireEvents.isEmpty()) {
            EnemyFireDetectedEvent lastFireEvent = (EnemyFireDetectedEvent)((Object)this.m_enemyFireEvents.get(this.m_enemyFireEvents.size() - 1));
            long fireTime = lastFireEvent.getFireFact().getFireTime();
            double bulletPower = lastFireEvent.getFireFact().getBullet().getPower();
            long nextNoisePoint = fireTime + (long)Utils.bulletPowerToGunCoolTime(bulletPower, this.m_robot.getGunCoolingRate()) - 2L;
            this.m_controller.getMotionManager().setNextNoisePoint(nextNoisePoint);
            IEnemyBulletManager enemyBulletManager = this.m_controller.getEnemyBulletManager();
            int e2 = this.m_enemyFireEvents.size() - 1;
            while (e2 >= 0) {
                EnemyFireDetectedEvent event = (EnemyFireDetectedEvent)((Object)this.m_enemyFireEvents.remove(e2));
                if (time - event.getTime() <= (long)this.m_eventCutoffAge) {
                    IBulletObject.IBullet bullet = event.getFireFact().getBullet();
                    double bulletScale = this.m_bulletScale * bullet.getPower() / 3.0;
                    potentialManager.addForcePoint(new IPotentialManager.EnemyBulletForceLine(this.m_controller, bulletScale, this.m_size, bullet));
                    double bulletHeading = Utils.relativeHeading(bullet.getXY(), this.m_robot.getX(), this.m_robot.getY());
                    IBulletObject.IBullet bullet2 = enemyBulletManager.addBullet(bullet.getSourceID(), this.m_robot.getName(), event.getFireFact().getFireTime(), bullet.getX(), bullet.getY(), bulletHeading, bullet.getPower(), null);
                    potentialManager.addForcePoint(new IPotentialManager.EnemyBulletForceLine(this.m_controller, bulletScale, this.m_size, bullet2));
                }
                --e2;
            }
        }
        if ((abs_f = Utils.relativeDistance(f = potentialManager.getTotalActiveForce(this.m_robot.getX(), this.m_robot.getY()), 0.0, 0.0)) < 100.0) {
            super.computeNextGoTo(out);
        } else {
            double jump = 2.0 * this.m_size;
            out[0] = this.m_robot.getX() + f[0] * jump / abs_f;
            out[1] = this.m_robot.getY() + f[1] * jump / abs_f;
            super.avoidWalls(out);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

