/*
 * Decompiled with CFR 0.152.
 */
package morbid;

import morbid.Utils;

interface IObject {

    public static abstract class DNamedMovingObject
    implements INamedMovingObject {
        private final INamedMovingObject m_delegate;

        public final double getX() {
            return this.m_delegate.getX();
        }

        public final double getY() {
            return this.m_delegate.getY();
        }

        public final double[] getXY() {
            return this.m_delegate.getXY();
        }

        public final double getHeadingRadians() {
            return this.m_delegate.getHeadingRadians();
        }

        public final double getVelocity() {
            return this.m_delegate.getVelocity();
        }

        public final String getID() {
            return this.m_delegate.getID();
        }

        public String toString() {
            return this.m_delegate.toString();
        }

        protected DNamedMovingObject(INamedMovingObject delegate) {
            this.m_delegate = delegate;
        }
    }

    public static abstract class NamedMovingObject
    extends MovingObject
    implements INamedMovingObject {
        private final String m_ID;

        public final String getID() {
            return this.m_ID;
        }

        public String toString() {
            StringBuffer s = new StringBuffer(0);
            s.append('{');
            s.append(this.m_ID);
            s.append(": ");
            s.append(Utils.printDouble(this.getX()));
            s.append('/');
            s.append(Utils.printDouble(this.getY()));
            s.append(", H ");
            s.append(Utils.printPhi(this.getHeadingRadians()));
            s.append(", V ");
            s.append(Utils.printDouble(this.getVelocity()));
            s.append('}');
            return s.toString();
        }

        protected NamedMovingObject(String ID, double x, double y, double heading, double velocity) {
            super(x, y, heading, velocity);
            this.m_ID = ID;
        }

        protected NamedMovingObject(String ID, double[] xy, double heading, double velocity) {
            super(xy, heading, velocity);
            this.m_ID = ID;
        }
    }

    public static abstract class NamedXYObject
    extends XYObject
    implements INamedObject {
        private final String m_ID;

        public final String getID() {
            return this.m_ID;
        }

        public String toString() {
            StringBuffer s = new StringBuffer(0);
            s.append('{');
            s.append(this.m_ID);
            s.append(": ");
            s.append(Utils.printDouble(this.getX()));
            s.append('/');
            s.append(Utils.printDouble(this.getY()));
            s.append('}');
            return s.toString();
        }

        protected NamedXYObject(String ID, double x, double y) {
            super(x, y);
            this.m_ID = ID;
        }

        protected NamedXYObject(String ID, double[] xy) {
            super(xy);
            this.m_ID = ID;
        }
    }

    public static abstract class MovingObject
    extends XYObject
    implements IMovingObject {
        private double m_heading;
        private double m_velocity;

        public final double getHeadingRadians() {
            return this.m_heading;
        }

        public final double getVelocity() {
            return this.m_velocity;
        }

        public final void setHeadingRadians(double heading) {
            this.m_heading = heading;
        }

        public final void setVelocity(double velocity) {
            this.m_velocity = velocity;
        }

        protected MovingObject(double x, double y, double heading, double velocity) {
            super(x, y);
            this.m_heading = heading;
            this.m_velocity = velocity;
        }

        protected MovingObject(double[] xy, double heading, double velocity) {
            super(xy);
            this.m_heading = heading;
            this.m_velocity = velocity;
        }
    }

    public static abstract class XYObject
    implements IXYObject {
        private final double[] m_XY;

        public final double getX() {
            return this.m_XY[0];
        }

        public final double getY() {
            return this.m_XY[1];
        }

        public final double[] getXY() {
            return (double[])this.m_XY.clone();
        }

        public final void setX(double x) {
            this.m_XY[0] = x;
        }

        public final void setY(double y) {
            this.m_XY[1] = y;
        }

        public final void setXY(double x, double y) {
            this.m_XY[0] = x;
            this.m_XY[1] = y;
        }

        public final void setXY(double[] xy) {
            this.m_XY[0] = xy[0];
            this.m_XY[1] = xy[1];
        }

        protected XYObject(double x, double y) {
            this.m_XY = new double[]{x, y};
        }

        protected XYObject(double[] xy) {
            this.m_XY = (double[])xy.clone();
        }
    }

    public static interface ITrackedObject
    extends IUpdatedObject {
        public ITrackedObjectTimeSeries getTimeSeries();
    }

    public static interface ITrackedObjectTimeSeries {
        public int maxsize();

        public int size();

        public IUpdatedObject getPoint(int var1);

        public IUpdatedObject getEarliestPoint();

        public IUpdatedObject getPointByTime(long var1);
    }

    public static interface IUpdatedObject
    extends INamedMovingObject {
        public long getUpdateTime();
    }

    public static interface INamedMovingObject
    extends IMovingObject,
    INamedObject {
    }

    public static interface ITransientObject {
        public boolean isActive();
    }

    public static interface INamedObject {
        public String getID();
    }

    public static interface IMovingObject
    extends IXYObject {
        public double getHeadingRadians();

        public double getVelocity();
    }

    public static interface IXYObject {
        public double getX();

        public double getY();

        public double[] getXY();
    }
}

