/*
 * Decompiled with CFR 0.152.
 */
package morbid;

import java.util.Random;
import morbid.BrokeredObject;
import morbid.IEnemySelectionStrategy;
import morbid.IEventListener;
import morbid.IRobotController;
import morbid.IRobotPositionManager;
import morbid.IStatsManager;
import morbid.IWeaponStrategy;
import morbid.Utils;
import robocode.DeathEvent;
import robocode.Event;
import robocode.WinEvent;

class SeriesPredictorWeaponStrategy
extends BrokeredObject
implements IWeaponStrategy,
IEventListener {
    private final Random m_random = new Random();
    private long m_last_fire_stats_time;
    private double m_firePower;
    private double m_firePhi;
    private FireCollateral m_fireCollateral;
    private final double m_size;
    private final double m_field_width;
    private final double m_field_height;
    private final double[] m_gun_predictor = new double[6];
    private final double DISTANCE_ZONE_WIDTH = 100.0;
    private static final Class[] ACCEPTABLE_EVENTS = new Class[]{class$robocode$WinEvent == null ? (class$robocode$WinEvent = SeriesPredictorWeaponStrategy.class$("robocode.WinEvent")) : class$robocode$WinEvent, class$robocode$DeathEvent == null ? (class$robocode$DeathEvent = SeriesPredictorWeaponStrategy.class$("robocode.DeathEvent")) : class$robocode$DeathEvent};
    private static final String KEY_ZONEMAP = "ZONEMAP";
    private static final double DONT_FIRE = -1.0;
    private static final long MAX_ENEMY_HIT_POWER_REMEMBER_TIME = 30L;
    private static final double PREDICTOR_WALL_MARGIN = 20.0;
    private static final int MIN_FIREFACTS_STATS_COUNT = 6;
    private static final boolean DEBUG_DODGE_CORRECTION = false;
    private static final boolean DEBUG_POWER_SETTING = false;
    private static final boolean DEBUG_ALPHA_SETTING = false;
    private static final boolean DEBUG_DONT_FIRE = false;
    private static final boolean DEBUG = false;
    static /* synthetic */ Class class$robocode$WinEvent;
    static /* synthetic */ Class class$robocode$DeathEvent;

    public SeriesPredictorWeaponStrategy(IRobotController controller) {
        super("WEAPON_STRATEGY", controller);
        this.m_size = Math.ceil(0.5 * Utils.relativeDistance(0.0, 0.0, this.m_robot.getWidth(), this.m_robot.getHeight()));
        this.m_field_width = this.m_robot.getBattleFieldWidth();
        this.m_field_height = this.m_robot.getBattleFieldHeight();
    }

    public Class[] getAcceptableEventTypes() {
        return ACCEPTABLE_EVENTS;
    }

    public void acceptEvent(Event event) {
        if (event instanceof WinEvent || event instanceof DeathEvent) {
            String[] allEnemyIDs = this.m_controller.getStatsManager().getAllKnownObjectIDs();
            int e = 0;
            while (e < allEnemyIDs.length) {
                this.updateZoneMap(allEnemyIDs[e]);
                ++e;
            }
        }
    }

    public double getGunPosition() {
        if (!this.isUpdated()) {
            this.computeGunPhiAndFirePower();
            this.markAsUpdated();
        }
        return this.m_firePhi;
    }

    public double getFirePower() {
        if (!this.isUpdated()) {
            this.computeGunPhiAndFirePower();
            this.markAsUpdated();
        }
        return this.m_firePower;
    }

    public Object getFireCollateral() {
        return this.m_fireCollateral;
    }

    protected double bid() {
        return 0.0;
    }

    private void computeGunPhiAndFirePower() {
        this.m_fireCollateral = null;
        switch (this.m_controller.getRobotPositionManager().getKnownAliveObjectCount()) {
            case 0: {
                this.m_firePower = -1.0;
                break;
            }
            case 1: {
                IEnemySelectionStrategy enemySelectionStrategy = this.m_controller.getEnemySelectionStrategy();
                IRobotPositionManager.ITrackedRobot enemy = enemySelectionStrategy.selectEnemy();
                if (enemy == null) {
                    this.m_firePower = -1.0;
                    break;
                }
                this.setupGun(enemy);
                break;
            }
            default: {
                IEnemySelectionStrategy enemySelectionStrategy = this.m_controller.getEnemySelectionStrategy();
                IRobotPositionManager.ITrackedRobot enemy = enemySelectionStrategy.selectEnemy();
                if (enemy == null) {
                    this.m_firePower = -1.0;
                    break;
                }
                this.setupGun(enemy);
            }
        }
    }

    private void setupGun(IRobotPositionManager.ITrackedRobot enemy) {
        if (this.m_robot.getEnergy() < 0.2) {
            return;
        }
        long time = this.m_robot.getTime();
        double enemy_relative_distance = Utils.relativeDistance(this.m_robot.getX(), this.m_robot.getY(), enemy.getX(), enemy.getY());
        this.chooseFirePower(enemy);
        double bullet_velocity = Utils.bulletPowerToVelocity(this.m_firePower);
        int time_to_gun_cool = this.m_controller.getWeaponManager().getTimeToGunCool();
        double gun_rotation_delay = time_to_gun_cool <= 2 ? (double)time_to_gun_cool : 2.0;
        IRobotPositionManager.ITrackedRobot robot = this.m_controller.getRobotPositionManager().getSelf();
        double[] interpolated_robot = new double[5];
        interpolated_robot[0] = -1.0;
        if (robot.getTimeSeries().size() >= 2) {
            Utils.interpolate2(this.m_robot.out, interpolated_robot, robot.getTimeSeries(), this.m_robot.getTime() - 3L, (double)this.m_robot.getTime() + gun_rotation_delay, this.m_field_width, this.m_field_height);
        }
        if (interpolated_robot[0] < 0.0) {
            double[] interpolated_robot_xy = new double[2];
            Utils.interpolate(interpolated_robot_xy, this.m_robot.getX(), this.m_robot.getY(), this.m_robot.getHeadingRadians(), this.m_robot.getVelocity(), gun_rotation_delay);
            interpolated_robot[1] = interpolated_robot_xy[0];
            interpolated_robot[2] = interpolated_robot_xy[1];
            interpolated_robot[3] = this.m_robot.getHeadingRadians();
            interpolated_robot[4] = this.m_robot.getVelocity();
        }
        this.m_gun_predictor[0] = -1.0;
        Utils.runSeriesPredictor(this.m_robot.out, this.m_gun_predictor, interpolated_robot[1], interpolated_robot[2], (double)this.m_robot.getTime() + gun_rotation_delay, bullet_velocity, enemy, this.m_field_width, this.m_field_height);
        if (this.m_gun_predictor[0] > 0.0) {
            boolean outside;
            boolean bl = outside = this.m_gun_predictor[3] < -20.0 || this.m_gun_predictor[3] > this.m_field_width + 20.0;
            if (!outside) {
                boolean bl2 = outside = this.m_gun_predictor[4] < -20.0 || this.m_gun_predictor[4] > this.m_field_height + 20.0;
            }
            if (outside) {
                double interpolated_enemy_relative_heading;
                this.m_firePhi = interpolated_enemy_relative_heading = Utils.relativeHeading(this.m_robot.getX(), this.m_robot.getY(), this.m_gun_predictor[3], this.m_gun_predictor[4]);
            } else {
                boolean correction;
                double gunphistar = this.m_gun_predictor[1];
                double allowable_gun_phi_margin = Math.max(Math.atan(this.m_size / enemy_relative_distance), 0.1);
                int distanceZone = -1;
                int alphaZone = -1;
                boolean bl3 = correction = Math.abs(Utils.deltaPhi(Utils.relativeHeading(this.m_robot.getX(), this.m_robot.getY(), enemy.getX(), enemy.getY()), gunphistar)) > allowable_gun_phi_margin;
                if (correction) {
                    ZoneMap zoneMap = this.getZoneMap(enemy.getID());
                    distanceZone = zoneMap.distanceToDistanceZone(enemy_relative_distance);
                    int[] alphaZonesWeights = zoneMap.getAlphaZonesValues(distanceZone);
                    alphaZone = this.m_random.nextInt(alphaZonesWeights.length);
                    double alpha_H = (double)(alphaZone + 1) / (double)alphaZonesWeights.length;
                    double correctedX = (1.0 - alpha_H) * enemy.getX() + alpha_H * this.m_gun_predictor[3];
                    double correctedY = (1.0 - alpha_H) * enemy.getY() + alpha_H * this.m_gun_predictor[4];
                    gunphistar = Utils.relativeHeading(interpolated_robot[1], interpolated_robot[2], correctedX, correctedY);
                }
                this.m_firePhi = gunphistar;
                double gunphi = this.m_robot.getGunHeadingRadians();
                if (time_to_gun_cool == 0 && Math.abs(Utils.deltaPhi(this.m_firePhi, gunphi)) < allowable_gun_phi_margin) {
                    if (correction) {
                        this.m_fireCollateral = new FireCollateral(distanceZone, alphaZone);
                    }
                } else {
                    this.m_firePower = -1.0;
                }
            }
        } else {
            double interpolated_enemy_relative_heading;
            double[] interpolated_enemy_xy = new double[2];
            Utils.interpolate(interpolated_enemy_xy, enemy.getX(), enemy.getY(), enemy.getHeadingRadians(), enemy.getVelocity(), 1.5 * gun_rotation_delay);
            this.m_firePhi = interpolated_enemy_relative_heading = Utils.relativeHeading(this.m_robot.getX(), this.m_robot.getY(), interpolated_enemy_xy[0], interpolated_enemy_xy[1]);
        }
    }

    private void chooseFirePower(IRobotPositionManager.IUpdatedRobot enemy) {
        if (this.m_robot.getEnergy() < 16.0) {
            double power;
            if (enemy.getEnergy() < 16.0) {
                power = Utils.damageToBulletPower(enemy.getEnergy() - 0.09);
                if (power > this.m_robot.getEnergy()) {
                    power = Math.max(0.1, power / 2.0);
                }
            } else {
                power = Math.max(0.1, this.m_robot.getEnergy() / 8.0);
            }
            this.m_firePower = power;
        } else if (enemy.getEnergy() < 16.0) {
            this.m_firePower = Utils.damageToBulletPower(enemy.getEnergy());
        } else {
            double enemy_relative_distance = Utils.relativeDistance(this.m_robot.getX(), this.m_robot.getY(), enemy.getX(), enemy.getY());
            if (Utils.inTheCorner(enemy.getXY(), 2.0 * this.m_size, this.m_field_width, this.m_field_height)) {
                this.m_firePower = 3.0;
            } else if (Utils.onTheBoundary(enemy.getXY(), 2.0 * this.m_size, this.m_field_width, this.m_field_height)) {
                this.m_firePower = 1.5;
            } else if (enemy_relative_distance < 200.0 && Math.abs(enemy.getVelocity() * Math.sin(Utils.relativeHeading(this.m_robot.getX(), this.m_robot.getY(), enemy.getXY()) - enemy.getHeadingRadians())) <= 2.0) {
                this.m_firePower = 3.0;
            } else {
                long time = this.m_robot.getTime();
                long last_enemy_hit_time = this.m_controller.getStatsManager().getLastEnemyFireTime(enemy.getID());
                if (last_enemy_hit_time > 0L && last_enemy_hit_time > time - 30L) {
                    double last_enemy_bullet_power = this.m_controller.getStatsManager().getLastEnemyBulletPower(enemy.getID());
                    this.m_firePower = Math.min(1.02 * last_enemy_bullet_power, 3.0);
                    return;
                }
                double[] enemyXY = new double[2];
                double max_relative_distance = 500.0;
                this.m_firePower = enemy_relative_distance > 500.0 ? 0.1 : (enemy_relative_distance > 100.0 ? 1.5 : 3.0);
            }
        }
    }

    private ZoneMap makeZoneMap() {
        double maxDistance = Utils.relativeDistance(0.0, 0.0, this.m_field_width, this.m_field_height);
        int[] distanceZones = new int[3];
        int d = 0;
        while (d < distanceZones.length) {
            switch (d) {
                case 0: {
                    distanceZones[d] = 3;
                    break;
                }
                default: {
                    distanceZones[d] = distanceZones[d - 1];
                }
            }
            ++d;
        }
        ZoneMap zoneMap = new ZoneMap(distanceZones, 100.0);
        return zoneMap;
    }

    private ZoneMap getZoneMap(String enemyID) {
        ZoneMap zoneMap = (ZoneMap)this.m_controller.getStatsManager().getEnemyItem(enemyID, KEY_ZONEMAP);
        if (zoneMap == null) {
            zoneMap = this.makeZoneMap();
            this.m_controller.getStatsManager().putEnemyItem(enemyID, KEY_ZONEMAP, zoneMap);
        }
        return zoneMap;
    }

    private void updateZoneMap(String enemyID) {
        IStatsManager.IStats stats = this.m_controller.getStatsManager().getCurrentStats();
        if (stats == null) {
            return;
        }
        IStatsManager.IHitFact[] hitFacts = stats.getHitFacts(this.m_robot.getName(), enemyID);
        if (hitFacts == null || hitFacts.length == 0) {
            return;
        }
        ZoneMap zoneMap = this.getZoneMap(enemyID);
        int totalHits = 0;
        int usedFacts = 0;
        int f = 0;
        while (f < hitFacts.length) {
            IStatsManager.IHitFact fact = hitFacts[f];
            if (fact.getHitStatus() == 3) {
                ++totalHits;
            }
            if (fact.getFireFact() != null && fact.getFireFact().getBullet().getCollateral() instanceof FireCollateral) {
                ++usedFacts;
                FireCollateral collateral = (FireCollateral)fact.getFireFact().getBullet().getCollateral();
                int currentWeight = zoneMap.getAlphaZonesValues(collateral.m_distanceZone)[collateral.m_alphaZone];
                zoneMap.getAlphaZonesValues((int)collateral.m_distanceZone)[collateral.m_alphaZone] = fact.getHitStatus() == 3 ? currentWeight + 1 : currentWeight - 1;
            }
            ++f;
        }
    }

    private int selectRandomItem(int[] weights) {
        int totalWeight = 0;
        int w = 0;
        while (w < weights.length) {
            totalWeight += weights[w];
            ++w;
        }
        int value = this.m_random.nextInt(totalWeight);
        int scan = weights[0];
        int w2 = 0;
        while (w2 < weights.length) {
            if (value < scan) {
                return w2;
            }
            scan += weights[w2 + 1];
            ++w2;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class ZoneMap {
        private final int[][] m_zones;
        private final double m_zoneWidth;

        public ZoneMap(int[] alphaCounts, double zoneWidth) {
            this.m_zones = new int[alphaCounts.length][];
            int d = 0;
            while (d < this.m_zones.length) {
                this.m_zones[d] = new int[alphaCounts[d]];
                ++d;
            }
            this.m_zoneWidth = zoneWidth;
        }

        public int distanceToDistanceZone(double r) {
            if (r < 200.0) {
                return 0;
            }
            if (r < 500.0) {
                return 1;
            }
            return 2;
        }

        public int getDistanceZoneCount() {
            return this.m_zones.length;
        }

        public int[] getAlphaZonesValues(int distanceZone) {
            return this.m_zones[distanceZone];
        }
    }

    private static final class FireCollateral {
        public final int m_distanceZone;
        public final int m_alphaZone;

        FireCollateral(int distanceZone, int alphaZone) {
            this.m_distanceZone = distanceZone;
            this.m_alphaZone = alphaZone;
        }
    }
}

