/*
 * Decompiled with CFR 0.152.
 */
package stordy;

import java.awt.Graphics2D;
import stordy.Force;
import stordy.Vec2d;

public class ForcePoint
implements Force {
    private Vec2d source;
    private double strength;

    public ForcePoint(Vec2d source, double strength) {
        this.source = source;
        this.strength = strength;
    }

    @Override
    public Vec2d getForceOnPoint(Vec2d point) {
        double fMag = this.strength / Vec2d.getDistanceSquared(this.source, point);
        return point.subtract(this.source).normalize().multiply(fMag);
    }

    public void drawForce(Graphics2D g2) {
        int i = 1;
        while (i < 5) {
            int hsize = Math.abs((int)(this.strength * (1.0 / (double)(i * i)) * 2.0));
            g2.drawOval((int)this.source.getX() - hsize, (int)this.source.getY() - hsize, hsize * 2, hsize * 2);
            ++i;
        }
    }
}

