/*
 * Decompiled with CFR 0.152.
 */
package rampancy.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.Collection;
import rampancy.RampantRobot;
import rampancy.util.REnemyListener;
import rampancy.util.RPoint;
import rampancy.util.RRectangle;
import rampancy.util.RRobotState;
import rampancy.util.RUtil;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class REnemyRobot {
    public static final int MAX_HISTORY_SIZE = 1500;
    public static final int BOT_RADIUS = 18;
    public static final Stroke absoluteDangerStroke = new BasicStroke(3.0f, 0, 2, 0.0f, new float[]{4.0f, 10.0f}, 0.0f);
    public static final Stroke desiredMinStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{4.0f, 20.0f}, 0.0f);
    public static final Stroke desiredMaxStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{4.0f, 20.0f}, 0.0f);
    protected String name;
    protected int shotsFired;
    protected int shotsHit;
    protected double minSafeDistance;
    protected double preferredSafeDistance;
    protected ArrayList<REnemyListener> listeners;
    protected ArrayList<RRobotState> states;
    protected ArrayList<Double> trackedBearings;
    protected ArrayList<Integer> trackedDirections;
    protected Ellipse2D.Double absoluteDangerZone;
    protected Ellipse2D.Double desiredMinDistance;
    protected Ellipse2D.Double desiredMaxDistance;
    protected RampantRobot reference;

    public REnemyRobot(String name, RampantRobot reference) {
        this.name = name;
        this.listeners = new ArrayList();
        this.states = new ArrayList();
        this.resetState();
        this.shotsFired = 0;
        this.shotsHit = 0;
        this.reference = reference;
    }

    public void updateReference(RampantRobot reference) {
        this.reference = reference;
    }

    public RampantRobot getReference() {
        return this.reference;
    }

    public String getName() {
        return this.name;
    }

    public boolean shotFired() {
        RRobotState curr = this.getCurrentState();
        RRobotState last = this.getLastState();
        if (last != null) {
            double diff = last.energy - curr.energy;
            return diff > 0.0 && diff <= 3.0;
        }
        return false;
    }

    public double getShotPower() {
        if (!this.shotFired()) {
            return 0.0;
        }
        return this.getLastState().energy - this.getCurrentState().energy;
    }

    public int getShotsFired() {
        return this.shotsFired;
    }

    public int getShotsHit() {
        return this.shotsHit;
    }

    public void noteShotHit() {
        ++this.shotsHit;
    }

    public double getMinSafeDistance() {
        return this.minSafeDistance;
    }

    public double getPreferredSafeDistance() {
        return this.preferredSafeDistance;
    }

    public void addState(ScannedRobotEvent e) {
        this.states.add(0, new RRobotState(this, e));
        if (this.states.size() >= 1500) {
            this.states.remove(this.states.size() - 1);
        }
    }

    public RRobotState getCurrentState() {
        if (this.states.size() > 0) {
            return this.states.get(0);
        }
        return null;
    }

    public RRobotState getLastState() {
        if (this.states.size() > 1) {
            return this.states.get(1);
        }
        return null;
    }

    public ArrayList<RRobotState> getLastNStates(int n) {
        if (this.states.isEmpty()) {
            return null;
        }
        return new ArrayList<RRobotState>((Collection)this.states.subList(0, Math.min(n - 1, this.states.size())));
    }

    public ArrayList<RRobotState> getStates() {
        return this.states;
    }

    public void clearStates() {
        this.states.clear();
    }

    public int getLastUsableSurfDirection() {
        if (this.trackedDirections.size() > 2) {
            return this.trackedDirections.get(2);
        }
        return 0;
    }

    public double getLastUsableBearing() {
        if (this.trackedBearings.size() > 2) {
            return this.trackedBearings.get(2);
        }
        return 0.0;
    }

    public void resetState() {
        this.trackedBearings = new ArrayList();
        this.trackedDirections = new ArrayList();
    }

    public void update(ScannedRobotEvent e) {
        this.addState(e);
        this.updateTracking(e);
        if (this.shotFired()) {
            this.notifyShotFired();
            ++this.shotsFired;
        }
        this.updateZones();
        this.notifyListeners();
    }

    public void draw(Graphics2D g) {
        Stroke stroke = g.getStroke();
        g.setStroke(stroke);
        RRobotState state = this.getCurrentState();
        if (state == null) {
            return;
        }
        g.setColor(Color.white);
        g.draw(new RRectangle(state.location));
    }

    private void updateZones() {
        RRobotState state = this.getCurrentState();
        if (state == null) {
            return;
        }
        RPoint location = state.location;
        double absBearing = Utils.normalAbsoluteAngle((double)(state.absoluteBearing + Math.PI));
        double maxEscapeAngle = RUtil.computeMaxEscapeAngle(RUtil.computeBulletVelocity(0.1));
        this.minSafeDistance = 30.0 / Math.sin(maxEscapeAngle);
        this.preferredSafeDistance = 150.0;
        this.absoluteDangerZone = new Ellipse2D.Double(location.x - this.minSafeDistance, location.y - this.minSafeDistance, this.minSafeDistance * 2.0, this.minSafeDistance * 2.0);
        this.desiredMinDistance = new Ellipse2D.Double(location.x - this.preferredSafeDistance, location.y - this.preferredSafeDistance, this.preferredSafeDistance * 2.0, this.preferredSafeDistance * 2.0);
        this.desiredMaxDistance = new Ellipse2D.Double(location.x - 400.0, location.y - 400.0, 800.0, 800.0);
    }

    private void updateTracking(ScannedRobotEvent e) {
        double lateralVelocity = this.reference.getVelocity() * Math.sin(e.getBearingRadians());
        int direction = lateralVelocity >= 0.0 ? 1 : -1;
        this.trackedDirections.add(0, direction);
        this.trackedBearings.add(0, this.getCurrentState().absoluteBearing + Math.PI);
    }

    public boolean addListener(REnemyListener listener) {
        if (this.listeners.contains(listener)) {
            return false;
        }
        return this.listeners.add(listener);
    }

    public boolean removeListener(REnemyListener listener) {
        return this.listeners.remove(listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public void notifyListeners() {
        for (REnemyListener listener : this.listeners) {
            listener.enemyUpdated(this);
        }
    }

    public void notifyShotFired() {
        for (REnemyListener listener : this.listeners) {
            listener.shotFired(this);
        }
    }
}

