/*
 * Decompiled with CFR 0.152.
 */
package dsekercioglu;

import dsekercioglu.MantisUtils;
import dsekercioglu.Message;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import robocode.MessageEvent;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;
import robocode.util.Utils;

public class MantisLord
extends TeamRobot {
    public static Point2D.Double lordPosition = new Point2D.Double();
    public static Point2D.Double servantPosition = new Point2D.Double();
    public static Point2D.Double servantTarget = new Point2D.Double();
    public static Point2D.Double enemyPosition;
    public static final double FIGHT_DISTANCE = 100.0;
    public static final double POINT_NUM = 36.0;
    public static final double POINT_DISTANCE = 36.0;
    double enemyVelocity;
    double enemyHeading;
    double oldEnemyHeading;

    public void run() {
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        while (true) {
            this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        lordPosition.setLocation(this.getX(), this.getY());
        this.enemyHeading = e.getHeadingRadians();
        this.enemyVelocity = e.getVelocity();
        double bearing = e.getBearingRadians();
        double heading = this.getHeadingRadians();
        double distance = e.getDistance();
        if (!e.getName().contains("MantisServant")) {
            this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(bearing + heading - this.getRadarHeadingRadians())));
        }
        enemyPosition = MantisUtils.project(lordPosition, heading + bearing, distance);
        Point2D.Double lordTarget = this.getMaxRewardPoint(lordPosition);
        this.goTo(lordTarget.x, lordTarget.y);
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(MantisUtils.absoluteBearing(lordPosition, this.getCircularAttackPosition(lordPosition, 3.0)) - this.getGunHeadingRadians())));
        this.setFire(3.0);
        servantTarget = this.getMaxRewardPoint(servantPosition);
        try {
            this.broadcastMessage(new Message(lordPosition, servantTarget, this.getCircularAttackPosition(servantPosition, 3.0), 3.0));
        }
        catch (IOException ex) {
            Logger.getLogger(MantisLord.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.oldEnemyHeading = this.enemyHeading;
    }

    public Point2D.Double getCircularAttackPosition(Point2D.Double botLocation, double firePower) {
        Point2D.Double predictedPosition = (Point2D.Double)enemyPosition.clone();
        double predictedEnemyHeading = this.enemyHeading;
        double headingChange = predictedEnemyHeading - this.oldEnemyHeading;
        double bulletSpeed = 20.0 - 3.0 * firePower;
        int time = 0;
        while ((double)(++time) * bulletSpeed < predictedPosition.distance(botLocation)) {
            predictedPosition = MantisUtils.project(predictedPosition, predictedEnemyHeading, this.enemyVelocity);
            predictedEnemyHeading += headingChange;
        }
        return predictedPosition;
    }

    public void onMessageReceived(MessageEvent e) {
        servantPosition = ((Message)e.getMessage()).senderPosition;
    }

    public Point2D.Double getMaxRewardPoint(Point2D.Double botLocation) {
        ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
        int i = 0;
        while ((double)i < 36.0) {
            double angle = Math.PI * 2 * (double)i / 36.0;
            points.add(MantisUtils.project(botLocation, angle, 36.0));
            ++i;
        }
        double highestReward = Double.NEGATIVE_INFINITY;
        int bestIndex = 0;
        for (int i2 = 0; i2 < points.size(); ++i2) {
            double reward = this.getReward((Point2D.Double)points.get(i2));
            if (!(reward > highestReward)) continue;
            bestIndex = i2;
            highestReward = reward;
        }
        return (Point2D.Double)points.get(bestIndex);
    }

    public double getReward(Point2D.Double position) {
        double reward = 1.0 / (Math.abs(100.0 - position.distance(enemyPosition)) + 1.0);
        reward *= position.distance(lordPosition) * position.distance(servantPosition);
        Point2D.Double enemyFront = MantisUtils.project(enemyPosition, this.enemyHeading, 100.0 * Math.signum(this.enemyVelocity));
        return reward *= 1.0 / (Math.pow(position.distance(enemyFront), 2.0) + 1.0);
    }

    private void goTo(double x, double y) {
        double a = Math.atan2(x -= this.getX(), y -= this.getY()) - this.getHeadingRadians();
        this.setTurnRightRadians(Math.tan(a));
        this.setAhead(Math.hypot(x, y) * Math.cos(a));
    }
}

