/*
 * Decompiled with CFR 0.152.
 */
package jbot.tracer.techniques;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import jbot.Inherit;
import jbot.Rabbit2;
import jbot.tracer.Ray;
import jbot.tracer.Target;
import jbot.tracer.Wave;
import jbot.util.Vector2;
import robocode.util.Utils;

public abstract class TracerTechnique {
    protected Rabbit2 mBot;
    protected Target mTarget = null;
    protected Target mSelf = null;
    private final String mName;
    private long mRecentTime = 0L;
    private double mDeltaTime = 0.0;
    private int mRealHits = 0;
    private double mEfficient = 1.0;
    private double mLearnFactor = 0.1;
    private long mTestsRewards = 0L;
    private long mRealTestsRewards = 0L;
    private double mInaccuracy = 0.6283185307179586;
    private double mInaccuracyDev = 0.0;
    private double mInaccuracyAvg = 0.6283185307179586;
    private double mRealInaccuracy = 0.6283185307179586;
    private double mRealInaccuracyDev = 0.0;
    private double mRealInaccuracyAvg = 0.6283185307179586;
    public Color mColor = Color.WHITE;
    public List<Vector2> mEstimatedPath = new ArrayList<Vector2>();

    public TracerTechnique(String techName, Rabbit2 bot, Target self, Target target, double initInaccuracy, double learnFactor) {
        this.mName = techName;
        this.mBot = bot;
        this.mSelf = self;
        this.mTarget = target;
        this.mInaccuracyAvg = this.mInaccuracy = initInaccuracy;
        this.mRealInaccuracy = this.mInaccuracy;
        this.mRealInaccuracyAvg = this.mInaccuracy;
        this.mLearnFactor = learnFactor;
    }

    public void addRealHit() {
        ++this.mRealHits;
    }

    public int getRealHits() {
        return this.mRealHits;
    }

    public void recalcRealHits(double mul) {
        this.mRealHits = (int)((double)this.mRealHits * mul);
    }

    public String getName() {
        return this.mName;
    }

    public long getRecentTime() {
        return this.mRecentTime;
    }

    public double getDeltaTime() {
        return this.mDeltaTime;
    }

    public double getLearnFactor() {
        return this.mLearnFactor;
    }

    public double getEfficient() {
        return this.mEfficient;
    }

    public double getInaccuracy() {
        return this.mInaccuracy;
    }

    public double getInaccuracyDev() {
        return this.mInaccuracyDev;
    }

    public double getInaccuracyAvg() {
        return this.mInaccuracyAvg;
    }

    public double getTestsRewards() {
        return this.mTestsRewards;
    }

    public double getRealTestsRewards() {
        return this.mRealTestsRewards;
    }

    public double getRealInaccuracy() {
        return this.mRealInaccuracy;
    }

    public double getRealInaccuracyDev() {
        return this.mRealInaccuracyDev;
    }

    public double getRealInaccuracyAvg() {
        return this.mRealInaccuracyAvg;
    }

    public Color getColor() {
        return this.mColor;
    }

    public void setEfficient(double e) {
        if (e < 0.0) {
            e = 0.0;
        } else if (e > 1.0) {
            e = 1.0;
        }
        this.mEfficient = e;
    }

    public Inherit.Container collectData() {
        return null;
    }

    public boolean extractData(Inherit.Container io) {
        return true;
    }

    public abstract double getShotAngleFor(long var1, Vector2 var3, double var4);

    public String prepareLogString() {
        return "";
    }

    public double normalProbability(double propability) {
        if (propability < 0.0) {
            propability = 0.0;
        } else if (propability > 1.0) {
            propability = 1.0;
        }
        return propability;
    }

    public double getHitProbability(double distance) {
        if (distance <= 42.0) {
            distance = 42.0;
        }
        double clearShootAngle = Math.tan(21.0 / distance);
        if (this.mInaccuracy < 1.0E-4) {
            return 1.0;
        }
        double inaccuracy = (this.mInaccuracy + this.mInaccuracyAvg + this.mRealInaccuracy * 3.0 + this.mRealInaccuracyAvg) / 6.0;
        double prob = clearShootAngle / inaccuracy;
        return this.normalProbability(prob *= this.mEfficient);
    }

    public void rewardAccuracy(double aimError, boolean forRealBullet) {
        double newInaccuracy;
        double learnFactor = this.mLearnFactor * this.mEfficient;
        double currInacc = Math.abs(Utils.normalRelativeAngle((double)aimError));
        ++this.mTestsRewards;
        if (forRealBullet) {
            ++this.mRealTestsRewards;
            newInaccuracy = (1.0 - learnFactor) * this.mRealInaccuracy + learnFactor * currInacc;
            this.mRealInaccuracyDev = Math.pow(this.mRealInaccuracyDev, 2.0);
            this.mRealInaccuracyDev = (1.0 - learnFactor) * this.mRealInaccuracyDev + learnFactor * Math.pow(newInaccuracy - this.mRealInaccuracy, 2.0);
            this.mRealInaccuracyDev = Math.sqrt(this.mRealInaccuracyDev);
            this.mRealInaccuracy = newInaccuracy;
            this.mRealInaccuracyAvg = this.mRealInaccuracyAvg * (1.0 - 1.0 / (double)this.mRealTestsRewards) + currInacc * (1.0 / (double)this.mRealTestsRewards);
        }
        learnFactor = this.mLearnFactor * this.mEfficient / 4.0;
        newInaccuracy = (1.0 - learnFactor) * this.mInaccuracy + learnFactor * currInacc;
        this.mInaccuracyDev = Math.pow(this.mInaccuracyDev, 2.0);
        this.mInaccuracyDev = (1.0 - learnFactor) * this.mInaccuracyDev + learnFactor * Math.pow(newInaccuracy - this.mInaccuracy, 2.0);
        this.mInaccuracyDev = Math.sqrt(this.mInaccuracyDev);
        this.mInaccuracy = newInaccuracy;
        this.mInaccuracyAvg = this.mInaccuracyAvg * (1.0 - 1.0 / (double)this.mTestsRewards) + currInacc * (1.0 / (double)this.mTestsRewards);
    }

    public void addEstimatedRay(Wave w) {
        Vector2 direction = new Vector2(this.getShotAngleFor(w.getShotTime(), w.getShotPos(), w.getPower()));
        w.addRay(new Ray(this, direction, this.getHitProbability(w.getDistToTarget())));
    }

    public void frame(long currTime) {
        if (this.mRecentTime > 0L) {
            this.mDeltaTime = currTime - this.mRecentTime;
        }
        this.mRecentTime = currTime;
        this.frameLogic(this.mDeltaTime);
    }

    protected void frameLogic(double deltaTime) {
    }

    public void selfLearn(Wave wave, Ray ray, double aimError) {
    }

    public void onPaint(Graphics2D g) {
    }
}

