/*
 * Decompiled with CFR 0.152.
 */
package jdw.hurricane.gun;

import jdw.hurricane.GlobalData;
import jdw.util.AnglePoints;
import robocode.Rules;
import robocode.util.Utils;

public class Gun
extends GlobalData {
    public void init_round() {
    }

    public void tick() {
        double max_energy = 0.0;
        int i = 0;
        while (i < num_enemies_alive) {
            if (Gun.sorted_enemies[i].active && Gun.sorted_enemies[i].last_energy > max_energy && (max_energy = Gun.sorted_enemies[i].last_energy) > 16.0) break;
            ++i;
        }
        double power = max_energy > 4.0 ? (max_energy + 2.0) / 6.0 : max_energy / 4.0;
        int sim_step = 10;
        power = Math.min(Math.min(energy / 4.0, power), 3.0);
        double vel = Rules.getBulletSpeed((double)power);
        double max_turn = Math.min((Rules.GUN_TURN_RATE_RADIANS - Rules.MAX_TURN_RATE_RADIANS) * (double)(gun_fire_ticks == 0 ? 1000 : gun_fire_ticks), Math.PI);
        double max_ang = Math.min(max_turn + 0.5, Math.PI);
        int num_windows = Math.max(512, (int)(4.71238898038469 / Math.atan(18.0 / max_enemy_dist)));
        AnglePoints windows = new AnglePoints(-max_ang, max_ang, num_windows);
        boolean has_enabled = false;
        i = 0;
        while (i < num_enemies_alive) {
            if (!Gun.sorted_enemies[i].active) {
                ++i;
                continue;
            }
            if (Gun.sorted_enemies[i].last_energy > 0.05) {
                has_enabled = true;
            }
            double winSizeD2 = Math.atan(18.0 / Gun.sorted_enemies[i].last_dist) / max_ang;
            double dist_prob = Math.max(1.0 - 2.5E-5 * (double)num_enemies * Gun.sorted_enemies[i].last_dist, 0.0);
            double profit = sorted_enemies[i].get_profit();
            for (double[] target : sorted_enemies[i].get_targets(gun_fire_ticks, vel, pos_x, pos_y)) {
                if (target[0] < out_min_x_y || target[1] < out_min_x_y || target[0] > out_max_x || target[1] > out_max_y) continue;
                painter.paint_circle(target[0], target[1], 18.0, target[2]);
                double rx = target[0] - pos_x;
                double ry = target[1] - pos_y;
                double ang = Utils.normalRelativeAngle((double)(Math.atan2(rx, ry) - gun_heading)) / max_ang;
                if (ang < -1.0 || ang > 1.0) continue;
                windows.add(ang - winSizeD2, ang + winSizeD2, target[2] * dist_prob, profit);
            }
            ++i;
        }
        windows.calc_max_profit(-max_turn, max_turn);
        rot_gun = windows.max_x;
        painter.paint_polar_line(pos_x, pos_y, gun_heading + rot_gun, 1000.0);
        if (gun_fire_ticks == 0 && energy > 0.1 && windows.profit_at(0.0) > 0.01 && has_enabled) {
            fire_gun = power;
        }
    }
}

