/*
 * Decompiled with CFR 0.152.
 */
package metal.shared;

import java.awt.geom.RoundRectangle2D;
import metal.shared.MAngle;
import metal.shared.MBotData;
import metal.shared.MMath;
import metal.shared.MPoint;
import robocode.HitByBulletEvent;

public class MChassisTityus {
    static final int DISTANCE_INDEXES = 5;
    static final double MAX_VELOCITY = 8.0;
    static final double WALL_MARGIN = 30.0;
    static double direction = 1.6 + 5.0 * Math.random();
    static double[] reverseFactors = new double[]{1.0, 1.0, 1.0, 1.0, 1.0};
    static long timeOfLastReverse;

    public MChassisTityus() {
        MBotData.print("SYSTEM:  Chassis    ... OK");
    }

    static int distanceIndex() {
        return Math.min((int)(MBotData.enemy.distance / 160.0), 4);
    }

    static RoundRectangle2D fieldRectangle(double margin) {
        return new RoundRectangle2D.Double(margin, margin, MBotData.self.getBattleFieldWidth() - margin * 2.0, MBotData.self.getBattleFieldHeight() - margin * 2.0, 75.0, 75.0);
    }

    static void go(MPoint destination) {
        double angle = MAngle.relative(MAngle.absolute(MBotData.getLocation(), destination) - MBotData.self.getHeading());
        double turnAngle = MMath.atan(MMath.tan(angle));
        MBotData.self.setTurnRight(turnAngle);
        MBotData.self.setAhead(MBotData.getLocation().distance(destination) * (double)(angle == turnAngle ? 1 : -1));
        MBotData.self.setMaxVelocity(Math.abs(MBotData.self.getTurnRemaining()) > 30.0 ? 0.0 : 8.0);
    }

    public static void go2(MPoint toPoint) {
        double dist = MBotData.getLocation().distance(toPoint);
        double ang = MAngle.relative(MAngle.absolute(MBotData.getLocation(), toPoint) - MBotData.self.getHeading());
        if (MMath.abs(ang) > 90.0) {
            dist *= -1.0;
            ang = ang > 0.0 ? (ang -= 180.0) : (ang += 180.0);
        }
        MBotData.self.setTurnRight(ang + MMath.random(-1.0, 1.0));
        MBotData.self.setAhead(dist);
    }

    private static void kiss() {
        MBotData.self.setMaxVelocity(8.0);
        MChassisTityus.go(MBotData.enemy);
    }

    public static void move() {
        try {
            if (MBotData.enemy.energy < 1.0 && MBotData.self.getEnergy() > 12.0 || MBotData.enemy.energy == 0.0) {
                MChassisTityus.kiss();
            } else {
                MChassisTityus.movement();
            }
        }
        catch (Exception e) {
            MBotData.err("SYSTEM:  Chassis    ... FAILED");
            e.printStackTrace();
        }
    }

    private static void movement() {
        MPoint robotDestination = null;
        if (Math.random() < reverseFactors[MChassisTityus.distanceIndex()] * (0.0277 - (MBotData.enemy.distance - 580.0) / 8500.0) / MAngle.max(8.0, MBotData.enemy.energyDiff)) {
            MChassisTityus.reverse();
        }
        int i = 0;
        while (i < 2) {
            double tries = 0.0;
            do {
                robotDestination = MChassisTityus.vectorToLocation(MAngle.absolute(MBotData.enemy, MBotData.getLocation()) + direction, MBotData.enemy.distance * (1.1 - tries / 100.0), MBotData.enemy);
            } while ((tries += 1.0) < (double)(25 + i * 75) && !MChassisTityus.fieldRectangle(30.0).contains(robotDestination));
            if (MChassisTityus.fieldRectangle(30.0).contains(robotDestination)) break;
            MChassisTityus.reverse();
            ++i;
        }
        MChassisTityus.go(robotDestination);
    }

    static void reverse() {
        direction *= -1.0;
        timeOfLastReverse = MBotData.self.getTime();
    }

    public void update(HitByBulletEvent e) {
        double fullLeadTime = (MBotData.enemy.distance + 100.0) / e.getVelocity();
        double timeSinceReverse = MBotData.self.getTime() - timeOfLastReverse;
        if (timeSinceReverse < fullLeadTime) {
            MChassisTityus.reverseFactors[MChassisTityus.distanceIndex()] = MMath.rollingAvg(reverseFactors[MChassisTityus.distanceIndex()], 0.4, 10.0);
        }
    }

    static MPoint vectorToLocation(double angle, double length, MPoint sourceLocation) {
        return new MPoint(sourceLocation.getX() + MMath.sin(angle) * length, sourceLocation.getY() + MMath.cos(angle) * length);
    }
}

