/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.robot;

import java.awt.Color;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class BlueBerry
extends AdvancedRobot {
    static int ahead = 250;
    double lastEnemyBearing;
    double beforeLastEnemyBearing;
    static int radarScan = 90;
    double enemyDirection;
    int hits;
    static int aimingOffset = 0;

    public void onScannedRobot(ScannedRobotEvent event) {
        this.beforeLastEnemyBearing = this.lastEnemyBearing;
        this.lastEnemyBearing = this.getHeading() + event.getBearing();
        radarScan = -radarScan;
    }

    public void onDeath(DeathEvent event) {
        if (this.hits <= 1) {
            aimingOffset = 20 - aimingOffset;
        }
    }

    public void onBulletHit(BulletHitEvent event) {
        ++this.hits;
    }

    public void onHitByBullet(HitByBulletEvent event) {
        this.setTurnRight(50.0);
    }

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAllColors(Color.BLUE);
        while (true) {
            this.operateGun();
            this.operateMovement();
            this.setTurnRadarRight(radarScan);
            this.execute();
        }
    }

    private void operateGun() {
        this.setTurnGunRight(this.getTurn(this.lastEnemyBearing + (double)aimingOffset * this.enemyDirection, this.getGunHeading()));
        this.setFire(this.getEnergy() / 5.0);
    }

    public void operateMovement() {
        if (this.getDistanceRemaining() == 0.0) {
            ahead = -ahead;
            this.setAhead(ahead);
            this.setTurnRight(105.0);
            this.enemyDirection = Math.signum(this.getTurn(this.lastEnemyBearing, this.beforeLastEnemyBearing));
        }
    }

    private double getTurn(double target, double current) {
        return Utils.normalRelativeAngleDegrees((double)(target % 360.0 - current % 360.0));
    }
}

