/*
 * Decompiled with CFR 0.152.
 */
package cbot.cbot.gun;

import cbot.cbot.Bot;
import cbot.cbot.CBot;
import cbot.cbot.CU;
import cbot.cbot.Pray;
import cbot.cbot.gun.GunStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SectorStatisticGunStrategy
extends GunStrategy {
    private int SEGMENTS_NUM;
    private int[] totFired;
    private int[][] sectorHit;
    private LinkedList[][] recentlyHit;
    private final int MAX_NUM_OF_RECENTLY_BULLETS = 6;
    private double[] sectors;
    private double sectorSideWidth;
    private int defaultIndex;
    private int lastUsedIndex;

    public double getBulletAngel(Bot robot, Bot pray, double firePower) {
        this.lastUsedIndex = this.getSortedIndexes((Pray)pray)[0];
        Random rand = new Random();
        double angle = this.sectors[this.lastUsedIndex] + rand.nextGaussian() * 1.5;
        return Math.toRadians(angle);
    }

    public void updateStatistics(Pray pray, double angle) {
        angle = Math.toDegrees(angle);
        int index = this.getSegmentIndex(pray);
        int i = 0;
        while (i < this.sectors.length) {
            boolean hit = false;
            if (angle <= this.sectors[i] + this.sectorSideWidth && angle > this.sectors[i] - this.sectorSideWidth) {
                int[] nArray = this.sectorHit[index];
                int n = i;
                nArray[n] = nArray[n] + 1;
                hit = true;
            }
            this.addRecentlyHit(i, hit, index);
            ++i;
        }
    }

    public void virtualBulletFired(Pray pray) {
        int n = this.getSegmentIndex(pray);
        this.totFired[n] = this.totFired[n] + 1;
    }

    private final void addRecentlyHit(int i, boolean hit, int index) {
        if (this.recentlyHit[index][i].size() >= 6) {
            this.recentlyHit[index][i].removeLast();
        }
        Integer value = hit ? new Integer(1) : new Integer(0);
        this.recentlyHit[index][i].addFirst(value);
    }

    /*
     * WARNING - void declaration
     */
    private final int[] getSortedIndexes(Pray pray) {
        int index = this.getSegmentIndex(pray);
        if (this.totFired[index] < 10) {
            void rates;
            int[] arr = new int[]{this.defaultIndex};
            return rates;
        }
        HashMap<Integer, Double> rates = new HashMap<Integer, Double>(this.sectors.length);
        double[] totRates = this.getHittingRates(index);
        double[] recentRates = this.getRecentHittingRates(index);
        int i = 0;
        while (i < recentRates.length) {
            rates.put(new Integer(i), new Double(totRates[i] + recentRates[i] * 0.7));
            ++i;
        }
        ArrayList listVersion = new ArrayList(rates.entrySet());
        Collections.sort(listVersion, new Comparator(this){
            final /* synthetic */ SectorStatisticGunStrategy this$0;

            public final int compare(Object o1, Object o2) {
                Double v1 = (Double)((Map.Entry)o1).getValue();
                Double v2 = (Double)((Map.Entry)o2).getValue();
                return v2.compareTo(v1);
            }
            {
                this.this$0 = sectorStatisticGunStrategy;
            }
        });
        int count = 0;
        int[] sortedIndexes = new int[this.sectors.length];
        Iterator itr = listVersion.iterator();
        while (itr.hasNext()) {
            Integer key = (Integer)itr.next().getKey();
            sortedIndexes[count] = key;
            ++count;
        }
        return sortedIndexes;
    }

    private final double[] getHittingRates(int index) {
        double[] rates = new double[this.sectors.length];
        int i = 0;
        while (i < rates.length) {
            rates[i] = (double)this.sectorHit[index][i] / (double)this.totFired[index] * 100.0;
            ++i;
        }
        return rates;
    }

    private final double[] getRecentHittingRates(int index) {
        double[] rates = new double[this.sectors.length];
        int i = 0;
        while (i < rates.length) {
            Iterator itr = this.recentlyHit[index][i].iterator();
            int allHits = 0;
            while (itr.hasNext()) {
                allHits += ((Integer)itr.next()).intValue();
            }
            rates[i] = (double)allHits / 6.0 * 100.0;
            ++i;
        }
        return rates;
    }

    private final int getSegmentIndex(Pray pray) {
        double limit = 1.0;
        double bearingDelta = pray.getBearingDelta();
        if (bearingDelta < -limit) {
            return 0;
        }
        if (bearingDelta > -limit && bearingDelta < limit) {
            return 1;
        }
        return 2;
    }

    public String getStatistics() {
        String str = "\n  Sector statistics:\n";
        int i = 0;
        while (i < this.sectors.length) {
            str = str + "    " + this.sectors[i];
            int j = 0;
            while (j < this.SEGMENTS_NUM) {
                String rate = CU.formatNumber((double)this.sectorHit[j][i] / (double)this.totFired[j] * 100.0);
                str = str + " [" + this.sectorHit[j][i] + '/' + this.totFired[j] + "] " + rate;
                ++j;
            }
            str = str + '\n';
            ++i;
        }
        return str;
    }

    public boolean match(Bot pray) {
        return false;
    }

    public String getGunSign() {
        return "S";
    }

    private final /* synthetic */ void this() {
        this.SEGMENTS_NUM = 3;
        this.MAX_NUM_OF_RECENTLY_BULLETS = 6;
        double[] dArray = new double[13];
        dArray[0] = -42.0;
        dArray[1] = -35.0;
        dArray[2] = -28.0;
        dArray[3] = -21.0;
        dArray[4] = -14.0;
        dArray[5] = -7.0;
        dArray[7] = 7.0;
        dArray[8] = 14.0;
        dArray[9] = 21.0;
        dArray[10] = 28.0;
        dArray[11] = 35.0;
        dArray[12] = 42.0;
        this.sectors = dArray;
        this.sectorSideWidth = (this.sectors[this.sectors.length - 1] - this.sectors[this.sectors.length - 2]) / (double)2;
        this.defaultIndex = (this.sectors.length - 1) / 2;
    }

    public SectorStatisticGunStrategy(CBot robot) {
        super(robot);
        this.this();
        this.totFired = new int[this.SEGMENTS_NUM];
        this.sectorHit = new int[this.SEGMENTS_NUM][this.sectors.length];
        this.recentlyHit = new LinkedList[this.SEGMENTS_NUM][this.sectors.length];
        int i = 0;
        while (i < this.sectors.length) {
            int j = 0;
            while (j < this.SEGMENTS_NUM) {
                this.recentlyHit[j][i] = new LinkedList();
                ++j;
            }
            ++i;
        }
    }
}

