/*
 * Decompiled with CFR 0.152.
 */
package mz;

import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;

public class Cork
extends AdvancedRobot {
    static double travel;
    static double bearing;

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        travel = 250.0;
        while (true) {
            this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double cornerX = 500.0 - this.getX();
        double cornerY = 500.0 - this.getY();
        bearing = this.getHeadingRadians();
        this.setTurnRightRadians(Math.cos(Math.atan2(cornerX, cornerY)) - bearing - 0.003 * travel * (double)(Math.hypot(cornerX, cornerY) >= 420.0 ? 1 : -1));
        if (this.getDistanceRemaining() == 0.0) {
            travel = -travel;
            this.setAhead(travel * (0.4 + Math.random()));
        }
        if (e.getDistance() < 1000.0 / Math.sqrt(this.getOthers())) {
            this.setTurnRadarRightRadians((double)5 * Math.sin((bearing += e.getBearingRadians()) - this.getRadarHeadingRadians()));
            this.setTurnGunRightRadians(Math.sin(bearing - this.getGunHeadingRadians()) + Math.asin(Math.sin(e.getHeadingRadians() - bearing) * e.getVelocity() / 15.0));
            this.setFire(400.0 / e.getDistance());
        }
        this.clearAllEvents();
    }
}

