/*
 * Decompiled with CFR 0.152.
 */
package lazarecki.robot.painter;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import lazarecki.robot.RobotInfo;
import lazarecki.robot.painter.PainterModule;
import lazarecki.robot.strategy.GravityMovementModule;
import lazarecki.util.RoboUtils;
import robocode.util.Utils;

public class GravityPainterModule
extends PainterModule {
    private GravityMovementModule gravityModule;
    private Color resultingVectorColor;
    private Color gravityVectorColor;

    public GravityPainterModule(GravityMovementModule gravityModule) {
        this.gravityModule = gravityModule;
        this.resultingVectorColor = new Color(Color.GRAY.getRed(), Color.GRAY.getGreen(), Color.GRAY.getBlue(), 192);
        this.gravityVectorColor = new Color(Color.LIGHT_GRAY.getRed(), Color.LIGHT_GRAY.getGreen(), Color.LIGHT_GRAY.getBlue(), 192);
    }

    public Color getResultingVectorColor() {
        return this.resultingVectorColor;
    }

    public void setResultingVectorColor(Color resultingVectorColor) {
        this.resultingVectorColor = resultingVectorColor;
    }

    public Color getGravityVectorColor() {
        return this.gravityVectorColor;
    }

    public void setGravityVectorColor(Color gravityVectorColor) {
        this.gravityVectorColor = gravityVectorColor;
    }

    @Override
    public void onPaint(Graphics2D g) {
        RobotInfo myInfo = new RobotInfo(this.getRobot());
        for (GravityMovementModule.GravityForce force : this.gravityModule.getGravityForces()) {
            this.onPaintVector(g, myInfo, force, this.getGravityVectorColor());
        }
    }

    protected void onPaintVector(Graphics2D g, RobotInfo source, GravityMovementModule.GravityForce force, Color color) {
        g.setColor(color);
        double absAngle = source.absoluteAngle(force.getAttractor());
        double distance = source.distance(force.getAttractor()) - 35.0;
        Point2D pos = RoboUtils.projectPoint(source, absAngle, 35.0);
        Point2D head = RoboUtils.projectPoint(pos, absAngle, force.getForce() * distance / this.gravityModule.calculateTotalGravityValue());
        Point2D left = RoboUtils.projectPoint(pos, Utils.normalAbsoluteAngle((double)(absAngle - 1.5707963267948966)), 5.0);
        Point2D right = RoboUtils.projectPoint(pos, Utils.normalAbsoluteAngle((double)(absAngle + 1.5707963267948966)), 5.0);
        Path2D.Double vector = new Path2D.Double();
        ((Path2D)vector).moveTo(head.getX(), head.getY());
        ((Path2D)vector).lineTo(left.getX(), left.getY());
        ((Path2D)vector).lineTo(right.getX(), right.getY());
        vector.closePath();
        Ellipse2D.Double point = new Ellipse2D.Double(force.getAttractor().getX() - 2.5, force.getAttractor().getY() - 2.5, 5.0, 5.0);
        g.fill(vector);
        g.fill(point);
        g.draw(vector);
        g.draw(point);
    }
}

