/*
 * Decompiled with CFR 0.152.
 */
package simonton.dc;

import java.util.LinkedList;
import java.util.Queue;
import simonton.dc.Cluster;
import simonton.dc.Distancer;

public class MyTree {
    private final Node root;
    private final int maxDensity;
    private final double maxCoordinate;
    private int size;
    private int numRemoved;
    private final double[] lBounds;
    private final double[] uBounds;

    public MyTree(int dimensions, int maxDensity, double maxCoordinate, int maxDepth) {
        this.maxDensity = maxDensity;
        this.maxCoordinate = maxCoordinate;
        this.root = new Node(maxDepth);
        this.lBounds = new double[dimensions];
        this.uBounds = new double[dimensions];
    }

    public Cluster.Point add(double[] location, Object value) {
        Cluster.Point point = new Cluster.Point(value, location);
        this.add(point);
        return point;
    }

    public Cluster.Point add(Cluster.Point point) {
        this.resetBounds();
        Cluster.Point removed = this.root.add(point);
        if (removed == null) {
            ++this.size;
        }
        return removed;
    }

    public Cluster buildCluster(double[] center, int size, Distancer distancer, Cluster.Filter filter) {
        this.resetBounds();
        Cluster cluster = new Cluster(center, size, distancer, filter);
        this.root.addToCluster(cluster);
        return cluster;
    }

    public int size() {
        return this.size;
    }

    private void resetBounds() {
        int i = this.lBounds.length;
        while (--i >= 0) {
            this.lBounds[i] = 0.0;
            this.uBounds[i] = this.maxCoordinate;
        }
    }

    private class Node {
        private final int maxDepth;
        private boolean internal;
        private Node lChild;
        private Node rChild;
        private Queue data;
        final MyTree this$0;

        public Cluster.Point add(Cluster.Point point) {
            if (this.internal) {
                double[] location = point.location;
                int dimension = this.maxDepth % location.length;
                double median = (MyTree.this.lBounds[dimension] + MyTree.this.uBounds[dimension]) / 2.0;
                if (location[dimension] < median) {
                    ((MyTree)MyTree.this).uBounds[dimension] = median;
                    if (this.lChild == null) {
                        this.lChild = new Node(this.maxDepth - 1);
                    }
                    return this.lChild.add(point);
                }
                ((MyTree)MyTree.this).lBounds[dimension] = median;
                if (this.rChild == null) {
                    this.rChild = new Node(this.maxDepth - 1);
                }
                return this.rChild.add(point);
            }
            if (this.data.size() < MyTree.this.maxDensity) {
                this.data.add(point);
                return null;
            }
            if (this.maxDepth == 1) {
                this.data.add(point);
                return (Cluster.Point)this.data.poll();
            }
            int dimension = this.maxDepth % MyTree.this.lBounds.length;
            double median = (MyTree.this.lBounds[dimension] + MyTree.this.uBounds[dimension]) / 2.0;
            for (Cluster.Point p : this.data) {
                if (p.location[dimension] < median) {
                    if (this.lChild == null) {
                        this.lChild = new Node(this.maxDepth - 1);
                    }
                    this.lChild.data.add(p);
                    continue;
                }
                if (this.rChild == null) {
                    this.rChild = new Node(this.maxDepth - 1);
                }
                this.rChild.data.add(p);
            }
            this.data = null;
            this.internal = true;
            return this.add(point);
        }

        public void addToCluster(Cluster cluster) {
            if (this.internal) {
                double median;
                int dimension = this.maxDepth % MyTree.this.lBounds.length;
                boolean lFirst = cluster.center[dimension] < (median = (MyTree.this.lBounds[dimension] + MyTree.this.uBounds[dimension]) / 2.0);
                this.addChildToCluster(cluster, median, lFirst);
                this.addChildToCluster(cluster, median, !lFirst);
            } else {
                for (Cluster.Point p : this.data) {
                    cluster.consider(p);
                }
            }
        }

        private void addChildToCluster(Cluster cluster, double median, boolean left) {
            int dimension = this.maxDepth % MyTree.this.lBounds.length;
            if (left) {
                if (this.lChild == null) {
                    return;
                }
                double orig = MyTree.this.uBounds[dimension];
                ((MyTree)MyTree.this).uBounds[dimension] = median;
                if (cluster.isViable(MyTree.this.lBounds, MyTree.this.uBounds)) {
                    this.lChild.addToCluster(cluster);
                }
                ((MyTree)MyTree.this).uBounds[dimension] = orig;
            } else {
                if (this.rChild == null) {
                    return;
                }
                double orig = MyTree.this.lBounds[dimension];
                ((MyTree)MyTree.this).lBounds[dimension] = median;
                if (cluster.isViable(MyTree.this.lBounds, MyTree.this.uBounds)) {
                    this.rChild.addToCluster(cluster);
                }
                ((MyTree)MyTree.this).lBounds[dimension] = orig;
            }
        }

        public Node(int maxDepth) {
            this.this$0 = MyTree.this;
            this.internal = false;
            this.data = new LinkedList();
            this.maxDepth = maxDepth;
        }
    }
}

