/*
 * Decompiled with CFR 0.152.
 */
package simonton.dc;

import java.util.Arrays;
import simonton.dc.Distancer;
import simonton.utils.FastMath;
import simonton.utils.Util;

public class WeightedCombinationDistancer
implements Distancer {
    private double[] weights;
    private int[] masks;

    public WeightedCombinationDistancer(int numVariable) {
        int startMask;
        this.masks = new int[1 << numVariable];
        int mask = startMask = -1 << numVariable;
        int i = 0;
        while (mask < 0) {
            this.masks[i] = mask++;
            ++i;
        }
        this.weights = new double[this.masks.length];
        Arrays.fill(this.weights, 0.5);
    }

    public int[] getMasks() {
        return this.masks;
    }

    public void rollWeight(int index, double newVal, int depth) {
        this.weights[index] = FastMath.roll(this.weights[index], newVal, depth);
    }

    public void setWeight(int index, double weight) {
        this.weights[index] = weight;
    }

    public double[] setWeights(double[] weights) {
        double[] ret = this.weights;
        this.weights = weights;
        return ret;
    }

    @Override
    public double getDistance(double[] p1, double[] p2) {
        double distance = 0.0;
        int i = this.masks.length;
        while (--i >= 0) {
            int mask = this.masks[i];
            int dimension = p1.length;
            while (--dimension >= 0) {
                if ((mask & 1 << dimension) <= 0) continue;
                distance += this.weights[dimension] * FastMath.abs(p1[dimension] - p2[dimension]);
            }
        }
        return distance;
    }

    public void printWeights() {
        StringBuilder line = new StringBuilder();
        double[] ad = this.weights;
        int j = this.weights.length;
        int i = 0;
        while (i < j) {
            double weight = ad[i];
            line.append(String.format("%.4f ", weight));
            ++i;
        }
        Util.log(line.toString(), new Object[0]);
    }
}

