/*
 * Decompiled with CFR 0.152.
 */
package mc2.enemy;

import java.awt.geom.Point2D;
import mc2.enemy.Enemy;

class EnemyCollection
implements Enemy {
    protected static final int MAX_STACK_SIZE = 500;
    private Enemy[] m_information = new Enemy[500];
    private int next = 0;
    private int size = 0;

    public EnemyCollection(Enemy in_newEnemy) {
        this.add(in_newEnemy);
    }

    public void add(Enemy in_new) {
        this.size = this.size == 500 ? this.size : this.size + 1;
        this.m_information[this.next] = in_new;
        this.next = (this.next + 1) % 500;
    }

    public Enemy get(int in_index) {
        int index = this.next - in_index - 1;
        if (index < 0) {
            index += 500;
        }
        return this.m_information[index];
    }

    public int size() {
        return this.size;
    }

    @Override
    public String getName() {
        return this.get(0).getName();
    }

    @Override
    public double getEnergy() {
        return this.get(0).getEnergy();
    }

    @Override
    public double getVelocity() {
        return this.get(0).getVelocity();
    }

    @Override
    public double getX() {
        return this.get(0).getX();
    }

    @Override
    public double getY() {
        return this.get(0).getY();
    }

    @Override
    public Point2D.Double getLocation() {
        return this.get(0).getLocation();
    }

    @Override
    public double getAngle() {
        return this.get(0).getAngle();
    }

    @Override
    public double getDistance() {
        return this.get(0).getDistance();
    }

    @Override
    public double getHeadingRadians() {
        return this.get(0).getHeadingRadians();
    }

    @Override
    public double getHeading() {
        return this.get(0).getHeading();
    }

    @Override
    public double getBearingRadians() {
        return this.get(0).getBearingRadians();
    }

    @Override
    public double getBearing() {
        return this.get(0).getBearing();
    }

    @Override
    public long getTime() {
        return this.get(0).getTime();
    }

    @Override
    public boolean isUpdated(long t) {
        return t - 16L <= this.get(0).getTime();
    }

    @Override
    public double getDangerousityLevel() {
        return this.get(0).getDangerousityLevel();
    }

    @Override
    public void IncreaseDangerousityLevel() {
    }
}

