/*
 * Decompiled with CFR 0.152.
 */
package nosteel.Basics;

public class Vector {
    public double x;
    public double y;

    public Vector() {
        this.x = Double.NaN;
        this.y = Double.NaN;
    }

    public Vector(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void clear() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public boolean isNull() {
        return this.x == 0.0 && this.y == 0.0;
    }

    public Vector substract(Vector o) {
        Vector v = new Vector();
        v.x = this.x - o.x;
        v.y = this.y - o.y;
        return v;
    }

    public Vector add(Vector o) {
        Vector v = new Vector();
        v.x = this.x + o.x;
        v.y = this.y + o.y;
        return v;
    }

    public Vector multiply(double o) {
        Vector v = new Vector();
        v.x = this.x * o;
        v.y = this.y * o;
        return v;
    }

    public Vector divide(double o) {
        Vector v = new Vector();
        v.x = this.x / o;
        v.y = this.y / o;
        return v;
    }

    public double skalarProdukt(Vector o) {
        return this.x * o.x + this.y * o.y;
    }

    public double getLength() {
        return Math.sqrt(Math.pow(this.x, 2.0) + Math.pow(this.y, 2.0));
    }

    public double getAngelBetween(Vector o) {
        double skalarProduct = this.skalarProdukt(o);
        double t2 = Math.abs(this.getLength()) * Math.abs(o.getLength());
        return Math.acos(skalarProduct / t2);
    }

    public void print(String name) {
        System.out.println(String.format("%s --> x: %.1f y: %.1f", name, this.x, this.y));
    }

    public double getDirection() {
        double rad = Math.acos(this.y / this.getLength());
        if (this.x < 0.0) {
            rad = Math.PI * 2 - rad;
        }
        return rad;
    }

    public Vector turnByAngle(double angle) {
        Vector v = new Vector();
        v.x = this.x * Math.cos(angle) - this.y * Math.sin(angle);
        v.y = this.x * Math.sin(angle) + this.y * Math.cos(angle);
        return v;
    }
}

