/*
 * Decompiled with CFR 0.152.
 */
package nosteel.Modules.Stats;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import nosteel.Modules.Aiming;
import nosteel.Modules.Data.EnemyData;
import nosteel.Modules.Data.FiredBullet;
import nosteel.Modules.DataList;
import nosteel.Modules.Stats.HitRate;
import nosteel.Modules.Stats.Statistic;

public class BulletHitRate
extends Statistic {
    private List<HitRate> statData = new ArrayList<HitRate>();
    private static String[] colHeader = new String[]{"round", "enemy", "total", "on the way", "hit", "hit rate", "hit wrong", "missed", "missed rate", "Algo Linear Targeting", "Algo Pattern Match"};

    public BulletHitRate(DataList s, Aiming t) {
        super(s, t, BulletHitRate.class.getName());
    }

    @Override
    public void analyse() {
        this.statData.clear();
        ListIterator<EnemyData> it = this.scans.getEnemyListIterator(DataList.FRONT_OF_LIST);
        while (it.hasNext()) {
            EnemyData enemy = it.next();
            ListIterator<FiredBullet> fired = enemy.getFiredBulletIterator();
            HitRate h = new HitRate();
            h.name = enemy.getName();
            while (fired.hasNext()) {
                FiredBullet fb = fired.next();
                if (fb.isOnTheWay) {
                    h.bulletsOnTheWay += 1.0;
                } else if (fb.hitTheTarget) {
                    h.bulletsHit += 1.0;
                } else if (fb.hitAnotherTarget) {
                    h.bulletsHitWrong += 1.0;
                } else {
                    h.bulletsMissed += 1.0;
                }
                if (fb.aimingAlgo == Aiming.INDEX_LinearTargeting) {
                    h.algoLinerTargeting += 1.0;
                }
                if (fb.aimingAlgo != Aiming.INDEX_PatterMatch) continue;
                h.algoPatternMatch += 1.0;
            }
            this.statData.add(h);
        }
    }

    @Override
    public void printCsvHeadline() {
    }

    @Override
    public void printCsvRow(int round) {
    }

    @Override
    public void print() {
        for (HitRate h : this.statData) {
            System.out.println(String.format("%s total %.1f, hitrate: %.1f%%", h.name, h.getTotalNumberOfBullets(), h.getHitRate() * 100.0));
            System.out.println(h.toString());
        }
    }
}

