/*
 * Decompiled with CFR 0.152.
 */
package mb;

import mb.core.Coordinates;
import mb.guns.Gun;
import mb.movement.Movement;
import mb.radar.Radar;
import mb.utils.MathUtils;
import mb.utils.PaintUtils;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.CustomEvent;
import robocode.HitByBulletEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;

public abstract class MBRobot
extends AdvancedRobot {
    protected double enemyEnergy = 100.0;
    protected Gun gun;
    protected Radar radar;
    protected Movement movement;
    protected PaintUtils paintUtils;

    public void run() {
        this.paintUtils = new PaintUtils(this.getGraphics());
        this.init();
        this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        while (true) {
            this.setAdjustGunForRobotTurn(true);
            this.setAdjustRadarForRobotTurn(true);
            this.setAdjustRadarForRobotTurn(true);
            this.radar.run();
            this.scan();
        }
    }

    public void onBulletHit(BulletHitEvent event) {
        this.enemyEnergy -= Rules.getBulletDamage((double)event.getBullet().getPower());
        super.onBulletHit(event);
    }

    public void onHitByBullet(HitByBulletEvent event) {
        this.enemyEnergy += Rules.getBulletHitBonus((double)event.getPower());
        super.onHitByBullet(event);
    }

    public void onCustomEvent(CustomEvent event) {
        this.gun.onCustomEvent(event);
        this.radar.onCustomEvent(event);
        this.movement.onCustomEvent(event);
        super.onCustomEvent(event);
    }

    public Coordinates getMyCoordinates() {
        return new Coordinates(this.getX(), this.getY());
    }

    protected boolean hasEnemyFired(ScannedRobotEvent event) {
        return this.enemyEnergy - event.getEnergy() <= 3.0 && this.enemyEnergy - event.getEnergy() >= 0.1;
    }

    protected double getEnemyFirePower(ScannedRobotEvent event) {
        return this.enemyEnergy - event.getEnergy();
    }

    protected abstract void init();

    protected void paintVectors(ScannedRobotEvent event) {
        Coordinates enemy = MathUtils.getEnemyCoordinates(this.getMyCoordinates(), this.getHeading(), event.getBearing(), event.getDistance());
        this.paintUtils.paintVector(this.getMyCoordinates(), (this.getHeading() + event.getBearing()) % 360.0);
        this.paintUtils.paintVector(this.getMyCoordinates(), this.getHeading());
        this.paintUtils.paintVector(enemy, event.getHeading());
    }
}

