/*
 * Decompiled with CFR 0.152.
 */
package mb.core;

public class Coordinates {
    private double x;
    private double y;
    public double xmax = Double.MAX_VALUE;
    public double ymax = Double.MAX_VALUE;

    public Coordinates(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
        this.placeCoordInsideField();
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
        this.placeCoordInsideField();
    }

    public String toString() {
        return "Coordinates [x=" + this.x + ", y=" + this.y + "]";
    }

    public void Add(Coordinates toAdd) {
        this.x += toAdd.getX();
        this.y += toAdd.getY();
        this.placeCoordInsideField();
    }

    public double getDistanceTo(Coordinates otherCoordinate) {
        Coordinates diffVector = this.getDiffVector(otherCoordinate);
        double diffx = Math.abs(diffVector.getX());
        double diffy = Math.abs(diffVector.getY());
        double distance = Math.sqrt(diffx * diffx + diffy * diffy);
        return distance;
    }

    public Coordinates getDiffVector(Coordinates otherCoordinate) {
        double diffx = this.x - otherCoordinate.getX();
        double diffy = this.y - otherCoordinate.getY();
        Coordinates diffVector = new Coordinates(diffx, diffy);
        return diffVector;
    }

    private void placeCoordInsideField() {
        if (this.x < 0.0) {
            this.x = 0.0;
        }
        if (this.x > this.xmax) {
            this.x = this.xmax;
        }
        if (this.y < 0.0) {
            this.y = 0.0;
        }
        if (this.y > this.ymax) {
            this.y = this.ymax;
        }
    }
}

