/*
 * Decompiled with CFR 0.152.
 */
package rz;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Enumeration;
import java.util.Hashtable;
import robocode.AdvancedRobot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import rz.stuff.microEnemy;

public class HawkOnFire
extends AdvancedRobot {
    static final int m = 30;
    static Hashtable targets = new Hashtable();
    static microEnemy target = new microEnemy();
    static Point2D.Double myPos;
    static Point2D.Double lastPos;
    static double myEnergy;
    Point2D.Double next;

    public void run() {
        this.setColors(Color.black, Color.red, Color.orange);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        while (true) {
            myPos = new Point2D.Double(this.getX(), this.getY());
            myEnergy = this.getEnergy();
            if (HawkOnFire.target.live && this.getTime() > 9L) {
                this.doStuff();
            }
            this.execute();
        }
    }

    public void doStuff() {
        double d;
        int i = 0;
        Point2D.Double p = HawkOnFire.target.pos;
        double dist = myPos.distance(p);
        double angle = Math.min(Math.min(myEnergy / 6.0, 1300.0 / dist), HawkOnFire.target.energy / (double)3);
        if (this.getGunTurnRemaining() == 0.0 && myEnergy > 1.0) {
            this.setFire(angle);
        }
        this.setTurnGunLeftRadians(Utils.normalRelativeAngle((double)(this.getGunHeadingRadians() - HawkOnFire.calcAngle(p, myPos))));
        if (this.next == null) {
            this.next = lastPos = myPos;
        }
        angle = myPos.distance(this.next);
        if (d < 15.0) {
            angle = 1.0 - Math.rint(Math.pow(Math.random(), this.getOthers()));
            do {
                p = HawkOnFire.calcPoint(myPos, Math.min(dist * 0.8, 100.0 + 200.0 * Math.random()), Math.PI * 2 * Math.random());
                if (!new Rectangle2D.Double(30.0, 30.0, this.getBattleFieldWidth() - 60.0, this.getBattleFieldHeight() - 60.0).contains(p) || !(HawkOnFire.evaluate(p, angle) < HawkOnFire.evaluate(this.next, angle))) continue;
                this.next = p;
            } while (i++ < 100);
            lastPos = myPos;
        } else {
            double d2 = angle;
            angle = Utils.normalRelativeAngle((double)(HawkOnFire.calcAngle(this.next, myPos) - this.getHeadingRadians()));
            this.setAhead(d2 * (double)(angle == (angle = Math.atan(Math.tan(angle))) ? 1 : -1));
            this.setTurnRightRadians(angle);
            this.setMaxVelocity(Math.abs(angle) > 1.0 ? 0.0 : 8.0);
        }
    }

    public static double evaluate(Point2D.Double p, double addLast) {
        double eval = addLast * 0.08 / p.distanceSq(lastPos);
        Enumeration enumeration = targets.elements();
        while (enumeration.hasMoreElements()) {
            microEnemy en = (microEnemy)enumeration.nextElement();
            if (!en.live) continue;
            eval += Math.min(en.energy / myEnergy, (double)2) * (1.0 + Math.abs(Math.cos(HawkOnFire.calcAngle(myPos, p) - HawkOnFire.calcAngle(en.pos, p)))) / p.distanceSq(en.pos);
        }
        return eval;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        String eName;
        microEnemy en;
        if (this.getOthers() == 1) {
            this.setTurnRadarLeftRadians(this.getRadarTurnRemainingRadians());
        }
        if ((en = (microEnemy)targets.get(eName = e.getName())) == null) {
            en = new microEnemy();
            targets.put(eName, en);
        }
        en.name = eName;
        en.energy = e.getEnergy();
        en.live = true;
        en.pos = HawkOnFire.calcPoint(myPos, e.getDistance(), this.getHeadingRadians() + e.getBearingRadians());
        if (!HawkOnFire.target.live || e.getDistance() < myPos.distance(HawkOnFire.target.pos)) {
            target = en;
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        ((microEnemy)HawkOnFire.targets.get((Object)e.getName())).live = false;
    }

    private static final Point2D.Double calcPoint(Point2D.Double p, double dist, double ang) {
        return new Point2D.Double(p.x + dist * Math.sin(ang), p.y + dist * Math.cos(ang));
    }

    private static final double calcAngle(Point2D.Double p2, Point2D.Double p1) {
        return Math.atan2(p2.x - p1.x, p2.y - p1.y);
    }
}

