/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.gun;

import florent.XSeries.gun.FatalityGun;
import florent.XSeries.gun.GFGun;
import florent.XSeries.gun.GunStrategy;
import florent.XSeries.gun.GunType;
import florent.XSeries.gun.HeadOnGun;
import florent.XSeries.gun.LinearGun;
import florent.XSeries.gun.NullGun;
import florent.XSeries.gun.PatternMatchingGun;
import florent.XSeries.gun.TargetSelector;
import florent.XSeries.gun.power.MeleePower;
import florent.XSeries.gun.power.PowerManager;
import florent.XSeries.gun.power.StandardPower;
import florent.XSeries.radar.Tracker;
import florent.XSeries.team.Xmen;
import florent.XSeries.utils.RobocodeTools;
import java.util.EnumMap;
import robocode.AdvancedRobot;

public class GunFactory {
    private EnumMap<GunType, GunStrategy> strategies = new EnumMap(GunType.class);
    private Xmen me;
    private static GunFactory instance;
    static /* synthetic */ Class class$0;

    private GunFactory() {
    }

    public static GunFactory getInstance() {
        if (instance == null) {
            instance = new GunFactory();
        }
        return instance;
    }

    public GunStrategy getStrategy(GunType key) {
        GunStrategy strategy;
        if (this.strategies.containsKey((Object)key)) {
            return this.strategies.get((Object)key);
        }
        PowerManager power = this.me.getOthers() < 2 ? new StandardPower((AdvancedRobot)this.me) : new MeleePower((AdvancedRobot)this.me);
        switch (key) {
            case HEADONGUN: {
                strategy = new HeadOnGun((AdvancedRobot)this.me);
                this.strategies.put(key, strategy);
                strategy.setPower(power);
                strategy.selector = TargetSelector.getInstance(this.me, Tracker.getInstance());
                break;
            }
            case LINEARGUN: {
                strategy = new LinearGun((AdvancedRobot)this.me);
                this.strategies.put(key, strategy);
                strategy.setPower(power);
                strategy.selector = TargetSelector.getInstance(this.me, Tracker.getInstance());
                break;
            }
            case GFGUN: {
                strategy = new GFGun();
                this.strategies.put(key, strategy);
                strategy.setPower(power);
                break;
            }
            case NULLGUN: {
                strategy = new NullGun();
                this.strategies.put(key, strategy);
                break;
            }
            case FATALITYGUN: {
                strategy = new FatalityGun(this.me);
                this.strategies.put(key, strategy);
                strategy.setPower(power);
                break;
            }
            case PATTERNMATCHINGGUN: {
                strategy = new PatternMatchingGun(this.me);
                this.strategies.put(key, strategy);
                strategy.setPower(power);
                strategy.selector = TargetSelector.getInstance(this.me, Tracker.getInstance());
                break;
            }
            default: {
                RobocodeTools.log("Unknown key " + this.getClass().getName() + ":" + (Object)((Object)key));
                strategy = null;
            }
        }
        return strategy;
    }

    public void setMe(Xmen me) {
        this.me = me;
    }
}

