/*
 * Decompiled with CFR 0.152.
 */
package ags.muse.gun;

import ags.muse.gun.HitrateEstimator;
import ags.muse.gun.SWave;
import ags.util.StatMath;
import java.util.HashMap;
import robocode.Rules;

public class BulletPowerSelector {
    HitrateEstimator selfEstimator = new HitrateEstimator();
    HitrateEstimator enemyEstimator;

    public void setEnemyEstimator(HitrateEstimator enemyEstimator) {
        this.enemyEstimator = enemyEstimator;
    }

    public void waveEnd(SWave wave) {
        this.selfEstimator.waveEnd(wave.getHitRange().intersects(wave.getAimGF()), wave.getInitDistance(), wave.getSpeed());
    }

    public double getBestPower(double distance, double myEnergy, double myDamageTaken, double enemyEnergy, double enemyDamageTaken, double enemyFirepower, int enemyCoolticks) {
        if (enemyEnergy < 0.1) {
            return 0.1;
        }
        if (distance < 50.0) {
            return 3.0;
        }
        double bestPower = Double.NaN;
        double bestScore = Double.NEGATIVE_INFINITY;
        double pNeeded = Math.max(0.1, BulletPowerSelector.damageToBulletPower(enemyEnergy));
        int i = 2;
        while (i <= 60) {
            Estimation e;
            double score;
            double p = (double)i / 20.0;
            if (p > 3.0) {
                p = 3.0;
            }
            if ((score = (e = new Estimation(distance, p, enemyFirepower, enemyCoolticks)).estimateScore(myEnergy, myDamageTaken, enemyEnergy, enemyDamageTaken)) > bestScore) {
                bestScore = score;
                bestPower = p;
            }
            ++i;
        }
        return bestPower;
    }

    private static double damageToBulletPower(double energy) {
        if (energy / 4.0 <= 1.0) {
            return energy / 4.0;
        }
        return (energy + 2.0) / 6.0;
    }

    public void testEstimator() {
        long ot = System.nanoTime();
        int i = 2;
        while (i <= 60) {
            double myPower = (double)i / 20.0;
            double enemyPower = 0.09999999999999432;
            double myHitrate = 0.8823898603645636;
            double enemyHitrate = 0.8969126319398489;
            double myEnergy = 113.19999999999999;
            double enemyEnergy = 64.20000000000002;
            double myDamageTaken = 0.8000000000000019;
            double enemyDamageTaken = 36.0;
            Estimation e = new Estimation(myPower, myHitrate, enemyPower, enemyHitrate, 0);
            double score = e.estimateScore(myEnergy, myDamageTaken, enemyEnergy, enemyDamageTaken);
            System.out.println(String.valueOf(myPower) + " Test score: " + score);
            ++i;
        }
        System.out.println(System.nanoTime() - ot);
    }

    public static void main(String[] args) {
        BulletPowerSelector bps = new BulletPowerSelector();
        bps.testEstimator();
    }

    public class Estimation {
        HashMap<SimConfig, Double> cache = new HashMap();
        double myHitrate;
        double myDamage;
        double myPower;
        double enemyHitrate;
        double enemyDamage;
        double enemyPower;
        double myLossRate;
        double myKillRate;
        double enemyLossRate;
        double enemyKillRate;
        double myLossRateSD;
        double myKillRateSD;
        double enemyLossRateSD;
        double enemyKillRateSD;
        int enemyCoolticks;
        int enemyCooldown;
        int myCooldown;
        double distance;
        int chits;
        int cmiss;

        private Estimation(double distance, double myPower, double enemyPower, int enemyCoolticks) {
            this(myPower, bulletPowerSelector.selfEstimator.getHitrate(distance, myPower), enemyPower, bulletPowerSelector.enemyEstimator.getHitrate(distance, enemyPower), enemyCoolticks);
            this.distance = distance;
        }

        private Estimation(double myPower, double myHitrate, double enemyPower, double enemyHitrate, int enemyCoolticks) {
            this.enemyPower = enemyPower;
            this.enemyHitrate = Math.max(1.0E-4, enemyHitrate);
            this.enemyDamage = Rules.getBulletDamage((double)enemyPower);
            this.enemyCooldown = (int)Math.ceil(Rules.getGunHeat((double)enemyPower) / 0.1);
            this.enemyCoolticks = enemyCoolticks;
            this.myPower = myPower;
            this.myHitrate = Math.max(1.0E-4, myHitrate);
            this.myDamage = Rules.getBulletDamage((double)myPower);
            this.myCooldown = (int)Math.ceil(Rules.getGunHeat((double)myPower) / 0.1);
            double myLossBase = myPower / (double)this.myCooldown;
            this.myLossRate = myLossBase * (1.0 - 3.0 * myHitrate);
            this.myLossRateSD = myLossBase * myLossBase * 3.0 * 3.0 * (myHitrate * (1.0 - myHitrate));
            double myKillBase = this.myDamage / (double)this.myCooldown;
            this.myKillRate = myKillBase * myHitrate;
            this.myKillRateSD = myKillBase * myKillBase * (myHitrate * (1.0 - myHitrate));
            double enemyLossBase = enemyPower / (double)(this.enemyCooldown + enemyCoolticks);
            this.enemyLossRate = enemyLossBase * (1.0 - 3.0 * enemyHitrate);
            this.enemyLossRateSD = enemyLossBase * enemyLossBase * 3.0 * 3.0 * (enemyHitrate * (1.0 - enemyHitrate));
            double enemyKillBase = this.enemyDamage / (double)(this.enemyCooldown + enemyCoolticks);
            this.enemyKillRate = enemyKillBase * enemyHitrate;
            this.enemyKillRateSD = enemyKillBase * enemyKillBase * (enemyHitrate * (1.0 - enemyHitrate));
        }

        private double estimateScore(double myEnergy, double myDamageTaken, double enemyEnergy, double enemyDamageTaken) {
            return this.estimateScore(0, 1.0, myEnergy, 0, myDamageTaken, enemyEnergy, Math.max(1, this.enemyCooldown / 2), enemyDamageTaken);
        }

        private double estimateScore(int depth, double prob, double myEnergy, Integer myHeat, double myDamageTaken, double enemyEnergy, Integer enemyHeat, double enemyDamageTaken) {
            if (myHeat == null) {
                myEnergy = 0.0;
            }
            if (enemyHeat == null) {
                enemyEnergy = 0.0;
            }
            if (myEnergy == 0.0 || enemyEnergy == 0.0) {
                if (myEnergy == 0.0 && enemyEnergy == 0.0) {
                    double ret = 0.1 * enemyDamageTaken - 0.1 * myDamageTaken;
                    return ret;
                }
                if (enemyEnergy == 0.0) {
                    double ret = 60.0 + 0.2 * enemyDamageTaken;
                    return ret;
                }
                double ret = -60.0 - 0.2 * myDamageTaken;
                return ret;
            }
            if (prob < 0.005 || depth > 5) {
                double enemyTimeLeft;
                double myRate = this.myLossRate + this.enemyKillRate;
                double myRateSD = this.myLossRateSD + this.enemyKillRateSD;
                double enemyRate = this.enemyLossRate + this.myKillRate;
                double enemyRateSD = this.enemyLossRateSD + this.myKillRateSD;
                double myRating = myEnergy * enemyRate;
                double myRatingSD = myEnergy * myEnergy * enemyRateSD;
                double enemyRating = enemyEnergy * myRate;
                double enemyRatingSD = enemyEnergy * enemyEnergy * myRateSD;
                double ratingSum = myRating - enemyRating;
                double ratingSumSD = myRatingSD + enemyRatingSD;
                double myTimeLeft = myRate > 0.0 ? myEnergy / myRate : Double.POSITIVE_INFINITY;
                double expectedTimeLeft = Math.min(myTimeLeft, enemyTimeLeft = enemyRate > 0.0 ? enemyEnergy / enemyRate : Double.POSITIVE_INFINITY);
                if (Double.isInfinite(expectedTimeLeft)) {
                    expectedTimeLeft = 0.0;
                }
                double thisBulletScore = expectedTimeLeft * (this.myKillRate - this.enemyKillRate);
                double winChance = 1.0 - StatMath.phi(0.0, ratingSum, Math.sqrt(ratingSumSD));
                double h1 = (1.0 - winChance) * (-60.0 - 0.2 * (myDamageTaken += expectedTimeLeft * this.enemyKillRate));
                double h2 = winChance * (60.0 + 0.2 * (enemyDamageTaken += expectedTimeLeft * this.myKillRate));
                double ret = thisBulletScore + h1 + h2;
                return ret;
            }
            SimConfig conf = new SimConfig(myEnergy, myHeat, myDamageTaken, enemyEnergy, enemyHeat, enemyDamageTaken);
            Double cachevalue = this.cache.get(conf);
            if (cachevalue != null) {
                return cachevalue;
            }
            if (enemyHeat == null || myHeat <= enemyHeat) {
                double hitDamage = Math.min(enemyEnergy, this.myDamage);
                if (this.myPower < myEnergy) {
                    double hitProb = this.myHitrate;
                    enemyHeat = enemyHeat - myHeat;
                    myHeat = this.myCooldown;
                    double hitScore = hitDamage + this.estimateScore(depth + 1, prob * hitProb, (myEnergy -= this.myPower) + 3.0 * this.myPower, myHeat, myDamageTaken, enemyEnergy - hitDamage, enemyHeat, enemyDamageTaken + hitDamage);
                    double missScore = this.estimateScore(depth + 1, prob * (1.0 - hitProb), myEnergy, myHeat, myDamageTaken, enemyEnergy, enemyHeat, enemyDamageTaken);
                    double ret = hitScore * hitProb + missScore * (1.0 - hitProb);
                    this.cache.put(conf, ret);
                    return ret;
                }
                myHeat = null;
                double ret = this.estimateScore(depth + 1, prob, myEnergy, myHeat, myDamageTaken, enemyEnergy, enemyHeat, enemyDamageTaken);
                this.cache.put(conf, ret);
                return ret;
            }
            enemyHeat = this.enemyCooldown + this.enemyCoolticks;
            double hitDamage = Math.min(myEnergy, this.enemyDamage);
            if (this.enemyPower < enemyEnergy) {
                double hitProb = this.enemyHitrate;
                myHeat = myHeat - enemyHeat;
                enemyHeat = this.enemyCooldown + this.enemyCoolticks;
                double hitScore = -hitDamage + this.estimateScore(depth + 1, prob * hitProb, myEnergy - hitDamage, myHeat, myDamageTaken + hitDamage, (enemyEnergy -= this.enemyPower) + 3.0 * this.enemyPower, enemyHeat, enemyDamageTaken);
                double missScore = this.estimateScore(depth + 1, prob * (1.0 - hitProb), myEnergy, myHeat, myDamageTaken, enemyEnergy, enemyHeat, enemyDamageTaken);
                double ret = hitScore * hitProb + missScore * (1.0 - hitProb);
                this.cache.put(conf, ret);
                return ret;
            }
            enemyHeat = null;
            double ret = this.estimateScore(depth + 1, prob, myEnergy, myHeat, myDamageTaken, enemyEnergy, enemyHeat, enemyDamageTaken);
            this.cache.put(conf, ret);
            return ret;
        }

        private class SimConfig {
            private final double myEnergy;
            private final double myDamageTaken;
            private final double enemyEnergy;
            private final double enemyDamageTaken;
            private final Integer myHeat;
            private final Integer enemyHeat;
            private final int hash;

            private SimConfig(double myEnergy, Integer myHeat, double myDamageTaken, double enemyEnergy, Integer enemyHeat, double enemyDamageTaken) {
                this.myEnergy = myEnergy;
                this.myHeat = myHeat;
                this.myDamageTaken = myDamageTaken;
                this.enemyEnergy = enemyEnergy;
                this.enemyHeat = enemyHeat;
                this.enemyDamageTaken = enemyDamageTaken;
                long longhash = Double.doubleToRawLongBits(myEnergy) ^ Double.doubleToRawLongBits(myDamageTaken) ^ Double.doubleToRawLongBits(enemyEnergy) ^ Double.doubleToRawLongBits(enemyDamageTaken) + (long)(myHeat != null ? myHeat.hashCode() : -1) + (long)(enemyHeat != null ? enemyHeat.hashCode() : -2);
                this.hash = (int)longhash ^ (int)Long.reverse(longhash);
            }

            public int hashCode() {
                return this.hash;
            }

            public boolean equals(Object o) {
                if (!(o instanceof SimConfig)) {
                    return false;
                }
                SimConfig s = (SimConfig)o;
                if (this.myEnergy != s.myEnergy) {
                    return false;
                }
                if (this.enemyEnergy != s.enemyEnergy) {
                    return false;
                }
                if (this.myDamageTaken != s.myDamageTaken) {
                    return false;
                }
                if (this.enemyDamageTaken != s.enemyDamageTaken) {
                    return false;
                }
                if (this.myHeat != s.myHeat) {
                    return false;
                }
                return this.enemyHeat == s.enemyHeat;
            }
        }
    }
}

