/*
 * Decompiled with CFR 0.152.
 */
package gu;

import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public final class MicroScoob
extends AdvancedRobot {
    private static double angle = 0.4;
    private static double eX;
    private static double eY;
    private static double dir;
    private static long[][][] guessFactors;
    private static RoundRectangle2D field;
    private static final double VELOCITY = 11.0;
    private static final double MAXANGLE = 0.8145454545454547;
    private static final double POWER = 3.0;

    static {
        dir = 1.0;
        guessFactors = new long[3][6][27];
    }

    public final void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        field = new RoundRectangle2D.Double(19.0, 19.0, this.getBattleFieldWidth() - 38.0, this.getBattleFieldHeight() - 38.0, 114.59155902616465, 114.59155902616465);
        while (true) {
            this.turnRadarRightRadians(Math.PI);
        }
    }

    public final void onScannedRobot(ScannedRobotEvent e) {
        double d;
        double d2;
        double targetY;
        double dVar2;
        double targetX;
        double d3;
        double absBearing = Utils.normalRelativeAngle((double)(e.getBearingRadians() + this.getHeadingRadians()));
        this.setTurnRadarRightRadians(Math.sin(absBearing - this.getRadarHeadingRadians()) * 100.0);
        double dVar1 = e.getDistance();
        if (Math.random() < 11.0 / d3) {
            angle = -angle;
        }
        int distIndex = (int)dVar1 / 250;
        double myX = this.getX();
        double myY = this.getY();
        eX = myX + Math.sin(absBearing) * dVar1;
        eY = myY + Math.cos(absBearing) * dVar1;
        double dVar3 = Utils.normalRelativeAngle((double)(absBearing + Math.PI)) + angle;
        int tries = 0;
        do {
            dVar2 = dVar1 * (1.2 - (double)tries / 100.0);
        } while (!field.contains(targetX = eX + Math.sin(dVar3) * dVar2, targetY = eY + Math.cos(dVar3) * dVar2) && ++tries < 100);
        dVar1 = Point2D.distance(myX, myY, targetX, targetY);
        dVar2 = Utils.normalRelativeAngle((double)(Math.atan2(targetX - myX, targetY - myY) - this.getHeadingRadians()));
        if (Math.abs(d2) > 1.5707963267948966) {
            dVar2 = Utils.normalRelativeAngle((double)(dVar2 + Math.PI));
            dVar1 = -dVar1;
        }
        this.setTurnRightRadians(dVar2);
        if (Math.abs(dVar2) > 0.5235987755982988) {
            dVar1 = 0.0;
        }
        this.setAhead(dVar1);
        dVar1 = e.getVelocity();
        if (dVar1 != 0.0) {
            dir = Math.sin(e.getHeadingRadians() - absBearing) * dVar1 < 0.0 ? -1.0 : 1.0;
        }
        int veloIndex = 0;
        dVar1 = Math.abs(dVar1);
        if (d > 0.5) {
            veloIndex = 1;
        }
        if (dVar1 > 7.5) {
            veloIndex = 2;
        }
        this.addCustomEvent(new VWave(myX, myY, absBearing, veloIndex, distIndex));
        int bestIndex = 13;
        long highest = 0L;
        tries = 27;
        while (--tries > 0) {
            if (guessFactors[veloIndex][distIndex][tries] <= highest) continue;
            bestIndex = tries;
            highest = guessFactors[veloIndex][distIndex][bestIndex];
        }
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absBearing - this.getGunHeadingRadians() + ((double)bestIndex - 13.0) / 13.0 * dir * 0.8145454545454547)));
        this.setFire(3.0);
    }

    public final class VWave
    extends Condition {
        private double spawnX;
        private double spawnY;
        private double spawnEBearing;
        private int spawnEVelocityIndex;
        private int spawnEDistanceIndex;
        private double spawnEDirection;
        private long spawnTime;

        public VWave(double x, double y, double absB, int velI, int distI) {
            this.spawnX = x;
            this.spawnY = y;
            this.spawnEBearing = absB;
            this.spawnEVelocityIndex = velI;
            this.spawnEDistanceIndex = distI;
            this.spawnEDirection = dir;
            this.spawnTime = MicroScoob.this.getTime() - 1L;
        }

        public final boolean test() {
            if ((double)(MicroScoob.this.getTime() - this.spawnTime) * 11.0 >= Point2D.distance(this.spawnX, this.spawnY, eX, eY)) {
                long[] lArray = guessFactors[this.spawnEVelocityIndex][this.spawnEDistanceIndex];
                int n = (int)Math.round(Math.min(Math.max(Utils.normalRelativeAngle((double)(Math.atan2(eX - this.spawnX, eY - this.spawnY) - this.spawnEBearing)) * this.spawnEDirection / 0.8145454545454547, -1.0), 1.0) * 13.0) + 13;
                lArray[n] = lArray[n] + 1L;
                MicroScoob.this.removeCustomEvent(this);
            }
            return false;
        }
    }
}

