/*
 * Decompiled with CFR 0.152.
 */
package synnalagma;

import java.awt.Color;
import java.util.Iterator;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.RadarTurnCompleteCondition;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import synnalagma.BulletTracker;
import synnalagma.Ennemi;
import synnalagma.EnnemiBullets;
import synnalagma.EnnemiManager;
import synnalagma.Point;
import synnalagma.RobotMath;
import synnalagma.mouvement.MouvementManager;
import synnalagma.mouvement.MoveCondition;
import synnalagma.shooting.VirtualBulletManager;

public abstract class RobotBase
extends AdvancedRobot {
    public static RobotBase monRobot;
    private int radarDirection = 1;
    private double battleWidth = 0.0;
    private double battleHeigth = 0.0;
    private double lastHeading = 0.0;
    public double HeadingCgt = 0.0;
    public double velocity = 0.0;
    public Ennemi singleTarget;
    public boolean MELEE = true;
    public double lastTurn = 0.0;

    public double bearingTo(double d, double d2) {
        return RobotMath.NormaliseHeading(Math.atan2(d - this.getX(), d2 - this.getY()));
    }

    public double bearingTo(Point point) {
        return RobotMath.NormaliseHeading(Math.atan2(point.x - this.getX(), point.y - this.getY()));
    }

    public abstract void customEventRecu(CustomEvent var1);

    public double distanceTo(double d, double d2) {
        double d3 = this.getX() - d;
        double d4 = this.getY() - d2;
        return Math.sqrt(d3 * d3 + d4 * d4);
    }

    public double distanceTo(Point point) {
        double d = this.getX() - point.x;
        double d2 = this.getY() - point.y;
        return Math.sqrt(d * d + d2 * d2);
    }

    public void goTo(double d, double d2) {
        double d3 = this.distanceTo(d, d2);
        double d4 = this.bearingTo(d, d2);
        int n = this.turnTo(d4);
        this.setAhead(d3 * (double)n);
    }

    public void goToDirection(double d, double d2, double d3) {
        double d4 = this.bearingTo(d, d2);
        int n = this.turnTo(d4);
        this.setAhead(d3 * (double)n);
    }

    public void manageEvents() {
        Iterator iterator = this.getAllEvents().iterator();
        while (iterator.hasNext()) {
            Event event = (Event)iterator.next();
            this.out.println(event.getClass().getName());
            if (event instanceof ScannedRobotEvent) {
                this.onScannedRobot((ScannedRobotEvent)event);
                continue;
            }
            if (event instanceof HitByBulletEvent) {
                this.onHitByBullet((HitByBulletEvent)event);
                continue;
            }
            if (event instanceof SkippedTurnEvent) {
                this.out.println(event.toString());
                continue;
            }
            if (!(event instanceof CustomEvent)) continue;
            this.onCustomEvent((CustomEvent)event);
        }
    }

    public abstract void move();

    public double myGetBattleFieldHeight() {
        return this.battleHeigth;
    }

    public double myGetBattleFieldWidth() {
        return this.battleWidth;
    }

    public abstract void newTurn();

    public void onCustomEvent(CustomEvent customEvent) {
        if (customEvent.getCondition() instanceof BulletTracker) {
            BulletTracker bulletTracker = (BulletTracker)customEvent.getCondition();
            Ennemi ennemi = EnnemiManager.getInstance().getEnnemi(bulletTracker.getTarget());
            if (ennemi != null) {
                MouvementManager.getInstance().update(bulletTracker);
                ennemi.bulletEvent(bulletTracker);
            }
        } else if (customEvent.getCondition() instanceof RadarTurnCompleteCondition) {
            this.sweep();
        } else if (customEvent.getCondition() instanceof MoveCondition) {
            this.move();
        } else {
            this.customEventRecu(customEvent);
        }
    }

    public void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
        MouvementManager.getInstance().update(hitByBulletEvent);
        Ennemi ennemi = EnnemiManager.getInstance().getEnnemi(hitByBulletEvent.getName());
        if (ennemi != null) {
            ennemi.touche(hitByBulletEvent);
        }
    }

    public void onRobotDeath(RobotDeathEvent robotDeathEvent) {
        Ennemi ennemi = EnnemiManager.getInstance().getEnnemi(robotDeathEvent.getName());
        boolean bl = this.MELEE = this.getOthers() != 1;
        if (ennemi != null) {
            ennemi.died();
            EnnemiManager.getInstance().update();
        }
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        EnnemiManager.getInstance().actualise(scannedRobotEvent);
    }

    public void run() {
        this.initialise();
        this.customInit();
        while (true) {
            this.baseTurn();
            this.manageEvents();
            EnnemiBullets.getInstance().newTurn();
            VirtualBulletManager.getInstance().newTurn();
            this.newTurn();
            this.execute();
        }
    }

    public void baseTurn() {
        double d = (double)this.getTime() - this.lastTurn;
        this.lastTurn = this.getTime();
        this.velocity = (this.velocity * 3.0 + this.getVelocity()) / 4.0;
        this.HeadingCgt = (this.HeadingCgt * 3.0 + RobotMath.NormaliseBearing(this.getHeadingRadians() - this.lastHeading)) / 4.0;
        this.lastHeading = this.getHeadingRadians();
    }

    public int turnTo(double d) {
        int n;
        double d2 = RobotMath.NormaliseBearing(d - this.getHeadingRadians());
        if (d2 > 1.5707963267948966) {
            d2 -= Math.PI;
            n = -1;
        } else if (d2 < -1.5707963267948966) {
            d2 += Math.PI;
            n = -1;
        } else {
            n = 1;
        }
        this.setTurnRightRadians(d2);
        return n;
    }

    protected abstract void customInit();

    protected void initialise() {
        monRobot = this;
        this.battleHeigth = super.getBattleFieldHeight();
        this.battleWidth = super.getBattleFieldWidth();
        this.MELEE = this.getOthers() != 1;
        this.addCustomEvent((Condition)new RadarTurnCompleteCondition((AdvancedRobot)this));
        this.setColors(Color.red, Color.blue, Color.green);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setTurnRadarLeft(360.0);
        EnnemiManager.getInstance().reinitialize();
        EnnemiBullets.reinitialize();
        VirtualBulletManager.getInstance().reinitialize();
        this.move();
    }

    private void sweep() {
        if (this.MELEE) {
            double d = 0.0;
            double d2 = 0.0;
            int n = 0;
            EnnemiManager.EnnemiEnumeration ennemiEnumeration = EnnemiManager.getInstance().getAllAlives();
            while (ennemiEnumeration.hasMoreElements()) {
                Ennemi ennemi = ennemiEnumeration.next();
                if (!ennemi.isUpdated()) continue;
                double d3 = RobotMath.NormaliseBearing(RobotMath.NormaliseHeading(this.bearingTo(ennemi) - this.getRadarHeadingRadians()));
                if (Math.abs(d3) > d) {
                    d = Math.abs(d3);
                    d2 = d3;
                }
                ++n;
            }
            double d4 = d2 + (double)RobotMath.sign(d2) * Math.PI / 8.0;
            if (n < this.getOthers()) {
                d4 = Math.PI * (double)this.radarDirection;
            }
            this.setTurnRadarRightRadians(d4);
            this.radarDirection = RobotMath.sign(d4);
        } else {
            Ennemi ennemi = null;
            if (EnnemiManager.getInstance().getAllAlives().hasMoreElements()) {
                ennemi = EnnemiManager.getInstance().getAllAlives().next();
            }
            double d = 0.05;
            if (ennemi == null || !ennemi.isUpdated()) {
                this.setTurnRadarRightRadians(0.7853981633974483);
            } else {
                double d5 = RobotMath.NormaliseBearing(this.bearingTo(ennemi) - this.getRadarHeadingRadians());
                d5 = d5 < 0.0 ? (d5 -= d) : (d5 += d);
                this.setTurnRadarRightRadians(d5);
            }
        }
    }

    public Point getMaxPoint(double d, Ennemi ennemi) {
        double d2 = this.getVelocity();
        double d3 = this.getHeadingRadians();
        double d4 = d3 - (ennemi.bearingTo(this.getX(), this.getY()) - 1.5707963267948966);
        if (d4 > 1.5707963267948966) {
            d4 -= Math.PI;
        } else if (d4 < -1.5707963267948966) {
            d4 += Math.PI;
        }
        int n = RobotMath.sign(d4);
        double d5 = this.getX();
        double d6 = this.getY();
        double d7 = 0.0;
        while (d > 0.0) {
            d2 = d2 >= 0.0 ? Math.min(8.0, d2 + 1.0) : (d2 += 2.0);
            if (RobotMath.sign(d4) == n) {
                d7 = (double)n * Math.toRadians(10.0 - Math.abs(d2) * 0.75);
                d3 -= d7;
                d4 -= d7;
            }
            d5 += Math.sin(d3) * d2;
            d6 += Math.cos(d3) * d2;
            d -= 1.0;
        }
        return new Point(d5, d6, 0.0);
    }

    public Point getMinPoint(double d, Ennemi ennemi) {
        double d2 = this.getVelocity();
        double d3 = this.getHeadingRadians();
        double d4 = d3 - (ennemi.bearingTo(this.getX(), this.getY()) - 1.5707963267948966);
        if (d4 > 1.5707963267948966) {
            d4 -= Math.PI;
        } else if (d4 < -1.5707963267948966) {
            d4 += Math.PI;
        }
        int n = RobotMath.sign(d4);
        double d5 = this.getX();
        double d6 = this.getY();
        double d7 = 0.0;
        while (d > 0.0) {
            d2 = d2 <= 0.0 ? Math.max(-8.0, d2 - 1.0) : (d2 -= 2.0);
            if (RobotMath.sign(d4) == n) {
                d7 = (double)n * Math.toRadians(10.0 - Math.abs(d2) * 0.75);
                d3 -= d7;
                d4 -= d7;
            }
            d5 += Math.sin(d3) * d2;
            d6 += Math.cos(d3) * d2;
            d -= 1.0;
        }
        return new Point(d5, d6, 0.0);
    }
}

