/*
 * Decompiled with CFR 0.152.
 */
package synnalagma.neural;

import synnalagma.neural.Layer;
import synnalagma.neural.Link;

public abstract class Node {
    protected int nn;
    protected int nlyr;
    protected float inp;
    protected float outb;
    protected float out;
    protected float err;
    protected float errb;
    protected Link[] lnk;
    protected Node[] ngb;

    protected abstract void trf();

    protected void out() {
        this.out = this.outb;
        this.outb = 0.0f;
    }

    protected abstract void ebp(boolean var1, float var2, float var3);

    protected void err() {
        this.err = this.errb;
        this.errb = 0.0f;
    }

    public Node(int n, int n2, float f) {
        this.nn = n;
        this.nlyr = n2;
        this.lnk = new Link[1];
        this.lnk[0] = new Link(f, null);
        this.ngb = null;
    }

    void nodelink(int n, int n2, Layer layer, float[] fArray) {
        int n3 = this.lnk.length;
        Link[] linkArray = new Link[n2 + n3];
        System.arraycopy(this.lnk, 0, linkArray, 0, n3);
        this.lnk = linkArray;
        int n4 = 0;
        while (n4 < n2) {
            this.lnk[n4 + n3] = new Link(fArray[n4], layer.node[n4 + n]);
            ++n4;
        }
    }

    protected float Wgt(int n) {
        return this.lnk[n].wgt;
    }

    protected float Wgtb(int n) {
        return this.lnk[n].wgtb;
    }

    protected void sWgt(int n, float f) {
        this.lnk[n].wgt = f;
    }

    protected void sWgtb(int n, float f) {
        this.lnk[n].wgtb = f;
    }

    protected Node Nfrom(int n) {
        return this.lnk[n].nfrom;
    }

    protected float outNfrom(int n) {
        return this.lnk[n].nfrom.out;
    }

    protected float errbNfrom(int n) {
        return this.lnk[n].nfrom.errb;
    }

    protected void serrbNfrom(int n, float f) {
        this.lnk[n].nfrom.errb = f;
    }

    protected int Nnumfrom(int n) {
        return this.lnk[n].nfrom.nn;
    }

    protected int Lnumfrom(int n) {
        return this.lnk[n].nfrom.nlyr;
    }

    protected Node Nneigh(int n) {
        return this.ngb[n];
    }

    protected int Nn() {
        return this.nn;
    }

    protected int Nl() {
        return this.nlyr;
    }

    protected float Out() {
        return this.out;
    }

    protected void sInp(float f) {
        this.inp = f;
    }
}

