/*
 * Decompiled with CFR 0.152.
 */
package synnalagma.shooting;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import synnalagma.BulletTracker;
import synnalagma.Ennemi;
import synnalagma.Point;
import synnalagma.RobotBase;
import synnalagma.RobotMath;
import synnalagma.ShootStat;
import synnalagma.neural.NNet;
import synnalagma.shooting.NeuralInfo;
import synnalagma.shooting.ShootTactique;
import synnalagma.shooting.VirtualBullet;
import synnalagma.shooting.VirtualBulletManager;

public abstract class NeuralShoot
implements ShootTactique {
    public static float learningRate = 0.3f;
    public static float momentum = 0.3f;
    public static boolean trainBias = true;
    protected Ennemi target;
    protected ShootStat stat = new ShootStat();
    protected NNet nnet;
    protected double[] solutions;
    protected double[] angleMinMax;
    protected int[][] info;
    protected double shootB = 0.0;
    protected Hashtable buffer = new Hashtable();
    double mean = 0.0;
    double shoot = 0.0;
    double error = 0.0;
    protected static final int TRAIN_SIZE = 10;
    protected NeuralInfo[] trainingSet = new NeuralInfo[10];
    protected int trainIndex = 0;

    protected NeuralShoot(Ennemi ennemi, int n) {
        this.solutions = new double[n];
        this.angleMinMax = new double[3];
        this.info = new int[n][1];
        this.target = ennemi;
    }

    protected void setNNStruct(String[] stringArray) {
        this.nnet = new NNet(stringArray);
    }

    public abstract NeuralInfo getInfo();

    public abstract int getOSize();

    public ShootStat getStat() {
        return this.stat;
    }

    public boolean isValid() {
        return true;
    }

    public boolean disable() {
        return true;
    }

    public boolean enable() {
        return true;
    }

    public boolean aim(double d) {
        Point point = this.target;
        Point point2 = this.target;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 20.0 - 3.0 * d;
        int n = 0;
        while (n < 3) {
            double d5 = RobotBase.monRobot.distanceTo(point2) / d4;
            double d6 = RobotBase.monRobot.distanceTo(point) / d4;
            point2 = this.target.getMinPoint(d5);
            point = this.target.getMaxPoint(d6);
            ++n;
        }
        d3 = RobotMath.NormaliseHeading(RobotBase.monRobot.bearingTo(point2));
        d2 = RobotMath.NormaliseHeading(RobotBase.monRobot.bearingTo(point));
        this.angleMinMax = new double[3];
        this.angleMinMax[0] = d3;
        this.angleMinMax[1] = d2;
        double d7 = d2 - d3;
        if (Math.abs(d7) > Math.PI) {
            d7 = d2 > d3 ? -(Math.PI * 2 - d2 + d3) : Math.PI * 2 - d3 + d2;
        }
        this.angleMinMax[2] = d7;
        double d8 = d7 / (double)this.getOSize();
        double d9 = d3;
        this.info = new int[this.getOSize()][1];
        int n2 = 0;
        while (n2 < this.getOSize()) {
            this.solutions[n2] = d9;
            this.info[n2][0] = n2;
            d9 = RobotMath.NormaliseHeading(d9 + d8);
            ++n2;
        }
        NeuralInfo neuralInfo = this.getInfo();
        this.buffer.put(new Long(RobotBase.monRobot.getTime()), neuralInfo);
        float[] fArray = new float[this.getOSize()];
        this.nnet.frwNNet(neuralInfo.getInput(), fArray);
        double d10 = NeuralShoot.mean(fArray);
        if (d10 == -1.0) {
            d10 = NeuralShoot.max(fArray);
        }
        this.mean = (d10 + this.shoot * this.mean) / (this.shoot + 1.0);
        this.shoot += 1.0;
        this.error += Math.abs(d10 - this.mean);
        this.shootB = RobotMath.NormaliseHeading(d3 + d10 * d8);
        return true;
    }

    public boolean shoot(double d) {
        double d2 = RobotMath.NormaliseBearing(this.shootB - RobotBase.monRobot.getGunHeadingRadians());
        RobotBase.monRobot.setTurnGunRightRadians(d2);
        long l = RobotBase.monRobot.getTime();
        if (!(Math.abs(RobotBase.monRobot.getGunTurnRemaining()) < 3.0)) {
            return false;
        }
        new BulletTracker(this.target.getName(), RobotBase.monRobot.setFireBullet(d), this, this.info[0], this.angleMinMax, l);
        int n = 0;
        while (n < this.getOSize()) {
            VirtualBulletManager.getInstance().add(new VirtualBullet(RobotBase.monRobot.getX(), RobotBase.monRobot.getY(), d, this.solutions[n], this, this.info[n], this.target, this.angleMinMax, l));
            ++n;
        }
        return true;
    }

    public boolean virtualShoot(double d) {
        return true;
    }

    public void update(BulletTracker bulletTracker) {
        this.stat.update(bulletTracker);
    }

    public void update(VirtualBullet virtualBullet) {
        Long l = new Long(virtualBullet.timeOfShoot);
        NeuralInfo neuralInfo = (NeuralInfo)this.buffer.get(l);
        float f = 0.0f;
        if (virtualBullet.state == 1) {
            f = 1.0f;
        }
        if (neuralInfo.addShoot(virtualBullet.additionnalInfo[0], f)) {
            this.nnet.ebplearnNNet(neuralInfo.getInput(), neuralInfo.getOutput());
            this.buffer.remove(l);
            this.trainingSet[this.trainIndex] = neuralInfo;
            ++this.trainIndex;
            if (this.trainIndex == 10) {
                this.trainIndex = 0;
                int n = 0;
                while (n < 10) {
                    int n2 = 0;
                    while (n2 < 10) {
                        this.nnet.ebplearnNNet(this.trainingSet[n2].getInput(), this.trainingSet[n2].getOutput());
                        ++n2;
                    }
                    ++n;
                }
                Arrays.fill(this.trainingSet, null);
            }
        }
    }

    public Ennemi getTarget() {
        return this.target;
    }

    public void save(DataOutputStream dataOutputStream) {
        try {
            this.nnet.save(dataOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void load(DataInputStream dataInputStream) {
        try {
            this.nnet = new NNet(dataInputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public int compareTo(Object object) {
        if (object instanceof ShootTactique) {
            return (int)((double)this.getStat().reussite() * 1000.0) - (int)((double)((ShootTactique)object).getStat().reussite() * 1000.0);
        }
        return 0;
    }

    public static float mean(float[] fArray) {
        float f = 0.0f;
        int n = 0;
        int n2 = 0;
        while (n2 < fArray.length) {
            if ((double)fArray[n2] > 0.5) {
                f += (float)n2;
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return -1.0f;
        }
        return f /= (float)n;
    }

    public static float max(float[] fArray) {
        float f = 0.0f;
        float f2 = 0.0f;
        int n = 0;
        while (n < fArray.length) {
            if (fArray[n] > f2) {
                f = n;
                f2 = fArray[n];
            }
            ++n;
        }
        return f;
    }

    public String toString() {
        return this.getClass().getName() + " " + this.stat.toString() + "\n Moyenne " + this.mean + " sur " + this.shoot + " shoot, Erreur moy " + this.error / this.shoot;
    }
}

