/*
 * Decompiled with CFR 0.152.
 */
package fowl3628800.modules;

import fowl3628800.ModularBot;
import fowl3628800.modules.Module;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import robocode.AdvancedRobot;
import robocode.BattleEndedEvent;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.KeyEvent;
import robocode.MouseEvent;
import robocode.RobotDeathEvent;
import robocode.RoundEndedEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.StatusEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class WaveSurfingModule
implements Module {
    ModularBot bot;
    public static int BINS = 47;
    public static double[] _surfStats = new double[BINS];
    public Point2D.Double _myLocation;
    public Point2D.Double _enemyLocation;
    public Point2D.Double _lastGoToLocation;
    public ArrayList<EnemyWave> _enemyWaves;
    public ArrayList<Integer> _surfDirections;
    public ArrayList<Double> _surfAbsBearings;
    public static double _oppEnergy = 100.0;

    public WaveSurfingModule(ModularBot bot) {
        this.bot = bot;
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100.0);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(100.0);
        }
    }

    public void updateWaves() {
        int x = 0;
        while (x < this._enemyWaves.size()) {
            EnemyWave ew = this._enemyWaves.get(x);
            ew.distanceTraveled = (double)(this.bot.getTime() - ew.fireTime) * ew.bulletVelocity;
            if (ew.distanceTraveled > this._myLocation.distance(ew.fireLocation) + 50.0) {
                this._enemyWaves.remove(x);
                --x;
            }
            ++x;
        }
    }

    @Override
    public void preRun() {
        this._enemyWaves = new ArrayList();
        this._surfDirections = new ArrayList();
        this._surfAbsBearings = new ArrayList();
    }

    @Override
    public void run() {
    }

    private void goTo(Point2D.Double destination) {
        Point2D.Double location = new Point2D.Double(this.bot.getX(), this.bot.getY());
        double distance = location.distance(destination);
        double angle = Utils.normalRelativeAngle((double)(WaveSurfingModule.absoluteBearing(location, destination) - this.bot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            distance = -distance;
            angle = angle > 0.0 ? (angle -= Math.PI) : (angle += Math.PI);
        }
        this.bot.setTurnRightRadians(angle * (double)Math.signum(Math.abs((int)distance)));
        this.bot.setAhead(distance);
    }

    public static int getFactorIndex(EnemyWave ew, Point2D.Double targetLocation) {
        double offsetAngle = WaveSurfingModule.absoluteBearing(ew.fireLocation, targetLocation) - ew.directAngle;
        double factor = Utils.normalNearAbsoluteAngle((double)offsetAngle) / 360.0;
        return (int)WaveSurfingModule.limit(0.0, factor * (double)((BINS - 1) / 2) + (double)((BINS - 1) / 2), BINS - 1);
    }

    public void logHit(EnemyWave ew, Point2D.Double targetLocation) {
        int index = WaveSurfingModule.getFactorIndex(ew, targetLocation);
        int x = 0;
        while (x < BINS) {
            int n = x;
            _surfStats[n] = _surfStats[n] + 1.0 / (Math.pow(index - x, 2.0) + 1.0);
            ++x;
        }
    }

    public int getTimeTillHit(EnemyWave ew) {
        return (int)((this._myLocation.distance(ew.fireLocation) - ew.distanceTraveled) / ew.bulletVelocity);
    }

    public EnemyWave getClosestSurfableWave() {
        double nextHit = Double.POSITIVE_INFINITY;
        EnemyWave surfWave = null;
        int x = 0;
        while (x < this._enemyWaves.size()) {
            EnemyWave ew = this._enemyWaves.get(x);
            double distance = this._myLocation.distance(ew.fireLocation) - ew.distanceTraveled;
            double timeTillHit = distance / ew.bulletVelocity;
            if (distance > ew.bulletVelocity && timeTillHit < nextHit) {
                surfWave = ew;
                nextHit = timeTillHit;
            }
            ++x;
        }
        return surfWave;
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
        this._myLocation = new Point2D.Double(this.bot.getX(), this.bot.getY());
        double lateralVelocity = this.bot.getVelocity() * Math.sin(e.getBearingRadians());
        double absBearing = e.getBearingRadians() + this.bot.getHeadingRadians();
        this.bot.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(absBearing - this.bot.getRadarHeadingRadians())) * 2.0);
        this._surfDirections.add(0, new Integer(lateralVelocity >= 0.0 ? 1 : -1));
        this._surfAbsBearings.add(0, new Double(absBearing + Math.PI));
        double bulletPower = _oppEnergy - e.getEnergy();
        if (bulletPower < 3.01 && bulletPower > 0.09 && this._surfDirections.size() > 2) {
            EnemyWave ew = new EnemyWave();
            ew.fireTime = this.bot.getTime() - 1L;
            ew.bulletVelocity = WaveSurfingModule.bulletVelocity(bulletPower);
            ew.distanceTraveled = WaveSurfingModule.bulletVelocity(bulletPower);
            ew.direction = this._surfDirections.get(2);
            ew.directAngle = this._surfAbsBearings.get(2);
            ew.fireLocation = (Point2D.Double)this._enemyLocation.clone();
            this._enemyWaves.add(ew);
        }
        _oppEnergy = e.getEnergy();
        this._enemyLocation = WaveSurfingModule.project(this._myLocation, absBearing, e.getDistance());
        this.updateWaves();
        this.doSurfing();
    }

    public double binToDeg(int bin, EnemyWave ew) {
        double angle = 360.0 / (double)BINS;
        angle *= (double)bin;
        angle += Math.toDegrees(ew.directAngle);
        angle += 180.0;
        angle = Utils.normalAbsoluteAngleDegrees((double)angle);
        return angle;
    }

    public double binToRad(int bin, EnemyWave ew) {
        return Math.toRadians(this.binToDeg(bin, ew));
    }

    public double robotRange(int ticks) {
        double range = 0.0;
        int i = 0;
        while (i < ticks) {
            range += WaveSurfingModule.limit(0.0, i, 8.0);
            ++i;
        }
        return range;
    }

    public boolean isInBattlefield(Point2D.Double loc, double bounds) {
        boolean ret = true;
        if (loc.getX() > this.bot.getBattleFieldWidth() - bounds) {
            ret = false;
        } else if (loc.getX() < bounds) {
            ret = false;
        } else if (loc.getY() > this.bot.getBattleFieldHeight() - bounds) {
            ret = false;
        } else if (loc.getY() < bounds) {
            ret = false;
        }
        return ret;
    }

    public void doSurfing() {
        EnemyWave surfWave = this.getClosestSurfableWave();
        if (surfWave == null) {
            return;
        }
        int goToBin = -1;
        double goToBinDanger = Double.POSITIVE_INFINITY;
        double goToBinDist = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < BINS) {
            Point2D.Double binLoc = WaveSurfingModule.project(surfWave.fireLocation, this.binToRad(i, surfWave), surfWave.fireLocation.distance(this._myLocation));
            Point2D.Double goToLoc = WaveSurfingModule.project(surfWave.fireLocation, this.binToRad(i, surfWave), 400.0);
            if (binLoc.distance(this._myLocation) <= this.robotRange(this.getTimeTillHit(surfWave)) && this.isInBattlefield(goToLoc, 30.0) && _surfStats[i] <= goToBinDanger && (_surfStats[i] != goToBinDanger || !(goToLoc.distance(this._myLocation) > goToBinDist))) {
                goToBin = i;
                goToBinDanger = _surfStats[i];
                goToBinDist = goToLoc.distance(this._myLocation);
            }
            ++i;
        }
        if (goToBin == -1) {
            return;
        }
        Point2D.Double goToLoc = WaveSurfingModule.project(surfWave.fireLocation, this.binToRad(goToBin, surfWave), 400.0);
        this.goTo(goToLoc);
        this._lastGoToLocation = goToLoc;
        this.bot.out.println("new goToLoc: " + goToLoc.toString());
        this.bot.out.println("new goToBin: " + goToBin);
        this.bot.out.println("new goToBinDanger: " + goToBinDanger);
        this.bot.out.println("new goToBinDist: " + goToBinDist);
        this.bot.out.println("binToDeg(goToBin): " + this.binToDeg(goToBin, surfWave));
        this.bot.out.println();
    }

    @Override
    public void onHitByBullet(HitByBulletEvent e) {
        if (!this._enemyWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            EnemyWave hitWave = null;
            int x = 0;
            while (x < this._enemyWaves.size()) {
                EnemyWave ew = this._enemyWaves.get(x);
                if (Math.abs(ew.distanceTraveled - this._myLocation.distance(ew.fireLocation)) < 50.0 && Math.abs(WaveSurfingModule.bulletVelocity(e.getBullet().getPower()) - ew.bulletVelocity) < 0.001) {
                    hitWave = ew;
                    break;
                }
                ++x;
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
                this._enemyWaves.remove(this._enemyWaves.lastIndexOf(hitWave));
            }
        }
        _oppEnergy += Rules.getBulletHitBonus((double)e.getPower());
    }

    @Override
    public void onHitWall(HitWallEvent e) {
    }

    @Override
    public void onCustomEvent(CustomEvent e) {
    }

    @Override
    public void onDeath(DeathEvent e) {
    }

    @Override
    public void onSkippedTurn(SkippedTurnEvent event) {
    }

    @Override
    public void onBattleEnded(BattleEndedEvent evnt) {
    }

    @Override
    public void onBulletHit(BulletHitEvent e) {
        _oppEnergy = e.getEnergy();
    }

    @Override
    public void onBulletHitBullet(BulletHitBulletEvent e) {
        if (!this._enemyWaves.isEmpty()) {
            Point2D.Double location = new Point2D.Double(e.getHitBullet().getX(), e.getHitBullet().getY());
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getHitBullet().getX(), e.getHitBullet().getY());
            EnemyWave hitWave = null;
            int x = 0;
            while (x < this._enemyWaves.size()) {
                EnemyWave ew = this._enemyWaves.get(x);
                if (Math.abs(ew.distanceTraveled - location.distance(ew.fireLocation)) < 50.0 && Math.abs(WaveSurfingModule.bulletVelocity(e.getHitBullet().getPower()) - ew.bulletVelocity) < 0.001) {
                    hitWave = ew;
                    break;
                }
                ++x;
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
                this._enemyWaves.remove(this._enemyWaves.lastIndexOf(hitWave));
            }
        }
    }

    @Override
    public void onBulletMissed(BulletMissedEvent evnt) {
    }

    @Override
    public void onHitRobot(HitRobotEvent evnt) {
    }

    @Override
    public void onKeyPressed(KeyEvent e) {
    }

    @Override
    public void onKeyReleased(KeyEvent e) {
    }

    @Override
    public void onKeyTyped(KeyEvent e) {
    }

    @Override
    public void onMouseClicked(MouseEvent e) {
    }

    @Override
    public void onMouseDragged(MouseEvent e) {
    }

    @Override
    public void onMouseEntered(MouseEvent e) {
    }

    @Override
    public void onMouseExited(MouseEvent e) {
    }

    @Override
    public void onMouseMoved(MouseEvent e) {
    }

    @Override
    public void onMousePressed(MouseEvent e) {
    }

    @Override
    public void onMouseReleased(MouseEvent e) {
    }

    @Override
    public void onMouseWheelMoved(MouseWheelEvent e) {
    }

    public static void drawCirlce(Graphics2D g, Point2D.Double position, double radius) {
        g.drawOval((int)(position.getX() - radius), (int)(position.getY() - radius), (int)(2.0 * radius), (int)(2.0 * radius));
    }

    public static void fillCirlce(Graphics2D g, Point2D.Double position, double radius) {
        g.fillOval((int)(position.getX() - radius), (int)(position.getY() - radius), (int)(2.0 * radius), (int)(2.0 * radius));
    }

    @Override
    public void onPaint(Graphics2D g) {
        Color c = g.getColor();
        g.setColor(Color.LIGHT_GRAY);
        Iterator<EnemyWave> iterator = this._enemyWaves.iterator();
        while (iterator.hasNext()) {
            EnemyWave o;
            EnemyWave ew = o = iterator.next();
            WaveSurfingModule.drawCirlce(g, ew.fireLocation, 10.0);
            WaveSurfingModule.drawCirlce(g, ew.fireLocation, ew.distanceTraveled);
            g.drawLine((int)ew.fireLocation.getX(), (int)ew.fireLocation.getY(), (int)WaveSurfingModule.project(ew.fireLocation, ew.directAngle, ew.distanceTraveled).getX(), (int)WaveSurfingModule.project(ew.fireLocation, ew.directAngle, ew.distanceTraveled).getY());
            int i = 0;
            while (i < BINS) {
                double danger = _surfStats[i];
                g.setColor(new Color(Math.min(255, (int)(danger * 100.0)), 0, 0));
                double angle = Math.toRadians((double)i * (360.0 / (double)BINS) - 180.0);
                WaveSurfingModule.fillCirlce(g, WaveSurfingModule.project(ew.fireLocation, angle += ew.directAngle, ew.distanceTraveled), 5.0);
                double x = WaveSurfingModule.project(ew.fireLocation, angle, ew.distanceTraveled).getX();
                double y = WaveSurfingModule.project(ew.fireLocation, angle, ew.distanceTraveled).getY();
                g.setColor(Color.WHITE);
                g.drawString(String.valueOf(i), (int)x, (int)y);
                ++i;
            }
        }
        if (this._lastGoToLocation != null) {
            g.setColor(Color.GREEN);
            WaveSurfingModule.drawCirlce(g, this._lastGoToLocation, 10.0);
        }
        g.setColor(c);
    }

    @Override
    public void onRobotDeath(RobotDeathEvent event) {
    }

    @Override
    public void onRoundEnded(RoundEndedEvent event) {
    }

    @Override
    public void onStatus(StatusEvent e) {
    }

    @Override
    public void onWin(WinEvent event) {
    }

    class EnemyWave {
        Point2D.Double fireLocation;
        long fireTime;
        double bulletVelocity;
        double directAngle;
        double distanceTraveled;
        int direction;
    }
}

