/*
 * Decompiled with CFR 0.152.
 */
package rampancy.util.data.segmentTree;

import java.util.Arrays;
import rampancy.util.RRobotState;
import rampancy.util.RUtil;
import rampancy.util.data.segmentArray.RSegmentFunction;
import rampancy.util.data.segmentTree.RSegmentTree;

public class RSTNode {
    private RSegmentTree rootReference;
    private RSegmentFunction segmentFunction;
    private RSTNode[] branches;
    private double[] guessFactors;
    private boolean hasBranched;
    private int segmentSize;
    private int visits;
    private int depth;

    public static void updateGuessFactors(RSTNode node, int guessFactorIndex, double weight, int rollDepth) {
        node.noteVisit();
        int visits = node.getVisitCount();
        double[] guessFactors = node.getGuessFactors();
        guessFactors[guessFactorIndex] = RUtil.rollingAvg(guessFactors[guessFactorIndex], 1.0, Math.min(visits, rollDepth), weight);
        int i = 0;
        while (i < guessFactors.length) {
            if (i != guessFactorIndex) {
                guessFactors[i] = RUtil.rollingAvg(guessFactors[i], 1.0 / (Math.pow(guessFactorIndex - i, 2.0) + 1.0), Math.min(visits, rollDepth), weight);
            }
            ++i;
        }
    }

    public RSTNode(RSegmentFunction segmentFunction, int segmentSize) {
        this.segmentFunction = segmentFunction;
        this.segmentSize = segmentSize;
    }

    public RSTNode(RSegmentFunction segmentFunction, int segmentSize, double[] seedFactors, int depth, int visits, RSegmentTree rootReference) {
        this.rootReference = rootReference;
        this.segmentFunction = segmentFunction;
        this.branches = new RSTNode[segmentSize];
        this.segmentSize = segmentSize;
        this.guessFactors = Arrays.copyOf(seedFactors, seedFactors.length);
        this.visits = visits;
        this.depth = depth;
    }

    public RSTNode newInstance(double[] seedFactors, int depth, RSegmentTree reference) {
        return new RSTNode(this.segmentFunction, this.segmentSize, seedFactors, depth, this.visits, reference);
    }

    public RSTNode getSegmentForState(RRobotState state) {
        if (this.hasBranched()) {
            int index = this.segmentFunction.getIndexForState(state, this.segmentSize);
            if (this.branches[index] == null) {
                RSTNode template = this.rootReference.getTemplateNodeForDepth(this.depth + 1);
                this.branches[index] = template.newInstance(this.guessFactors, this.depth + 1, this.rootReference);
            }
            return this.branches[index].getSegmentForState(state);
        }
        return this;
    }

    public int getSegmentSize() {
        return this.segmentSize;
    }

    public void setBranched() {
        this.hasBranched = true;
    }

    public boolean hasBranched() {
        if (!this.hasBranched) {
            this.hasBranched = this.segmentFunction != null && this.visits >= this.rootReference.getVisitsBeforeBranch();
        }
        return this.hasBranched;
    }

    public void noteVisit() {
        ++this.visits;
    }

    public int getVisitCount() {
        return this.visits;
    }

    public double[] getGuessFactors() {
        return this.guessFactors;
    }

    public int getBranchCount() {
        int count = 1;
        int i = 0;
        while (i < this.branches.length) {
            if (this.branches[i] != null) {
                count += this.branches[i].getBranchCount();
            }
            ++i;
        }
        return count;
    }

    public int getTerminalBranchCount(int maxDepth) {
        if (this.depth == maxDepth) {
            return 1;
        }
        int count = 0;
        int i = 0;
        while (i < this.branches.length) {
            if (this.branches[i] != null) {
                count += this.branches[i].getTerminalBranchCount(maxDepth);
            }
            ++i;
        }
        return count;
    }
}

