/*
 * Decompiled with CFR 0.152.
 */
package gre.svman4.morfeas;

import gre.svman4.morfeas.EnemyState;
import gre.svman4.morfeas.Gun;
import gre.svman4.useful.MotionState;
import java.awt.Color;
import java.awt.Graphics2D;
import robocode.Rules;

public class GuessFactorTargetingGun
extends Gun {
    @Override
    public Color getColor() {
        return Color.GREEN;
    }

    public Color getColor(double lower, double val, double higher) {
        double range = higher - lower;
        double value = Math.min(range, Math.max(val - lower, 0.0));
        double H = (range - value) / range * 0.4;
        double S = 0.9;
        double B = 0.9;
        return Color.getHSBColor((float)H, (float)S, (float)B);
    }

    @Override
    public double getFiringAngle(MotionState shooter, EnemyState enemy, double bulletPower) {
        double bulletVelocity = Rules.getBulletSpeed((double)bulletPower);
        float[] gunBuffer = enemy.getGunCurrentStatus(shooter.distance(enemy), enemy.velocity, enemy.relativePosition, enemy.moveTime);
        int mostVisited = (gunBuffer.length - 1) / 2;
        for (int i = 0; i < gunBuffer.length; ++i) {
            if (!(gunBuffer[i] > gunBuffer[mostVisited])) continue;
            mostVisited = i;
        }
        double binWidth = enemy.getMaxEscapeAngle(bulletVelocity) / (double)((gunBuffer.length - 1) / 2);
        double angle = (double)enemy.lateralDirection * binWidth * (double)(mostVisited - (gunBuffer.length - 1) / 2);
        return shooter.getAngleTo(enemy) + angle;
    }

    @Override
    public String getName() {
        return "GuessFactorTargeting";
    }

    @Override
    public void onPaint(Graphics2D g) {
    }
}

